/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.internal.docker.launcher.ConnectionListener;
import org.eclipse.cdt.internal.docker.launcher.ILaunchConstants;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class LaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        this.searchAndLaunch(new Object[]{editor.getEditorInput()}, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    public void launch(IBinary bin, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(bin, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(ILaunchConstants.LAUNCH_ID);
    }

    private void searchAndLaunch(final Object[] elements, String mode) {
        if (elements != null && elements.length > 0) {
            IBinary bin = null;
            if (elements.length == 1 && elements[0] instanceof IBinary) {
                bin = (IBinary)elements[0];
            } else {
                final ArrayList<IBinary> results = new ArrayList<IBinary>();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getActiveWorkbenchShell());
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InterruptedException {
                        int nElements = elements.length;
                        pm.beginTask(Messages.LaunchShortcut_Looking_for_executables, nElements);
                        try {
                            SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
                            int i = 0;
                            while (i < nElements) {
                                ICProject cproject;
                                IResource r;
                                if (elements[i] instanceof IAdaptable && (r = (IResource)((IAdaptable)elements[i]).getAdapter(IResource.class)) != null && (cproject = CoreModel.getDefault().create(r.getProject())) != null) {
                                    try {
                                        IBinary[] bins;
                                        IBinary[] iBinaryArray = bins = cproject.getBinaryContainer().getBinaries();
                                        int n = bins.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IBinary bin = iBinaryArray[n2];
                                            if (bin.isExecutable()) {
                                                results.add(bin);
                                            }
                                            ++n2;
                                        }
                                    }
                                    catch (CModelException cModelException) {
                                        // empty catch block
                                    }
                                }
                                if (pm.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                sub.done();
                                ++i;
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                };
                try {
                    dialog.run(true, true, runnable);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (InvocationTargetException e) {
                    this.handleFail(e.getMessage());
                    return;
                }
                int count = results.size();
                if (count == 0) {
                    this.handleFail(Messages.LaunchShortcut_Binary_not_found);
                } else {
                    bin = count > 1 ? this.chooseBinary(results, mode) : (IBinary)results.get(0);
                }
            }
            if (bin != null) {
                this.launch(bin, mode);
            }
        } else {
            this.handleFail(Messages.LaunchShortcut_no_project_selected);
        }
    }

    protected IBinary chooseBinary(List<IBinary> binList, String mode) {
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    return ((IBinary)element).getPath().lastSegment();
                }
                return super.getText(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuilder name = new StringBuilder();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getActiveWorkbenchShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements(binList.toArray());
        dialog.setTitle(Messages.LaunchShortcut_Launcher);
        dialog.setMessage(Messages.LaunchShortcut_Choose_a_local_application);
        dialog.setUpperListLabel(Messages.LaunchShortcut_Binaries);
        dialog.setLowerListLabel(Messages.LaunchShortcut_Qualifier);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IBinary)dialog.getFirstResult();
        }
        return null;
    }

    protected void handleFail(String message) {
        MessageDialog.openError((Shell)this.getActiveWorkbenchShell(), (String)Messages.LaunchShortcut_Launcher, (String)message);
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, String mode) {
        IDockerConnection[] connections;
        boolean containerBuildEnabled;
        IOptionalBuildProperties props;
        String containerBuild;
        IConfiguration cfg;
        ICConfigurationDescription cfgd;
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        IProject project = bin.getCProject().getProject();
        String connectionUri = null;
        String imageName = null;
        ICBuildConfiguration cbcfg = null;
        try {
            IBuildConfiguration buildConfig = project.getActiveBuildConfig();
            cbcfg = (ICBuildConfiguration)buildConfig.getAdapter(ICBuildConfiguration.class);
            if (cbcfg != null) {
                IToolChain toolChain = cbcfg.getToolChain();
                connectionUri = toolChain.getProperty("connection_uri");
                imageName = toolChain.getProperty("image_id");
            }
        }
        catch (CoreException buildConfig) {
            // empty catch block
        }
        if (cbcfg == null && (cfgd = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration()) != null && (cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd)) != null && (containerBuild = (props = cfg.getOptionalBuildProperties()).getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (containerBuildEnabled = Boolean.parseBoolean(containerBuild))) {
            connectionUri = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
            imageName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
        }
        if (connectionUri == null && (connections = DockerConnectionManager.getInstance().getConnections()) != null && connections.length > 0) {
            List images;
            connectionUri = connections[0].getUri();
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.docker.launcher");
            imageName = prefs.get("defaultImageForLaunch", null);
            if (imageName == null && (images = connections[0].getImages()) != null && images.size() > 0) {
                imageName = (String)((IDockerImage)images.get(0)).repoTags().get(0);
            }
        }
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                IPath programPath = CDebugUtils.getProgramPath((ILaunchConfiguration)config);
                String projectName = CDebugUtils.getProjectName((ILaunchConfiguration)config);
                IPath binPath = bin.getResource().getProjectRelativePath();
                if (projectName != null && projectName.equals(bin.getCProject().getProject().getName())) {
                    if (programPath != null) {
                        if (programPath.equals((Object)binPath) && connectionUri != null && connectionUri.equals(config.getAttribute(ILaunchConstants.ATTR_CONNECTION_URI, null)) && imageName != null && imageName.equals(config.getAttribute(ILaunchConstants.ATTR_IMAGE, null))) {
                            candidateConfigs.add(config);
                        }
                    } else if (cbcfg != null && candidateConfigs.isEmpty()) {
                        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                        this.populateLaunchConfiguration(wc, mode, bin, projectName, connectionUri, imageName);
                        wc.doSave();
                        candidateConfigs.add(config);
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DockerLaunchUIPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        configuration = candidateCount < 1 ? this.createConfiguration(bin, mode, true) : (candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : this.chooseConfiguration(candidateConfigs, mode));
        return configuration;
    }

    private void populateLaunchConfiguration(ILaunchConfigurationWorkingCopy wc, String mode, IBinary bin, String projectName, String connectionUri, String imageName) {
        IPreferenceStore preferenceStore = GdbUIPlugin.getDefault().getPreferenceStore();
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", preferenceStore.getString("defaultGdbCommand"));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", preferenceStore.getString("defaultGdbInit"));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", preferenceStore.getBoolean("defaultNonStop"));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_ON_FORK", false);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.TRACEPOINT_MODE", "TP_NORMAL_ONLY");
        wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", bin.getResource().getProjectRelativePath().toString());
        wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
        wc.setMappedResources(new IResource[]{bin.getResource(), bin.getResource().getProject()});
        wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.docker.launcher");
        Boolean keepPref = prefs.getBoolean("keepContainerAfterLaunch", false);
        wc.setAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, (Object)keepPref);
        if (mode.equals("debug")) {
            wc.setAttribute(ILaunchConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
            wc.setAttribute(ILaunchConstants.ATTR_GDBSERVER_PORT, "2345");
        }
        wc.setAttribute(ILaunchConstants.ATTR_CONNECTION_URI, connectionUri);
        wc.setAttribute(ILaunchConstants.ATTR_IMAGE, imageName);
    }

    protected ILaunchConfiguration createConfiguration(IBinary bin, String mode, boolean save) {
        String image;
        IDockerConnection connection;
        ILaunchConfigurationWorkingCopy wc;
        IProject project;
        Object config;
        block15: {
            List images;
            IEclipsePreferences prefs;
            String imageName;
            block14: {
                IDockerConnection[] connections;
                config = null;
                project = bin.getResource().getProject();
                boolean containerBuild = false;
                String connectionId = null;
                imageName = null;
                IBuildConfiguration buildConfig = project.getActiveBuildConfig();
                ICBuildConfiguration cbuildcfg = (ICBuildConfiguration)buildConfig.getAdapter(ICBuildConfiguration.class);
                if (cbuildcfg != null) {
                    IToolChain toolChain = cbuildcfg.getToolChain();
                    connectionId = toolChain.getProperty("connection_uri");
                    imageName = toolChain.getProperty("image_id");
                } else {
                    ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
                    IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
                    IOptionalBuildProperties options = cfg.getOptionalBuildProperties();
                    if (options != null) {
                        String containerBuildString = options.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement");
                        if (containerBuildString != null) {
                            containerBuild = Boolean.parseBoolean(options.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement"));
                        }
                        if (containerBuild) {
                            connectionId = options.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
                            imageName = options.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
                        }
                    }
                }
                ILaunchConfigurationType configType = this.getLaunchConfigType();
                wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(String.valueOf(bin.getResource().getName()) + (imageName != null ? "[" + imageName + "]" : "")));
                prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.docker.launcher");
                connection = null;
                if (connectionId != null) {
                    connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionId);
                }
                if (connection == null) {
                    connection = ConnectionListener.getInstance().getCurrentConnection();
                }
                if (connection == null && (connections = DockerConnectionManager.getInstance().getConnections()) != null && connections.length > 0) {
                    connection = connections[0];
                }
                if (connection != null) break block14;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.LaunchShortcut_Error_Launching, (String)Messages.LaunchShortcut_No_Connections);
                    }
                });
                return null;
            }
            image = imageName;
            if (image == null) {
                image = prefs.get("defaultImageForLaunch", null);
            }
            if (image == null && (images = connection.getImages()) != null && images.size() > 0) {
                image = (String)((IDockerImage)images.get(0)).repoTags().get(0);
            }
            if (image != null) break block15;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.LaunchShortcut_Error_Launching, (String)Messages.LaunchShortcut_No_Images);
                }
            });
            return null;
        }
        try {
            this.populateLaunchConfiguration(wc, mode, bin, project.getName(), connection.getUri(), image);
            config = save ? wc.doSave() : wc;
        }
        catch (CoreException e) {
            DockerLaunchUIPlugin.log(e);
        }
        return config;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.LaunchShortcut_Launch_Configuration_Selection);
        dialog.setMessage(Messages.LaunchShortcut_Choose_a_launch_configuration);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected Shell getActiveWorkbenchShell() {
        return DockerLaunchUIPlugin.getActiveWorkbenchShell();
    }
}

