/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class RepositoryCache {
    private final Map<File, Reference<Repository>> repositoryCache = new HashMap<File, Reference<Repository>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository lookupRepository(File gitDir) throws IOException {
        this.prune();
        File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            Repository d;
            Reference<Repository> r = this.repositoryCache.get(normalizedGitDir);
            Repository repository = d = r != null ? r.get() : null;
            if (d == null) {
                d = FileRepositoryBuilder.create((File)normalizedGitDir);
                this.repositoryCache.put(normalizedGitDir, new WeakReference<Repository>(d));
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(File gitDir) {
        if (gitDir == null) {
            return null;
        }
        this.prune();
        File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            Reference<Repository> r = this.repositoryCache.get(normalizedGitDir);
            return r != null ? r.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository[] getAllRepositories() {
        this.prune();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            for (Reference<Repository> reference : this.repositoryCache.values()) {
                Repository repository = reference.get();
                if (repository == null) continue;
                repositories.add(repository);
            }
        }
        return repositories.toArray(new Repository[0]);
    }

    public Repository getRepository(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return this.getRepository(location);
    }

    public Repository getRepository(IPath location) {
        Repository[] repositories = this.getAllRepositories();
        Repository repository = null;
        int largestSegmentCount = 0;
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository r = repositoryArray[n2];
            if (!r.isBare()) {
                Path repoPath = new Path(r.getWorkTree().getAbsolutePath());
                if (location != null && repoPath.isPrefixOf(location) && (repository == null || repoPath.segmentCount() > largestSegmentCount)) {
                    repository = r;
                    largestSegmentCount = repoPath.segmentCount();
                }
            }
            ++n2;
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune() {
        ArrayList<File> toRemove = new ArrayList<File>();
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            Iterator<Map.Entry<File, Reference<Repository>>> i = this.repositoryCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<File, Reference<Repository>> entry = i.next();
                Repository repository = entry.getValue().get();
                if (repository != null && repository.getDirectory().exists()) continue;
                i.remove();
                toRemove.add(entry.getKey());
            }
        }
        IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
        if (cache != null) {
            for (File f : toRemove) {
                cache.remove(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<File> gitDirs;
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            gitDirs = new ArrayList<File>(this.repositoryCache.keySet());
            this.repositoryCache.clear();
        }
        IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
        if (cache != null) {
            for (File f : gitDirs) {
                cache.remove(f);
            }
        }
    }
}

