/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.ui.actions.AbstractAutotoolsHandler;
import org.eclipse.cdt.internal.autotools.ui.actions.InvokeMessages;
import org.eclipse.cdt.internal.autotools.ui.actions.TwoInputDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Shell;

public class AutomakeHandler
extends AbstractAutotoolsHandler {
    private static final String DEFAULT_OPTION = "";
    private static final String DEFAULT_COMMAND = "automake";

    public Object execute(ExecutionEvent event) {
        return this.execute1(event);
    }

    @Override
    public void run(Shell activeShell) {
        IContainer container = this.getSelectedContainer();
        if (container == null) {
            return;
        }
        IPath execDir = this.getExecDir(container);
        String cwd = String.valueOf(InvokeMessages.getString("CWD")) + this.getCWD(container);
        TwoInputDialog optionDialog = new TwoInputDialog(activeShell, cwd, InvokeMessages.getString("InvokeAutomakeAction.windowTitle.options"), InvokeMessages.getString("InvokeAutomakeAction.message.options.otherOptions"), InvokeMessages.getString("InvokeAutomakeAction.message.options.makeTargets"), DEFAULT_OPTION, null);
        optionDialog.open();
        String rawArgList = optionDialog.getValue();
        List<String> optionsList = this.separateOptions(rawArgList);
        rawArgList = optionDialog.getSecondValue();
        List<String> targetList = this.separateTargets(rawArgList);
        if (targetList == null) {
            this.showError(InvokeMessages.getString("InvokeAction.execute.windowTitle.error"), InvokeMessages.getString("InvokeAction.windowTitle.quoteError"));
            return;
        }
        ArrayList<String> argumentList = new ArrayList<String>();
        argumentList.addAll(optionsList);
        argumentList.addAll(targetList);
        IProject project = container.getProject();
        String automakeCommand = null;
        try {
            automakeCommand = project.getPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (automakeCommand == null) {
            automakeCommand = DEFAULT_COMMAND;
        }
        this.executeConsoleCommand(DEFAULT_COMMAND, automakeCommand, argumentList, execDir);
    }
}

