/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskSelectionDialog;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TaskSelectionDialogWithRandom
extends TaskSelectionDialog {
    private static final int RANDOM_ID = 1025;
    private Button randomTaskButton;
    private boolean activateTask = false;

    public TaskSelectionDialogWithRandom(Shell parent, boolean multi) {
        super(parent, multi);
    }

    public TaskSelectionDialogWithRandom(Shell parent) {
        super(parent);
    }

    @Override
    protected void createAdditionalButtons(Composite parent) {
        this.randomTaskButton = this.createButton(parent, 1025, Messages.TaskSelectionDialog_Random_Task, false);
        this.randomTaskButton.setToolTipText(Messages.TaskSelectionDialogWithRandom_Feeling_Lazy_Tooltip);
        this.randomTaskButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent se) {
                try {
                    HashSet<ITask> selectedTasks = new HashSet<ITask>();
                    Set allScheduled = ((TaskActivityManager)TasksUi.getTaskActivityManager()).getAllScheduledTasks();
                    if (!allScheduled.isEmpty()) {
                        selectedTasks.addAll(allScheduled);
                        selectedTasks.retainAll(TasksUiPlugin.getTaskList().getAllTasks());
                    }
                    if (selectedTasks.isEmpty()) {
                        selectedTasks.addAll(TasksUiPlugin.getTaskList().getAllTasks());
                    }
                    HashSet<ITask> potentialTasks = new HashSet<ITask>();
                    this.addLowEnergyTasks(selectedTasks, potentialTasks, ITask.PriorityLevel.P5);
                    this.addLowEnergyTasks(selectedTasks, potentialTasks, ITask.PriorityLevel.P4);
                    if (potentialTasks.isEmpty()) {
                        this.addLowEnergyTasks(selectedTasks, potentialTasks, ITask.PriorityLevel.P3);
                    }
                    if (potentialTasks.isEmpty()) {
                        this.addLowEnergyTasks(selectedTasks, potentialTasks, ITask.PriorityLevel.P2);
                    }
                    int randomTaskIndex = new Random().nextInt(potentialTasks.size());
                    ITask randomTask = potentialTasks.toArray(new ITask[potentialTasks.size()])[randomTaskIndex];
                    if (TaskSelectionDialogWithRandom.this.activateTask) {
                        TasksUi.getTaskActivityManager().activateTask(randomTask);
                    }
                    TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)randomTask);
                    TaskSelectionDialogWithRandom.this.close();
                }
                catch (Exception e) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.TaskSelectionDialogWithRandom_Feeling_Lazy_Error_Title, (String)Messages.TaskSelectionDialogWithRandom_Feeling_Lazy_Error);
                }
            }

            private void addLowEnergyTasks(Set<ITask> selectedTasks, Set<ITask> potentialTasks, ITask.PriorityLevel priorityLevel) {
                for (ITask task : selectedTasks) {
                    if (!task.getSynchronizationState().isSynchronized() || task.isCompleted() || !priorityLevel.toString().equals(task.getPriority())) continue;
                    potentialTasks.add(task);
                }
            }
        });
    }

    public boolean isActivateTask() {
        return this.activateTask;
    }

    public void setActivateTask(boolean activateTask) {
        this.activateTask = activateTask;
    }
}

