/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence_7_7;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FinalLaunchSequence_7_12
extends FinalLaunchSequence_7_7 {
    private IGDBControl fCommandControl;
    private CommandFactory fCommandFactory;
    private Map<String, Object> fAttributes;
    private IGDBBackend fGdbBackEnd;

    public FinalLaunchSequence_7_12(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        this.fAttributes = attributes;
    }

    @Override
    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.add(orderList.indexOf("stepInitializeFinalLaunchSequence_7_7") + 1, "stepInitializeFinalLaunchSequence_7_12");
            orderList.add(orderList.indexOf("stepSourceGDBInitFile") + 1, "stepSetTargetAsync");
            orderList.add(orderList.indexOf("stepSetTargetAsync") + 1, "stepSetRecordFullStopAtLimit");
            return orderList.toArray(new String[orderList.size()]);
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepInitializeFinalLaunchSequence_7_12(RequestMonitor rm) {
        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.getSession().getId());
        this.fCommandControl = (IGDBControl)tracker.getService(IGDBControl.class);
        this.fGdbBackEnd = (IGDBBackend)tracker.getService(IGDBBackend.class);
        tracker.dispose();
        if (this.fCommandControl == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Cannot obtain service", null));
            return;
        }
        this.fCommandFactory = this.fCommandControl.getCommandFactory();
        rm.done();
    }

    private boolean isNonStop() {
        boolean isNonStop = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.NON_STOP", (Object)LaunchUtils.getIsNonStopModeDefault());
        return isNonStop;
    }

    @ReflectionSequence.Execute
    public void stepSetTargetAsync(final RequestMonitor requestMonitor) {
        if (this.fCommandControl == null || this.fGdbBackEnd == null) {
            requestMonitor.done();
            return;
        }
        boolean asyncOn = false;
        if (this.isNonStop() || this.fGdbBackEnd.isFullGdbConsoleSupported()) {
            asyncOn = true;
        }
        this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetTargetAsync(this.fCommandControl.getContext(), asyncOn), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

            protected void handleError() {
                requestMonitor.done();
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepSetRecordFullStopAtLimit(final RequestMonitor requestMonitor) {
        this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetRecordFullStopAtLimit(this.fCommandControl.getContext(), false), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

            protected void handleError() {
                requestMonitor.done();
            }
        });
    }

    @Override
    @ReflectionSequence.Execute
    public void stepSetNonStop(RequestMonitor requestMonitor) {
        if (this.isNonStop()) {
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetNonStop(this.fCommandControl.getContext(), true), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        } else {
            requestMonitor.done();
        }
    }
}

