/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.io.File;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.CommonUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.UserCallback;
import org.eclipse.oomph.util.XMLUtil;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PreferenceTaskImpl
extends SetupTaskImpl
implements PreferenceTask {
    protected static final String KEY_EDEFAULT = null;
    protected String key = KEY_EDEFAULT;
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    private transient PreferencesUtil.PreferenceProperty preferenceProperty;
    private transient PreferenceHandler preferenceHandler;

    protected PreferenceTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupPackage.Literals.PREFERENCE_TASK;
    }

    public String getKey() {
        return this.key;
    }

    public void setKeyGen(String newKey) {
        String oldKey = this.key;
        this.key = newKey;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldKey, (Object)this.key));
        }
    }

    public void setKey(String newKey) {
        this.setKeyGen(CommonUtil.intern((String)newKey));
        this.preferenceHandler = null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldValue, (Object)this.value));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getKey();
            }
            case 11: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setKey((String)newValue);
                return;
            }
            case 11: {
                this.setValue((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setKey(KEY_EDEFAULT);
                return;
            }
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return KEY_EDEFAULT == null ? this.key != null : !KEY_EDEFAULT.equals(this.key);
            }
            case 11: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (key: ");
        result.append(this.key);
        result.append(", value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public int getPriority() {
        return this.getPreferenceHandler().getPriority();
    }

    private PreferenceHandler getPreferenceHandler() {
        if (this.preferenceHandler == null) {
            this.preferenceHandler = PreferenceHandler.getHandler(this.getKey());
        }
        return this.preferenceHandler;
    }

    public Object getOverrideToken() {
        return this.createToken(this.getKey());
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        PreferenceTask overriddenPeferenceTask = (PreferenceTask)overriddenSetupTask;
        PreferenceHandler preferenceHandler = this.getPreferenceHandler();
        if (preferenceHandler.isNeeded(overriddenPeferenceTask.getValue(), this.getValue())) {
            this.setValue(preferenceHandler.merge());
        }
    }

    public int getProgressMonitorWork() {
        return 0;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        if (StringUtil.isEmpty((String)this.key)) {
            return false;
        }
        this.preferenceProperty = new PreferencesUtil.PreferenceProperty(this.key);
        String oldValue = this.preferenceProperty.getEffectiveProperty().get(null);
        String newValue = this.getValue();
        return this.getPreferenceHandler().isNeeded(oldValue, newValue);
    }

    public void perform(SetupTaskContext context) throws Exception {
        String key = this.getKey();
        URI uri = PreferencesFactory.eINSTANCE.createURI(key);
        if ("project".equals(uri.authority()) && !ResourcesPlugin.getWorkspace().getRoot().getProject(URI.decode((String)uri.segment(0))).isAccessible()) {
            context.log("Ignoring preference " + key + " = " + this.value);
            return;
        }
        String value = this.getValue();
        if (value != null && value.indexOf(10) != -1) {
            context.log(value);
        }
        this.performUI(context, new SetupTaskImpl.RunnableWithContext(){

            public void run(SetupTaskContext context) throws Exception {
                String mergedValue = PreferenceTaskImpl.this.preferenceHandler.merge();
                PreferenceTaskImpl.this.preferenceProperty.set(mergedValue);
                PreferenceTaskImpl.this.preferenceHandler.apply(context);
            }
        });
        Preferences node = this.preferenceProperty.getNode();
        node.flush();
    }

    public boolean execute(final UserCallback callback) throws Exception {
        SetupTaskContext context = new SetupTaskContext(){

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void log(String line) {
            }

            @Override
            public void log(String line, ProgressLog.Severity severity) {
            }

            @Override
            public void log(String line, boolean filter) {
            }

            @Override
            public void log(String line, boolean filter, ProgressLog.Severity severity) {
            }

            @Override
            public void log(IStatus status) {
            }

            @Override
            public void log(Throwable t) {
            }

            @Override
            public void task(SetupTask setupTask) {
            }

            @Override
            public void setTerminating() {
            }

            @Override
            public IProgressMonitor getProgressMonitor(boolean working) {
                return new NullProgressMonitor();
            }

            @Override
            public SetupPrompter getPrompter() {
                return new SetupPrompter(){

                    @Override
                    public OS getOS() {
                        return OS.INSTANCE;
                    }

                    @Override
                    public String getVMPath() {
                        return null;
                    }

                    @Override
                    public UserCallback getUserCallback() {
                        return callback;
                    }

                    @Override
                    public String getValue(VariableTask variable) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean promptVariables(List<? extends SetupTaskContext> performers) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Trigger getTrigger() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void checkCancelation() {
            }

            @Override
            public boolean isSelfHosting() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isPerforming() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isOffline() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isMirrors() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isRestartNeeded() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setRestartNeeded(String reason) {
            }

            @Override
            public User getUser() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Workspace getWorkspace() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Installation getInstallation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public File getInstallationLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public File getProductLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public File getProductConfigurationLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public File getWorkspaceLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getRelativeProductFolder() {
                throw new UnsupportedOperationException();
            }

            @Override
            public OS getOS() {
                throw new UnsupportedOperationException();
            }

            @Override
            public URIConverter getURIConverter() {
                throw new UnsupportedOperationException();
            }

            @Override
            public URI redirect(URI uri) {
                return uri;
            }

            @Override
            public String redirect(String uri) {
                return uri;
            }

            @Override
            public Object get(Object key) {
                return null;
            }

            @Override
            public Object put(Object key, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<Object> keySet() {
                return Collections.emptySet();
            }

            @Override
            public String getLauncherName() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean matchesFilterContext(String filter) {
                return false;
            }
        };
        if (this.isNeeded(context)) {
            this.perform(context);
            return true;
        }
        return false;
    }

    public static class CDTProfileChoicePreferenceHandler
    extends ProfileChoicePreferenceHandler {
        public CDTProfileChoicePreferenceHandler(URI key) {
            super(key);
        }

        protected PreferencesUtil.PreferenceProperty getProfilesPreferenceProperty() {
            return new PreferencesUtil.PreferenceProperty("/instance/org.eclipse.cdt.ui/org.eclipse.cdt.ui.formatterprofiles");
        }

        protected PreferencesUtil.PreferenceProperty getKeyPreferenceProperty(String propertyKey) {
            return new PreferencesUtil.PreferenceProperty("/instance/org.eclipse.cdt.core/" + propertyKey);
        }
    }

    public static class ContentTypeCharsetPreferenceHandler
    extends PreferenceHandler {
        public ContentTypeCharsetPreferenceHandler(URI key) {
            super(key);
        }

        public void apply(SetupTaskContext context) {
            String contentTypeName = this.key.segment(this.key.segmentCount() - 2);
            IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeName);
            if (contentType != null) {
                try {
                    contentType.setDefaultCharset(this.newValue);
                }
                catch (CoreException ex) {
                    context.log(ex);
                }
            }
        }
    }

    public static class ContentTypeFileExtensionPreferenceHandler
    extends ListPreferenceHandler {
        private final int type;

        public ContentTypeFileExtensionPreferenceHandler(URI key) {
            super(key, "([^,]+)", "([^,]+)", ",");
            this.type = "file-extensions".equals(key.lastSegment()) ? 8 : 4;
        }

        public void apply(SetupTaskContext context) {
            String contentTypeName = this.key.segment(this.key.segmentCount() - 2);
            IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeName);
            if (contentType != null) {
                for (String key : this.changedItems) {
                    try {
                        contentType.addFileSpec(key, this.type);
                    }
                    catch (CoreException ex) {
                        context.log(ex);
                    }
                }
            }
        }
    }

    public static class IgnoredPreferenceHandler
    extends PreferenceHandler {
        public IgnoredPreferenceHandler(URI key) {
            super(key);
        }

        public boolean isIgnored() {
            return true;
        }
    }

    public static class JDTProfileChoicePreferenceHandler
    extends ProfileChoicePreferenceHandler {
        private String profileType;

        public JDTProfileChoicePreferenceHandler(URI key, String profileType) {
            super(key);
            this.profileType = profileType;
        }

        protected PreferencesUtil.PreferenceProperty getProfilesPreferenceProperty() {
            return new PreferencesUtil.PreferenceProperty("/instance/org.eclipse.jdt.ui/org.eclipse.jdt.ui." + this.profileType + "profiles");
        }

        protected PreferencesUtil.PreferenceProperty getKeyPreferenceProperty(String propertyKey) {
            return new PreferencesUtil.PreferenceProperty("/instance/org.eclipse.jdt.core/" + propertyKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListPreferenceHandler
    extends PreferenceHandler {
        protected final Pattern itemPattern;
        protected final Pattern keyPattern;
        protected final String separator;
        protected final Set<String> changedItems = new LinkedHashSet<String>();
        protected final Map<String, Item> oldItems = new LinkedHashMap<String, Item>();
        protected final Map<String, Item> newItems = new LinkedHashMap<String, Item>();
        protected final Map<String, Item> mergedItems = new LinkedHashMap<String, Item>();
        private boolean keyCollision;

        public ListPreferenceHandler(URI key, String itemPattern, String keyPattern, String separator) {
            super(key);
            this.itemPattern = Pattern.compile(itemPattern);
            this.keyPattern = Pattern.compile(keyPattern);
            this.separator = separator;
        }

        @Override
        protected boolean isExcluded() {
            return false;
        }

        @Override
        protected boolean isNeeded() {
            return super.isNeeded() && !this.keyCollision;
        }

        @Override
        public String merge() {
            this.keyCollision = false;
            this.changedItems.clear();
            this.oldItems.clear();
            this.newItems.clear();
            this.mergedItems.clear();
            this.oldItems.putAll(this.getItems(this.oldValue));
            this.newItems.putAll(this.getItems(this.newValue));
            if (this.oldItems.isEmpty()) {
                this.changedItems.addAll(this.newItems.keySet());
                this.mergedItems.putAll(this.newItems);
                return this.newValue;
            }
            this.mergedItems.putAll(this.oldItems);
            for (Map.Entry<String, Item> entry : this.newItems.entrySet()) {
                Item newItem;
                String entryKey = entry.getKey();
                Item oldItem = this.mergedItems.put(entryKey, newItem = entry.getValue());
                if (oldItem != null && oldItem.getValue().equals(newItem.getValue())) continue;
                this.changedItems.add(entryKey);
            }
            ArrayList<Item> oldItemValues = new ArrayList<Item>(this.oldItems.values());
            StringBuilder result = new StringBuilder(((Item)oldItemValues.get(0)).getHead());
            Iterator<Item> it = this.mergedItems.values().iterator();
            while (it.hasNext()) {
                Item item = it.next();
                result.append(item.getValue());
                if (!it.hasNext()) continue;
                result.append(this.separator);
            }
            result.append(((Item)oldItemValues.get(oldItemValues.size() - 1)).getTail());
            return result.toString();
        }

        @Override
        public String delta() {
            this.merge();
            if (this.oldItems.isEmpty()) {
                return this.newValue;
            }
            ArrayList<Item> itemValues = new ArrayList<Item>(this.oldItems.values());
            StringBuilder result = new StringBuilder(((Item)itemValues.get(0)).getHead());
            Iterator<String> it = this.changedItems.iterator();
            while (it.hasNext()) {
                Item item = this.mergedItems.get(it.next());
                result.append(item.getValue());
                if (!it.hasNext()) continue;
                result.append(this.separator);
            }
            result.append(((Item)itemValues.get(itemValues.size() - 1)).getTail());
            return result.toString();
        }

        private Map<String, Item> getItems(String value) {
            LinkedHashMap<String, Item> items = new LinkedHashMap<String, Item>();
            if (value != null) {
                Matcher matcher = this.itemPattern.matcher(value);
                while (matcher.find()) {
                    String group = matcher.group(1);
                    Matcher keyMatcher = this.keyPattern.matcher(group);
                    if (!keyMatcher.find()) continue;
                    StringBuilder key = new StringBuilder();
                    int i = 1;
                    int count = keyMatcher.groupCount();
                    while (i <= count) {
                        if (i > 1) {
                            key.append("_._");
                        }
                        key.append(keyMatcher.group(i));
                        ++i;
                    }
                    Item oldItem = items.put(key.toString(), new Item(value, matcher.start(1), matcher.end(1)));
                    if (oldItem == null) continue;
                    this.keyCollision = true;
                }
            }
            return items;
        }

        public static final class Item {
            private final String value;
            private final int start;
            private final int end;

            public Item(String value, int start, int end) {
                this.value = value;
                this.start = start;
                this.end = end;
            }

            public String getValue() {
                return this.value.substring(this.start, this.end);
            }

            public String getHead() {
                return this.value.substring(0, this.start);
            }

            public String getTail() {
                return this.value.substring(this.end);
            }

            public String toString() {
                return this.getValue();
            }
        }
    }

    public static class PreferenceHandler {
        protected URI key;
        protected String oldValue;
        protected String newValue;

        static {
            PreferenceHandlerFactoryRegistry registry = (PreferenceHandlerFactoryRegistry)Factory.Registry.INSTANCE;
            registry.put(URI.createURI((String)"//"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new PreferenceHandler(key);
                }
            });
            PreferenceHandler.registerListHandlerFactory("//instance/org.eclipse.ui.workbench/ENABLED_DECORATORS", ',', ':');
            PreferenceHandler.registerListHandlerFactory("//instance/org.eclipse.ui.navigator/org.eclipse.ui.navigator.ProjectExplorer.activatedExtensions", ';', '=');
            PreferenceHandler.registerListHandlerFactory("//instance/org.eclipse.ui.navigator/org.eclipse.ui.navigator.ProjectExplorer.filterActivation", ':');
            registry.put(URI.createURI((String)"//instance/org.eclipse.ui.workbench/"), new Factory(){

                public PreferenceHandler create(URI key) {
                    String lastSegment = key.lastSegment();
                    if ("editors".equals(lastSegment)) {
                        return new IgnoredPreferenceHandler(key);
                    }
                    if ("resourcetypes".equals(lastSegment)) {
                        return new XMLPreferenceHandler(key, "info", new String[]{"extension", "name"}, null);
                    }
                    if ("org.eclipse.ui.commands".equals(lastSegment)) {
                        return new PreferenceHandler(key){

                            protected boolean isExcluded() {
                                return false;
                            }
                        };
                    }
                    return new PreferenceHandler(key);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.core.runtime/content-types/"), new Factory(){

                public PreferenceHandler create(URI key) {
                    if (key.segmentCount() == 4) {
                        String property = key.lastSegment();
                        if (property.equals("file-extensions") || property.equals("file-names")) {
                            return new ContentTypeFileExtensionPreferenceHandler(key);
                        }
                        if (property.equals("charset")) {
                            return new ContentTypeCharsetPreferenceHandler(key);
                        }
                    }
                    return new PreferenceHandler(key);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.jdt.core/"), new Factory(){

                public PreferenceHandler create(URI key) {
                    String lastSegment = key.lastSegment();
                    if (lastSegment.startsWith("org.eclipse.jdt.core.formatter.")) {
                        return new IgnoredPreferenceHandler(key);
                    }
                    return new PreferenceHandler(key);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.jdt.ui/"), new Factory(){

                public PreferenceHandler create(URI key) {
                    String lastSegment = key.lastSegment();
                    if (lastSegment.startsWith("cleanup.")) {
                        return new PreferenceHandler(key){

                            public boolean isIgnored() {
                                return true;
                            }
                        };
                    }
                    return new PreferenceHandler(key);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.jdt.ui/org.eclipse.jdt.ui.formatterprofiles"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new XMLPreferenceHandler(key, "profile", new String[]{"name"}, null);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.jdt.ui/formatter_profile"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new JDTProfileChoicePreferenceHandler(key, "formatter");
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.jdt.ui/org.eclipse.jdt.ui.cleanupprofiles"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new XMLPreferenceHandler(key, "profile", new String[]{"name"}, null);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.jdt.ui/cleanup_profile"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new JDTProfileChoicePreferenceHandler(key, "cleanup");
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.team.core/file_types"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new TeamFileModePreferenceHandler(key);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.team.core/cvs_mode_for_file_without_extensions"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new TeamFileModePreferenceHandler(key);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.jdt.ui/org.eclipse.jdt.ui.text.custom_templates"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new XMLPreferenceHandler(key, "template", new String[]{"id"}, null);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.jdt.ui/org.eclipse.jdt.ui.text.custom_code_templates"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new XMLPreferenceHandler(key, "template", new String[]{"context", "description", "name"}, null);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.ant.ui/org.eclipse.ant.ui.customtemplates"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new XMLPreferenceHandler(key, "template", new String[]{"context", "description", "name"}, new String[]{"id"});
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.core.variables/org.eclipse.core.variables.valueVariables"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new XMLPreferenceHandler(key, "valueVariable", new String[]{"name"}, null);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.m2e.editor.xml/org.eclipse.m2e.editor.xml.templates"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new XMLPreferenceHandler(key, "template", new String[]{"context", "description", "name"}, new String[]{"id"});
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.cdt.ui/org.eclipse.cdt.ui.formatterprofiles"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new XMLPreferenceHandler(key, "profile", new String[]{"name"}, null);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.cdt.ui/formatter_profile"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new CDTProfileChoicePreferenceHandler(key);
                }
            });
            registry.put(URI.createURI((String)"//instance/org.eclipse.cdt.core/"), new Factory(){

                public PreferenceHandler create(URI key) {
                    String lastSegment = key.lastSegment();
                    if (lastSegment.startsWith("org.eclipse.cdt.core.formatter.")) {
                        return new IgnoredPreferenceHandler(key);
                    }
                    return new PreferenceHandler(key);
                }
            });
        }

        public PreferenceHandler(URI key) {
            this.key = key;
        }

        public int getPriority() {
            return this.key != null && "project".equals(this.key.authority()) ? 600 : 400;
        }

        public boolean isIgnored() {
            return false;
        }

        public final boolean isNeeded(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
            return this.isNeeded();
        }

        protected boolean isNeeded() {
            if (this.isExcluded()) {
                return false;
            }
            String mergedValue = this.merge();
            return !ObjectUtil.equals((Object)mergedValue, (Object)this.oldValue);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean isExcluded() {
            if (this.oldValue == null) return false;
            if (!this.oldValue.startsWith("<?xml ")) return false;
            try {
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                documentBuilder.setErrorHandler(new ErrorHandler(){

                    public void warning(SAXParseException exception) throws SAXException {
                    }

                    public void fatalError(SAXParseException exception) throws SAXException {
                        throw exception;
                    }

                    public void error(SAXParseException exception) throws SAXException {
                    }
                });
                Document document = documentBuilder.parse(new InputSource(new StringReader(this.oldValue)));
                NodeList childNodes = document.getDocumentElement().getChildNodes();
                int i = 0;
                int length = childNodes.getLength();
                while (true) {
                    if (i >= length) {
                        return false;
                    }
                    Node item = childNodes.item(i);
                    String nodeValue = item.getNodeValue();
                    if (nodeValue == null) return true;
                    if (nodeValue.trim().length() != 0) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {}
            return false;
        }

        public String merge() {
            return this.newValue;
        }

        public String delta() {
            return this.newValue;
        }

        public void apply(SetupTaskContext context) {
        }

        public static void main(String[] args) {
            String result;
            PreferenceHandlerFactoryRegistry uriMappingRegistryImpl = (PreferenceHandlerFactoryRegistry)Factory.Registry.INSTANCE;
            uriMappingRegistryImpl.put(URI.createURI((String)"//"), null);
            uriMappingRegistryImpl.put(URI.createURI((String)"///"), null);
            uriMappingRegistryImpl.put(URI.createURI((String)"//instance/foo/bar/"), null);
            uriMappingRegistryImpl.put(URI.createURI((String)"//instance"), new Factory(){

                public PreferenceHandler create(URI key) {
                    return null;
                }
            });
            uriMappingRegistryImpl.getFactory(URI.createURI((String)"//instance/foo/bar/myproperty"));
            uriMappingRegistryImpl.getFactory(URI.createURI((String)"//instance/fudge/bar/myproperty"));
            ListPreferenceHandler handler = new ListPreferenceHandler(URI.createURI((String)""), "(?s)([^\\n]+\\n[0-9]+)", "([^\n]+)", "\n");
            if (handler.isNeeded("a\n2\n", "b\n2\na\n1\n")) {
                result = ((PreferenceHandler)handler).merge();
                System.out.println(result);
            } else {
                System.out.println("has conflict");
            }
            handler = new ListPreferenceHandler(URI.createURI((String)""), "(?s)([^\\n]+\\n[0-9]+)", "([^ \n]+) ([^\n]+)", "\n");
            if (handler.isNeeded("a b\n2\n", "a b\n3\nb a\n2\na a\n1\n")) {
                result = ((PreferenceHandler)handler).merge();
                System.out.println(result);
            } else {
                System.out.println("has conflict");
            }
        }

        public static PreferenceHandler getHandler(String key) {
            URI keyURI = PreferencesFactory.eINSTANCE.createURI(key);
            return PreferenceHandler.getHandler(keyURI);
        }

        public static PreferenceHandler getHandler(URI key) {
            Factory factory = Factory.Registry.INSTANCE.getFactory(key);
            if (factory == null) {
                return new PreferenceHandler(key);
            }
            return factory.create(key);
        }

        protected static void registerListHandlerFactory(String key, char itemSeparator, char keySeparator) {
            final String itemSeparatorStr = new String(new char[]{itemSeparator});
            final String itemPattern = "([^" + itemSeparatorStr + "]+)";
            final String keyPattern = keySeparator == '\u0000' ? "(.*)" : "([^" + new String(new char[]{keySeparator}) + "]+)";
            PreferenceHandlerFactoryRegistry registry = (PreferenceHandlerFactoryRegistry)Factory.Registry.INSTANCE;
            registry.put(URI.createURI((String)key), new Factory(){

                public PreferenceHandler create(URI key) {
                    return new ListPreferenceHandler(key, itemPattern, keyPattern, itemSeparatorStr);
                }
            });
        }

        protected static void registerListHandlerFactory(String key, char itemSeparator) {
            PreferenceHandler.registerListHandlerFactory(key, itemSeparator, '\u0000');
        }

        public static interface Factory {
            public PreferenceHandler create(URI var1);

            public static interface Registry {
                public static final Registry INSTANCE = new PreferenceHandlerFactoryRegistry();

                public Factory getFactory(URI var1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreferenceHandlerFactoryRegistry
    extends BasicEMap<URI, PreferenceHandler.Factory>
    implements PreferenceHandler.Factory.Registry {
        private static final URI ROOT_PREFIX = URI.createURI((String)"//");
        private static final long serialVersionUID = 1L;
        protected BasicEList<List<Map.Entry<URI, PreferenceHandler.Factory>>> prefixMaps;

        protected BasicEMap.Entry<URI, PreferenceHandler.Factory> newEntry(int hash, URI key, PreferenceHandler.Factory value) {
            this.validateKey(key);
            this.validateValue(value);
            return new MappingEntryImpl(hash, key, value);
        }

        @Override
        public PreferenceHandler.Factory getFactory(URI uri) {
            PreferenceHandler.Factory result = (PreferenceHandler.Factory)this.get(uri);
            if (result == null && this.prefixMaps != null && uri != null) {
                int i = Math.min(this.prefixMaps.size() - 1, uri.segmentCount());
                while (i >= 0) {
                    List prefixes = (List)this.prefixMaps.get(i);
                    int j = prefixes.size() - 1;
                    while (j >= 0) {
                        block7: {
                            Map.Entry entry = (Map.Entry)prefixes.get(j);
                            URI key = (URI)entry.getKey();
                            if (ROOT_PREFIX.equals(key)) {
                                return (PreferenceHandler.Factory)entry.getValue();
                            }
                            int k = key.segmentCount() - 2;
                            while (k >= 0) {
                                if (key.segment(k).equals(uri.segment(k))) {
                                    --k;
                                    continue;
                                }
                                break block7;
                            }
                            if (key.authority().equals(uri.authority())) {
                                return (PreferenceHandler.Factory)entry.getValue();
                            }
                        }
                        --j;
                    }
                    --i;
                }
            }
            return result;
        }

        protected void validateKey(URI key) {
            if (key == null) {
                throw new RuntimeException("Key may not be null");
            }
            if (!key.isHierarchical()) {
                throw new RuntimeException("Key is not hierarchical " + key);
            }
            if (key.authority() == null) {
                throw new RuntimeException("Key has no authority " + key);
            }
            if (key.scheme() != null) {
                throw new RuntimeException("Key should not have a scheme " + key);
            }
        }

        protected void validateValue(PreferenceHandler.Factory value) {
            if (value == null) {
                throw new RuntimeException("Value may not be null");
            }
        }

        protected void didAdd(BasicEMap.Entry<URI, PreferenceHandler.Factory> entry) {
            if (((MappingEntryImpl)entry).isPrefixMapEntry) {
                int length = ((URI)entry.getKey()).segmentCount();
                if (this.prefixMaps == null) {
                    this.prefixMaps = new BasicEList();
                }
                int i = this.prefixMaps.size() - 1;
                while (i <= length) {
                    this.prefixMaps.add((Object)new BasicEList());
                    ++i;
                }
                ((List)this.prefixMaps.get(length)).add(entry);
            }
        }

        protected void didModify(BasicEMap.Entry<URI, PreferenceHandler.Factory> entry, PreferenceHandler.Factory oldValue) {
            this.didRemove(entry);
            ((MappingEntryImpl)entry).determineEntryType();
            this.didAdd(entry);
        }

        protected void didRemove(BasicEMap.Entry<URI, PreferenceHandler.Factory> entry) {
            if (((MappingEntryImpl)entry).isPrefixMapEntry) {
                int length = ((URI)entry.getKey()).segmentCount();
                ((List)this.prefixMaps.get(length)).remove(entry);
            }
        }

        protected void didClear(BasicEList<BasicEMap.Entry<URI, PreferenceHandler.Factory>>[] oldEntryData) {
            this.prefixMaps = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class MappingEntryImpl
        extends BasicEMap.EntryImpl {
            public boolean isPrefixMapEntry;

            public MappingEntryImpl(int hash, URI key, PreferenceHandler.Factory value) {
                super((BasicEMap)PreferenceHandlerFactoryRegistry.this, hash, (Object)key, (Object)value);
                this.determineEntryType();
            }

            public void determineEntryType() {
                this.isPrefixMapEntry = "".equals(((URI)this.key).authority()) ? ((URI)this.key).segmentCount() == 0 : (((URI)this.key).segmentCount() == 0 ? ((URI)this.key).hasAbsolutePath() : ((URI)this.key).hasTrailingPathSeparator());
            }
        }
    }

    public static abstract class ProfileChoicePreferenceHandler
    extends PreferenceHandler {
        private static final Pattern SETTING_PATTERN = Pattern.compile("<setting id=\"([^\"]+)\" value=\"([^\"]+)\"");

        public ProfileChoicePreferenceHandler(URI key) {
            super(key);
        }

        public int getPriority() {
            return 401;
        }

        protected abstract PreferencesUtil.PreferenceProperty getProfilesPreferenceProperty();

        protected abstract PreferencesUtil.PreferenceProperty getKeyPreferenceProperty(String var1);

        public void apply(SetupTaskContext context) {
            Matcher matcher;
            PreferencesUtil.PreferenceProperty profiles = this.getProfilesPreferenceProperty();
            Pattern pattern = Pattern.compile("(?s)(<profile[^\n]*name=\"" + this.newValue.substring(1) + "\".*?</profile>)");
            String value = profiles.get(null);
            if (value != null && (matcher = pattern.matcher(value)).find()) {
                String profile = matcher.group(1);
                Matcher settingMatcher = SETTING_PATTERN.matcher(profile);
                while (settingMatcher.find()) {
                    String propertyKey = settingMatcher.group(1);
                    String propertyValue = settingMatcher.group(2);
                    PreferencesUtil.PreferenceProperty property = this.getKeyPreferenceProperty(propertyKey);
                    property.set(propertyValue);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeamFileModePreferenceHandler
    extends ListPreferenceHandler {
        protected static final Set<String> DEFAULT_NAME_MAPPINGS = new LinkedHashSet<String>();
        protected static final Set<String> DEFAULT_EXTENSION_MAPPINGS = new LinkedHashSet<String>();
        protected static final Object FILE_CONTENT_MANAGER;
        protected boolean isExtension;

        static {
            Object fileContentManager = null;
            try {
                Class teamClass = CommonPlugin.loadClass((String)"org.eclipse.team.core", (String)"org.eclipse.team.core.Team");
                fileContentManager = ReflectUtil.invokeMethod((String)"getFileContentManager", (Object)teamClass);
                Object[] defaultNameMappings = (Object[])ReflectUtil.invokeMethod((String)"getDefaultNameMappings", (Object)fileContentManager);
                TeamFileModePreferenceHandler.populateMappings(DEFAULT_NAME_MAPPINGS, defaultNameMappings);
                Object[] defaultExtensionMappings = (Object[])ReflectUtil.invokeMethod((String)"getDefaultExtensionMappings", (Object)fileContentManager);
                TeamFileModePreferenceHandler.populateMappings(DEFAULT_EXTENSION_MAPPINGS, defaultExtensionMappings);
            }
            catch (Throwable throwable) {}
            FILE_CONTENT_MANAGER = fileContentManager;
        }

        public TeamFileModePreferenceHandler(URI key) {
            super(key, "(?s)([^\\n]+\\n[0-9]+)", "([^\n]+)", "\n");
            this.isExtension = "file_types".equals(key.lastSegment());
        }

        @Override
        public String delta() {
            if (StringUtil.isEmpty((String)this.oldValue)) {
                StringBuilder result = new StringBuilder(super.delta());
                for (String mapping : this.isExtension ? DEFAULT_EXTENSION_MAPPINGS : DEFAULT_NAME_MAPPINGS) {
                    int index = result.indexOf(mapping);
                    if (index != 0 && (index <= 0 || result.charAt(index - 1) != '\n')) continue;
                    result.delete(index, index + mapping.length());
                }
                return result.toString();
            }
            return super.delta();
        }

        @Override
        public void apply(SetupTaskContext context) {
            if (FILE_CONTENT_MANAGER != null) {
                int size = this.changedItems.size();
                String[] names = new String[size];
                int[] types = new int[size];
                int index = 0;
                Iterator iterator = this.changedItems.iterator();
                while (iterator.hasNext()) {
                    String changedItem;
                    names[index] = changedItem = (String)iterator.next();
                    String value = ((ListPreferenceHandler.Item)this.mergedItems.get(changedItem)).getValue();
                    int offset = value.indexOf(10);
                    types[index] = Integer.parseInt(value.substring(offset + 1));
                    ++index;
                }
                ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod(FILE_CONTENT_MANAGER.getClass(), (String)(this.isExtension ? "addExtensionMappings" : "addNameMappings"), (Class[])new Class[]{String[].class, int[].class}), (Object)FILE_CONTENT_MANAGER, (Object[])new Object[]{names, types});
            }
        }

        private static void populateMappings(Set<String> target, Object[] mappings) {
            Object[] objectArray = mappings;
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                Object mapping = objectArray[n2];
                Object string = ReflectUtil.invokeMethod((String)"getString", (Object)mapping);
                int type = (Integer)ReflectUtil.invokeMethod((String)"getType", (Object)mapping);
                target.add(string + "\n" + type + "\n");
                ++n2;
            }
        }
    }

    public static class XMLPreferenceHandler
    extends ListPreferenceHandler {
        public XMLPreferenceHandler(URI key, String tag, String[] requiredAttributes, String[] optionalAttributes) {
            super(key, XMLPreferenceHandler.getItemPattern(tag), XMLPreferenceHandler.getKeyPattern(requiredAttributes, optionalAttributes), "\n");
        }

        private static String getItemPattern(String tag) {
            return "(?s)(<" + tag + " (?:[^>]*/>|.*?</" + tag + ">))";
        }

        private static String getKeyPattern(String[] requiredAttributes, String[] optionalAttributes) {
            TreeSet<String> attributes = new TreeSet<String>(Arrays.asList(requiredAttributes));
            List<Object> optional = optionalAttributes == null ? Collections.emptyList() : Arrays.asList(optionalAttributes);
            attributes.addAll(optional);
            StringBuilder result = new StringBuilder();
            for (String attribute : attributes) {
                int length = result.length();
                boolean isOptional = optional.contains(attribute);
                if (isOptional) {
                    result.append("(?:");
                }
                if (length != 0) {
                    result.append("[^>]+");
                }
                result.append(attribute);
                result.append("=\"([^\"]+)\"");
                if (!isOptional) continue;
                result.append(")?");
            }
            return result.toString();
        }
    }
}

