/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.phases.AuthorityChecker;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataWriter;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TableFactory;
import org.eclipse.jface.widgets.TreeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TrustAuthorityDialog
extends SelectionDialog {
    private static final String EXPORT_FILTER_PATH = "exportFilterPath";
    private CheckboxTreeViewer authorityViewer;
    private TreeViewer certificateChainViewer;
    private TableViewer iuViewer;
    private boolean trustAlways;
    private boolean rememberSelectedAuthorities = true;
    private boolean allSecured = true;
    private final List<TreeNode> rootAuthorities = new ArrayList<TreeNode>();
    private final List<TreeNode> sites = new ArrayList<TreeNode>();
    private final Map<TreeNode, List<IInstallableUnit>> iuMap = new LinkedHashMap<TreeNode, List<IInstallableUnit>>();
    private final Set<TreeNode> checkedAuthorities = new HashSet<TreeNode>();

    /*
     * WARNING - void declaration
     */
    public TrustAuthorityDialog(Shell parentShell, Object input) {
        super(parentShell);
        this.setShellStyle(0xC70 | TrustAuthorityDialog.getDefaultOrientation());
        Object object = input;
        if (object instanceof TreeNode[]) {
            void nodes;
            TreeNode[] treeNodeArray = (TreeNode[])object;
            TreeNode[] cfr_ignored_0 = (TreeNode[])object;
            this.init(null, (TreeNode[])nodes);
        }
        this.setTitle(ProvUIMessages.TrustAuthorityDialog_TrustAuthoritiesTitle);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(ProvUIMessages.TrustAuthorityDialog_TrustAuthorityMainMessage);
        if (!this.allSecured) {
            messages.add(ProvUIMessages.TrustAuthorityDialog_TrustInsecureAuthorityMessage);
        }
        messages.add(ProvUIMessages.TrustAuthorityDialog_TrustAuthorityDescriptionMessage);
        this.setMessage(String.join((CharSequence)"  ", messages));
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, "org.eclipse.equinox.p2.ui.trust_authorities_dialog_context");
        }
    }

    private void init(TreeNode parent, TreeNode[] treeNodes) {
        TreeNode[] treeNodeArray = treeNodes;
        int n = treeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode[] children;
            Certificate[] certficates;
            TreeNode node = treeNodeArray[n2];
            IInstallableUnit[] ius = TrustAuthorityDialog.getInstance(node, IInstallableUnit[].class);
            if (ius != null) {
                this.iuMap.put(node, Arrays.asList(ius));
            }
            if (parent == null) {
                this.rootAuthorities.add(node);
            }
            if ((certficates = TrustAuthorityDialog.getInstance(node, Certificate[].class)) == null || certficates.length == 0) {
                this.allSecured = false;
            }
            if ((children = node.getChildren()).length > 0) {
                this.init(node, children);
            } else {
                this.sites.add(node);
            }
            ++n2;
        }
    }

    public boolean isRememberSelectedAuthorities() {
        return this.rememberSelectedAuthorities;
    }

    public boolean isTrustAlways() {
        return this.trustAlways;
    }

    protected Label createMessageArea(Composite composite) {
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        LabelFactory factory = (LabelFactory)((LabelFactory)WidgetFactory.label((int)64).font(composite.getFont())).layoutData((Object)data);
        if (this.getMessage() != null) {
            factory.text(this.getMessage());
        }
        return (Label)factory.create((Widget)composite);
    }

    protected Control createDialogArea(Composite parent) {
        TreeSet ius;
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        Dialog.applyDialogFont((Control)mainComposite);
        this.initializeDialogUnits((Control)mainComposite);
        this.createMessageArea(mainComposite);
        SashForm sashForm = new SashForm(mainComposite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAuthorityViewerArea(this.createSashFormArea(sashForm));
        boolean containsCertificates = TrustAuthorityDialog.containsInstance(this.iuMap.keySet(), PGPPublicKey.class) || TrustAuthorityDialog.containsInstance(this.iuMap.keySet(), Certificate.class);
        containsCertificates = true;
        if (containsCertificates) {
            this.createCertficateChainViewerArea(this.createSashFormArea(sashForm));
        }
        if (!(ius = this.iuMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> new TreeSet()))).isEmpty()) {
            this.crreateIUViewerArea(this.createSashFormArea(sashForm), ius);
        }
        Control[] children = sashForm.getChildren();
        int[] weights = new int[children.length];
        int i = 0;
        while (i < children.length) {
            weights[i] = children[i].computeSize((int)-1, (int)-1, (boolean)false).y;
            ++i;
        }
        sashForm.setWeights(weights);
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        if (!this.iuMap.isEmpty()) {
            this.authorityViewer.setSelection((ISelection)new StructuredSelection((Object)this.iuMap.keySet().iterator().next()));
        }
        return mainComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, ProvUIMessages.TrustAuthorityDialog_TrustSelectedCheckbox, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateOkButton();
    }

    private Composite createSashFormArea(SashForm sashForm) {
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void setAllChecked(boolean checked) {
        this.checkedAuthorities.clear();
        if (checked) {
            for (TreeNode authority : this.rootAuthorities) {
                TreeNode[] treeNodeArray = authority.getChildren();
                int n = treeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeNode child = treeNodeArray[n2];
                    this.checkedAuthorities.add(child);
                    this.checkedAuthorities.addAll(TrustAuthorityDialog.getAllChildren(child));
                    ++n2;
                }
            }
        }
        this.authorityViewer.refresh(true);
    }

    private void createAuthorityViewerArea(Composite composite) {
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout(true);
        Composite treeComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)new GridData(4, 4, true, true))).layout((Layout)treeColumnLayout)).create((Widget)composite);
        Tree tree = (Tree)((TreeFactory)WidgetFactory.tree((int)68386).headerVisible(true).linesVisible(true).font(composite.getFont())).create((Widget)treeComposite);
        this.authorityViewer = new CheckboxTreeViewer(tree);
        this.authorityViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        tree.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.stateMask == 262144 && e.keyCode == 97) {
                this.authorityViewer.setSelection((ISelection)new StructuredSelection(this.iuMap.keySet().toArray()));
                e.doit = false;
            }
        }));
        this.authorityViewer.addCheckStateListener(e -> {
            TreeNode node = (TreeNode)e.getElement();
            if (node.getChildren().length == 0) {
                node = node.getParent();
            }
            if (e.getChecked()) {
                this.checkedAuthorities.add(node);
                this.checkedAuthorities.addAll(TrustAuthorityDialog.getAllChildren(node));
            } else {
                this.checkedAuthorities.remove(node);
                this.checkedAuthorities.removeAll(TrustAuthorityDialog.getAllChildren(node));
            }
            this.authorityViewer.refresh(true);
            this.updateOkButton();
        });
        this.authorityViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                TreeNode node = (TreeNode)element;
                return node.getParent() == null && !TrustAuthorityDialog.this.checkedAuthorities.contains(node) && TrustAuthorityDialog.this.checkedAuthorities.containsAll(Arrays.asList(node.getChildren()));
            }

            public boolean isChecked(Object element) {
                return TrustAuthorityDialog.this.checkedAuthorities.contains(element) || this.isGrayed(element);
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(Math.min(this.iuMap.keySet().size() + 2, 6)) * 3 / 2;
        data.widthHint = this.convertWidthInCharsToPixels(120);
        treeComposite.setLayoutData((Object)data);
        this.createColumn((TreeViewer)this.authorityViewer, ProvUIMessages.TrustAuthorityDialog_AuthorityColumnTitle, new ColumnLabelProvider(){

            public String getText(Object element) {
                String prefix;
                TreeNode treeNode = (TreeNode)element;
                String text = treeNode.getValue().toString();
                TreeNode parent = treeNode.getParent();
                if (parent != null && text.startsWith(prefix = parent.getValue().toString())) {
                    return text.substring(prefix.length());
                }
                return text;
            }
        }, treeColumnLayout, 1);
        TreeViewerColumn unitsColumn = this.createColumn((TreeViewer)this.authorityViewer, ProvUIMessages.TrustAuthorityDialog_UnitsColumnTitle, new ColumnLabelProvider(){

            public String getText(Object element) {
                IInstallableUnit[] ius = TrustAuthorityDialog.getInstance(element, IInstallableUnit[].class);
                return ius == null ? ProvUIMessages.TrustAuthorityDialog_ComputingAuthorityCertficate : Integer.toString(ius.length);
            }
        }, treeColumnLayout, 2);
        unitsColumn.getColumn().setAlignment(131072);
        TreeViewerColumn securedColumn = this.createColumn((TreeViewer)this.authorityViewer, ProvUIMessages.TrustAuthorityDialog_SecuredColumnTitle, new ColumnLabelProvider(){

            public String getText(Object element) {
                Certificate[] certificates = TrustAuthorityDialog.getInstance(element, Certificate[].class);
                return certificates != null && certificates.length > 1 ? ProvUIMessages.TrustAuthorityDialog_AuthoritySecure : ProvUIMessages.TrustAuthorityDialog_AuthorityInsecure;
            }
        }, treeColumnLayout, 2);
        this.addSelectionButtons(composite);
        this.authorityViewer.addDoubleClickListener(e -> {
            StructuredSelection selection = (StructuredSelection)e.getSelection();
            X509Certificate certificate = TrustAuthorityDialog.getInstance(selection, X509Certificate.class);
            if (certificate != null) {
                CertificateLabelProvider.openDialog(this.getShell(), certificate);
            }
        });
        this.authorityViewer.addSelectionChangedListener(e -> {
            if (this.certificateChainViewer != null) {
                Certificate[] certificates;
                ArrayList<TreeNode> input = new ArrayList<TreeNode>();
                TreeNode treeNode = TrustAuthorityDialog.getInstance(e.getSelection(), TreeNode.class);
                if (treeNode != null && (certificates = TrustAuthorityDialog.getInstance(treeNode, Certificate[].class)) != null && certificates.length > 0) {
                    TreeNode root = null;
                    int i = certificates.length;
                    while (--i >= 0) {
                        TreeNode child = root;
                        root = new TreeNode((Object)certificates[i]);
                        if (child == null) continue;
                        root.setChildren(new TreeNode[]{child});
                    }
                    input.add(root);
                }
                this.certificateChainViewer.setInput(input.toArray(TreeNode[]::new));
                if (!input.isEmpty()) {
                    this.certificateChainViewer.setSelection((ISelection)new StructuredSelection(input.get(0)));
                }
            }
        });
        this.authorityViewer.setInput(this.rootAuthorities.toArray(TreeNode[]::new));
        tree.setVisible(false);
        this.authorityViewer.expandAll();
        unitsColumn.getColumn().pack();
        securedColumn.getColumn().pack();
        this.authorityViewer.collapseAll();
        tree.setVisible(true);
        this.createMenu((StructuredViewer)this.authorityViewer);
    }

    private void createCertficateChainViewerArea(Composite composite) {
        this.certificateChainViewer = new TreeViewer(composite, 2816);
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(2);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        this.certificateChainViewer.getTree().setLayoutData((Object)data);
        this.certificateChainViewer.setAutoExpandLevel(2);
        this.certificateChainViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.certificateChainViewer.setLabelProvider((IBaseLabelProvider)new CertificateLabelProvider());
        this.certificateChainViewer.addDoubleClickListener(e -> {
            StructuredSelection selection = (StructuredSelection)e.getSelection();
            X509Certificate certificate = TrustAuthorityDialog.getInstance(selection, X509Certificate.class);
            if (certificate != null) {
                CertificateLabelProvider.openDialog(this.getShell(), certificate);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new RowLayout());
        Button detailsButton = new Button(buttonComposite, 0);
        detailsButton.setEnabled(false);
        detailsButton.setText(ProvUIMessages.TrustAuthorityDialog_CertificateDetailsButton);
        detailsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                X509Certificate certificate = TrustAuthorityDialog.getInstance(TrustAuthorityDialog.this.certificateChainViewer.getSelection(), X509Certificate.class);
                if (certificate != null) {
                    CertificateLabelProvider.openDialog(TrustAuthorityDialog.this.getShell(), certificate);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        final Button exportButton = new Button(buttonComposite, 0);
        exportButton.setEnabled(false);
        exportButton.setText(ProvUIMessages.TrustAuthorityDialog_CertificateExportButton);
        exportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ISelection selection = TrustAuthorityDialog.this.certificateChainViewer.getSelection();
                X509Certificate certificate = TrustAuthorityDialog.getInstance(selection, X509Certificate.class);
                PGPPublicKey key = TrustAuthorityDialog.getInstance(selection, PGPPublicKey.class);
                if (certificate != null || key != null) {
                    FileDialog destination = new FileDialog(exportButton.getShell(), 8192);
                    destination.setFilterPath(TrustAuthorityDialog.this.getFilterPath(TrustAuthorityDialog.EXPORT_FILTER_PATH));
                    destination.setText(ProvUIMessages.TrustAuthorityDialog_ExportDialogTitle);
                    if (certificate != null) {
                        destination.setFilterExtensions(new String[]{"*.der"});
                        destination.setFileName(certificate.getSerialNumber().toString() + ".der");
                        String path = destination.open();
                        TrustAuthorityDialog.this.setFilterPath(TrustAuthorityDialog.EXPORT_FILTER_PATH, destination.getFilterPath());
                        if (path == null) {
                            return;
                        }
                        File destinationFile = new File(path);
                        try {
                            Throwable throwable = null;
                            Object var9_11 = null;
                            try (FileOutputStream output = new FileOutputStream(destinationFile);){
                                output.write(certificate.getEncoded());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException | CertificateEncodingException ex) {
                            ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ex.getMessage(), (Throwable)ex));
                        }
                    }
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.certificateChainViewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            boolean containsCertificate = TrustAuthorityDialog.containsInstance(selection, X509Certificate.class);
            detailsButton.setEnabled(containsCertificate);
            exportButton.setEnabled(containsCertificate || TrustAuthorityDialog.containsInstance(selection, PGPPublicKey.class));
        });
    }

    private void crreateIUViewerArea(Composite composite, Set<IInstallableUnit> ius) {
        FontData[] fontDatas;
        TableColumnLayout tableColumnLayout = new TableColumnLayout(true);
        Composite tableComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)new GridData(4, 4, true, true))).layout((Layout)tableColumnLayout)).create((Widget)composite);
        Table table = (Table)((TableFactory)WidgetFactory.table((int)68354).headerVisible(true).linesVisible(true).font(composite.getFont())).create((Widget)tableComposite);
        this.iuViewer = new TableViewer(table);
        this.iuViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        table.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.stateMask == 262144 && e.keyCode == 97) {
                this.iuViewer.setSelection((ISelection)new StructuredSelection(ius.toArray()));
                e.doit = false;
            }
        }));
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(Math.min(ius.size() + 1, 10)) * 3 / 2;
        data.widthHint = this.convertWidthInCharsToPixels(120);
        tableComposite.setLayoutData((Object)data);
        Font font = table.getFont();
        FontData[] fontDataArray = fontDatas = font.getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(fontData.getStyle() | 1);
            ++n2;
        }
        Font boldFont = new Font((Device)table.getDisplay(), fontDatas);
        composite.addDisposeListener(e -> boldFont.dispose());
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new RowLayout());
        Button detailsButton = new Button(buttonComposite, 0);
        detailsButton.setEnabled(false);
        detailsButton.setText(ProvUIMessages.TrustAuthorityDialog_IUDetailsButton);
        final Runnable openIUDialog = () -> {
            List list = this.iuViewer.getStructuredSelection().toList();
            IUDialog iuDialog = new IUDialog(this.getShell(), list);
            iuDialog.open();
        };
        detailsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                openIUDialog.run();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        Function<IInstallableUnit, Font> fontProvider = e -> {
            Object[] objectArray = this.authorityViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                List<IInstallableUnit> list = this.iuMap.get(object);
                if (list != null && list.contains(e)) {
                    return boldFont;
                }
                ++n2;
            }
            return null;
        };
        this.authorityViewer.addCheckStateListener(e -> this.iuViewer.refresh(true));
        this.iuViewer.addPostSelectionChangedListener(e -> {
            List selection = e.getStructuredSelection().toList();
            detailsButton.setEnabled(!selection.isEmpty());
            if (table.isFocusControl()) {
                ArrayList<TreeNode> newSelection = new ArrayList<TreeNode>();
                block0: for (Map.Entry<TreeNode, List<IInstallableUnit>> entry : this.iuMap.entrySet()) {
                    List<IInstallableUnit> value = entry.getValue();
                    if (value == null) continue;
                    for (IInstallableUnit key : value) {
                        if (!selection.contains(key)) continue;
                        newSelection.add(entry.getKey());
                        continue block0;
                    }
                }
                this.authorityViewer.setSelection((ISelection)new StructuredSelection(newSelection), true);
            }
        });
        this.iuViewer.addDoubleClickListener(e -> openIUDialog.run());
        this.authorityViewer.addPostSelectionChangedListener(e -> {
            if (!table.isFocusControl()) {
                LinkedHashSet<IInstallableUnit> associatedIUs = new LinkedHashSet<IInstallableUnit>();
                for (Object object : e.getStructuredSelection()) {
                    List<IInstallableUnit> list = this.iuMap.get(object);
                    if (list == null) continue;
                    associatedIUs.addAll(list);
                }
                this.iuViewer.setSelection((ISelection)new StructuredSelection(associatedIUs.toArray()), true);
                LinkedHashSet newInput = new LinkedHashSet(ius);
                newInput.retainAll(associatedIUs);
                newInput.addAll(ius);
                this.iuViewer.setInput(newInput);
                this.iuViewer.setSelection((ISelection)new StructuredSelection(associatedIUs.toArray()), true);
            }
        });
        TableViewerColumn idColumn = this.createColumn(this.iuViewer, ProvUIMessages.TrustAuthorityDialog_IUColumnTitle, (ColumnLabelProvider)new IULabelProvider(a -> a.getId(), fontProvider), tableColumnLayout, 1);
        this.createColumn(this.iuViewer, ProvUIMessages.TrustAuthorityDialog_IUVersionColumnTitle, (ColumnLabelProvider)new IULabelProvider(a -> a.getVersion().toString(), fontProvider), tableColumnLayout, 10);
        this.iuViewer.setInput(ius);
        idColumn.getColumn().pack();
    }

    private void createMenu(StructuredViewer viewer) {
        Control control = viewer.getControl();
        Menu menu = new Menu(control);
        control.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(ProvUIMessages.TrustAuthorityDialog_AuthorityCopyLinkMenu);
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            URI uri = TrustAuthorityDialog.getInstance(viewer.getSelection(), URI.class);
            if (uri != null) {
                Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
                clipboard.setContents(new Object[]{uri.toString()}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        }));
        viewer.addSelectionChangedListener(e -> item.setEnabled(TrustAuthorityDialog.containsInstance(e.getSelection(), URI.class)));
    }

    private TreeViewerColumn createColumn(TreeViewer treeViewer, String text, ColumnLabelProvider labelProvider, TreeColumnLayout treeColumnLayout, int columnWeight) {
        TreeViewerColumn column = new TreeViewerColumn(treeViewer, 0);
        column.getColumn().setText(text);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        treeColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWeight));
        return column;
    }

    private TableViewerColumn createColumn(TableViewer tableViewer, String text, ColumnLabelProvider labelProvider, TableColumnLayout tableColumnLayout, int columnWeight) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setText(text);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWeight));
        return column;
    }

    private void checkInitialSelections() {
        for (Object element : this.getInitialElementSelections()) {
            this.authorityViewer.setChecked(element, true);
            if (this.iuViewer == null) continue;
            this.iuViewer.refresh(true);
        }
    }

    private void addSelectionButtons(Composite composite) {
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite buttonArea = new Composite(composite, 0);
        GridLayout buttonAreaLayout = new GridLayout();
        buttonAreaLayout.numColumns = 2;
        buttonAreaLayout.marginWidth = 0;
        buttonAreaLayout.horizontalSpacing = horizontalSpacing;
        buttonArea.setLayout((Layout)buttonAreaLayout);
        buttonArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite leftButtonArea = new Composite(buttonArea, 0);
        GridLayout leftButtonAreaLayout = new GridLayout();
        leftButtonAreaLayout.numColumns = 0;
        leftButtonAreaLayout.marginWidth = 0;
        leftButtonAreaLayout.horizontalSpacing = horizontalSpacing;
        leftButtonArea.setLayout((Layout)leftButtonAreaLayout);
        leftButtonArea.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        Button rememberSelectionButton = this.createCheckButton(leftButtonArea, ProvUIMessages.TrustAuthorityDialog_RememberSelectedAuthoritiesCheckbox);
        rememberSelectionButton.setSelection(this.rememberSelectedAuthorities);
        rememberSelectionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.rememberSelectedAuthorities = rememberSelectionButton.getSelection();
        }));
        Button trustAlwaysButton = this.createCheckButton(leftButtonArea, ProvUIMessages.TrustAuthorityDialog_TrustAllAuthoritiesCheckbox);
        trustAlwaysButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (trustAlwaysButton.getSelection()) {
                MessageDialog messageDialog = new MessageDialog(this.getShell(), ProvUIMessages.TrustAuthorityDialog_TrustAllAuthoritiesConfirmationTitle, null, ProvUIMessages.TrustAuthorityDialog_TrustAllAuthoritiesConfirmationDescription, 3, new String[]{ProvUIMessages.TrustAuthorityDialog_AcceptTrustAllAuthorities, ProvUIMessages.TrustAuthorityDialog_RejectTrustAllAuthorities}, 1){

                    public Image getImage() {
                        return this.getWarningImage();
                    }
                };
                int result = messageDialog.open();
                if (result != 0) {
                    trustAlwaysButton.setSelection(false);
                } else {
                    this.setAllChecked(true);
                    if (this.iuViewer != null) {
                        this.iuViewer.refresh(true);
                    }
                    this.updateOkButton();
                }
            }
            this.trustAlways = trustAlwaysButton.getSelection();
        }));
        Composite rightButtonArea = new Composite(buttonArea, 0);
        GridLayout rightButtonAreaLayout = new GridLayout();
        rightButtonAreaLayout.numColumns = 0;
        rightButtonAreaLayout.marginWidth = 0;
        rightButtonAreaLayout.horizontalSpacing = horizontalSpacing;
        rightButtonArea.setLayout((Layout)rightButtonAreaLayout);
        rightButtonArea.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(rightButtonArea, 18, ProvUIMessages.TrustAuthorityDialog_AuthoritiesSelectAllButton, false);
        selectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setAllChecked(true);
            if (this.iuViewer != null) {
                this.iuViewer.refresh(true);
            }
            this.updateOkButton();
        }));
        Button deselectButton = this.createButton(rightButtonArea, 19, ProvUIMessages.TrustAuthorityDialog_AuthoritiesDeselectAllButton, false);
        deselectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setAllChecked(false);
            if (this.iuViewer != null) {
                this.iuViewer.refresh(true);
            }
            this.updateOkButton();
        }));
        Button expandAllButton = this.createButton(rightButtonArea, 1024, ProvUIMessages.TrustAuthorityDialog_AuthoritiesExpandAllButton, false);
        expandAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.authorityViewer.expandAll()));
        Button collapseAllButton = this.createButton(rightButtonArea, 1025, ProvUIMessages.TrustAuthorityDialog_AuthoritiesCollapseAllButton, false);
        collapseAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.authorityViewer.collapseAll()));
    }

    protected Button createCheckButton(Composite parent, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = (Button)((ButtonFactory)WidgetFactory.button((int)32).text(label).font(JFaceResources.getDialogFont())).create((Widget)parent);
        this.setButtonLayoutData(button);
        return button;
    }

    private String getFilterPath(String key) {
        IDialogSettings dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)ProvUIActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
        String filterPath = dialogSettings.get(key);
        if (filterPath == null) {
            filterPath = System.getProperty("user.home");
        }
        return filterPath;
    }

    private void setFilterPath(String key, String filterPath) {
        if (filterPath != null) {
            IDialogSettings dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)ProvUIActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
            dialogSettings.put(key, filterPath);
        }
    }

    private void updateOkButton() {
        Button okButton = this.getOkButton();
        if (okButton != null) {
            HashSet siteURIs = this.sites.stream().map(node -> (URI)node.getValue()).collect(Collectors.toCollection(() -> new HashSet()));
            Set checkedAuthorityURIs = this.checkedAuthorities.stream().map(node -> (URI)node.getValue()).collect(Collectors.toSet());
            siteURIs.removeIf(uri -> {
                for (URI authority : AuthorityChecker.getAuthorityChain((URI)uri)) {
                    if (!checkedAuthorityURIs.contains(authority)) continue;
                    return true;
                }
                return false;
            });
            okButton.setEnabled(siteURIs.isEmpty());
        }
    }

    protected void okPressed() {
        this.setResult(new ArrayList<TreeNode>(this.checkedAuthorities));
        super.okPressed();
    }

    public URI[] getResult() {
        return (URI[])Arrays.stream(super.getResult()).filter(node -> this.rootAuthorities.contains(node) || this.rootAuthorities.contains(((TreeNode)node).getParent())).map(it -> (URI)((TreeNode)it).getValue()).toArray(URI[]::new);
    }

    private static List<TreeNode> getAllChildren(TreeNode treeNode) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        TrustAuthorityDialog.getAllChildren(result, treeNode);
        return result;
    }

    private static void getAllChildren(List<TreeNode> result, TreeNode treeNode) {
        TreeNode[] treeNodeArray = treeNode.getChildren();
        int n = treeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode child = treeNodeArray[n2];
            result.add(child);
            TrustAuthorityDialog.getAllChildren(result, child);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T getInstance(Object element, Class<T> type, Predicate<T> filter) {
        block9: {
            void treeNodes;
            block10: {
                void elements;
                block8: {
                    if (!type.isInstance(element)) break block8;
                    if (filter == null || filter.test(type.cast(element))) {
                        return type.cast(element);
                    }
                    break block9;
                }
                Object object = element;
                if (!(object instanceof Iterable)) break block10;
                Iterable iterable = (Iterable)object;
                Iterable cfr_ignored_0 = (Iterable)object;
                for (Object object2 : elements) {
                    T instance = TrustAuthorityDialog.getInstance(object2, type, filter);
                    if (instance == null) continue;
                    return instance;
                }
                break block9;
            }
            Object object = element;
            if (object instanceof TreeNode) {
                void treeNode;
                TreeNode object2 = (TreeNode)object;
                TreeNode cfr_ignored_1 = (TreeNode)object;
                Object object3 = element;
                if (object3 instanceof IAdaptable) {
                    void adaptable;
                    IAdaptable iAdaptable = (IAdaptable)object3;
                    IAdaptable cfr_ignored_2 = (IAdaptable)object3;
                    Object instance = adaptable.getAdapter(type);
                    if (instance != null) {
                        return (T)instance;
                    }
                    Object[] array = (Object[])adaptable.getAdapter((Class)type.arrayType());
                    if (array != null && array.length > 0) {
                        return type.cast(array[0]);
                    }
                }
                return TrustAuthorityDialog.getInstance(treeNode.getValue(), type, filter);
            }
            Object object4 = element;
            if (!(object4 instanceof TreeNode[])) break block9;
            TreeNode[] adaptable = (TreeNode[])object4;
            TreeNode[] cfr_ignored_3 = (TreeNode[])object4;
            void var15_18 = treeNodes;
            int n = ((void)var15_18).length;
            int n2 = 0;
            while (n2 < n) {
                void child = var15_18[n2];
                T instance = TrustAuthorityDialog.getInstance(child, type, filter);
                if (instance != null) {
                    return instance;
                }
                ++n2;
            }
        }
        return null;
    }

    private static <T> T getInstance(Object element, Class<T> type) {
        return TrustAuthorityDialog.getInstance(element, type, null);
    }

    private static boolean containsInstance(Object element, Class<?> type) {
        return TrustAuthorityDialog.getInstance(element, type) != null;
    }

    private static final class IUDialog
    extends TitleAreaDialog {
        private static final Pattern INSTRUCTION_PATTERN = Pattern.compile("<instruction .*?</instruction>", 40);
        private final String xml;
        private final Collection<IInstallableUnit> ius;

        public IUDialog(Shell parentShell, Collection<IInstallableUnit> ius) {
            super(parentShell);
            this.ius = ius;
            this.setShellStyle(68656);
            this.xml = IUDialog.getIUDetails(ius);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(ProvUIMessages.TrustAuthorityDialog_IUDetailsDialogTitle);
        }

        protected Control createDialogArea(Composite parent) {
            GridLayout layout = (GridLayout)parent.getLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            StyledText text = new StyledText(parent, 832);
            text.setBackground(text.getDisplay().getSystemColor(22));
            text.setLayoutData((Object)new GridData(1808));
            text.setText(this.xml);
            text.setEditable(false);
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            Matcher matcher = INSTRUCTION_PATTERN.matcher(this.xml);
            while (matcher.find()) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = matcher.start();
                styleRange.length = matcher.end() - styleRange.start;
                styleRange.fontStyle = 1;
                styleRanges.add(styleRange);
            }
            text.setStyleRanges((StyleRange[])styleRanges.toArray(StyleRange[]::new));
            int size = this.ius.size();
            if (size == 1) {
                IInstallableUnit iu = this.ius.iterator().next();
                this.setTitle(iu.getId() + " - " + String.valueOf(iu.getVersion()));
            } else {
                this.setTitle(NLS.bind((String)ProvUIMessages.TrustAuthorityDialog_IUDetailsDialogCountMessage, (Object)size));
            }
            this.setMessage(ProvUIMessages.TrustAuthorityDialog_IUDetailDialogDescriptionMessage);
            return text;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        }

        private static String getIUDetails(Collection<IInstallableUnit> ius) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new MetadataWriter(out, null){

                protected void writeInstallableUnit(IInstallableUnit resolvedIU) {
                    IInstallableUnit iu = resolvedIU.unresolved();
                    this.start("unit");
                    this.attribute("id", iu.getId());
                    this.attribute("version", iu.getVersion());
                    this.attribute("singleton", iu.isSingleton(), true);
                    this.writeMetaRequirements(iu.getMetaRequirements());
                    this.writeArtifactKeys(iu.getArtifacts());
                    if (iu.getTouchpointType() != null) {
                        this.writeTouchpointType(iu.getTouchpointType());
                    }
                    this.writeTouchpointData(iu.getTouchpointData());
                    this.end("unit");
                    this.flush();
                }
            }.writeInstallableUnits(ius.iterator(), ius.size());
            return new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
    }

    private static class IULabelProvider
    extends ColumnLabelProvider {
        private Function<IInstallableUnit, String> labelProvider;
        private Function<IInstallableUnit, Font> fontProvider;

        public IULabelProvider(Function<IInstallableUnit, String> labelProvider, Function<IInstallableUnit, Font> fontProvider) {
            this.labelProvider = labelProvider;
            this.fontProvider = fontProvider;
        }

        public String getText(Object element) {
            return this.labelProvider.apply((IInstallableUnit)element);
        }

        public Font getFont(Object element) {
            return this.fontProvider.apply((IInstallableUnit)element);
        }
    }
}

