/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class JREAction
extends AbstractPublisherAction {
    private static final String DEFAULT_JRE_NAME = "a.jre";
    private static final Version DEFAULT_JRE_VERSION = Version.parseVersion((String)"11.0");
    private static final String DEFAULT_PROFILE = "JavaSE-11";
    private static final String PROFILE_LOCATION = "jre.action.profile.location";
    private static final String PROFILE_NAME = "osgi.java.profile.name";
    private static final String PROFILE_TARGET_VERSION = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    private static final String PROFILE_SYSTEM_PACKAGES = "org.osgi.framework.system.packages";
    public static final String NAMESPACE_OSGI_EE = "osgi.ee";
    public static final String VERSION_OSGI_EE = "version";
    private File jreLocation;
    private String environment;
    private Map<String, String> profileProperties;
    private MultiStatus resultStatus;

    public JREAction(File location) {
        this.jreLocation = location;
    }

    public JREAction(String environment) {
        this.environment = environment;
    }

    @Override
    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        String problemMessage = NLS.bind((String)Messages.message_problemsWhilePublishingEE, (Object)(this.jreLocation != null ? this.jreLocation : this.environment));
        this.resultStatus = new MultiStatus(Activator.ID, 0, problemMessage, null);
        this.initialize(publisherInfo);
        IArtifactDescriptor artifact = this.createJREData(results);
        if (artifact != null) {
            this.publishArtifact(artifact, new File[]{this.jreLocation}, null, publisherInfo, this.createRootPrefixComputer(this.jreLocation));
        }
        if (this.resultStatus.isOK()) {
            return Status.OK_STATUS;
        }
        return this.resultStatus;
    }

    private static Status newErrorStatus(String message, Exception exception) {
        return new Status(4, Activator.ID, message, (Throwable)exception);
    }

    private static Status newWarningStatus(String message) {
        return new Status(2, Activator.ID, message, null);
    }

    protected IArtifactDescriptor createJREData(IPublisherResult results) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(false);
        iu.setId(DEFAULT_JRE_NAME);
        iu.setVersion(DEFAULT_JRE_VERSION);
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        this.generateJREIUData(iu);
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configId = "config." + iu.getId();
        cu.setId(configId);
        cu.setVersion(iu.getVersion());
        VersionRange range = iu.getVersion() == Version.emptyVersion ? VersionRange.emptyRange : new VersionRange(iu.getVersion(), true, Version.MAX_VERSION, true);
        cu.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, null, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability(configId, iu.getVersion())});
        cu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        if (this.jreLocation == null || !this.jreLocation.isDirectory()) {
            touchpointData.put("install", "");
            cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
            results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu), "root");
            results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu), "root");
            return null;
        }
        ArtifactKey key = new ArtifactKey("binary", iu.getId(), iu.getVersion());
        iu.setArtifacts(new IArtifactKey[]{key});
        results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu), "root");
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu), "root");
        return PublisherHelper.createArtifactDescriptor(this.info, (IArtifactKey)key, this.jreLocation);
    }

    private List<IProvidedCapability> generateJRECapability(String id, Version version) {
        if (this.profileProperties == null) {
            return Collections.emptyList();
        }
        ArrayList<IProvidedCapability> result = new ArrayList<IProvidedCapability>();
        result.add(PublisherHelper.createSelfCapability(id, version));
        this.generateProvidedPackages(result);
        this.generateOsgiEESystemCapabilities(result);
        return result;
    }

    private void generateProvidedPackages(List<IProvidedCapability> result) {
        String packages = this.profileProperties.get(PROFILE_SYSTEM_PACKAGES);
        if (packages != null && packages.trim().length() > 0) {
            try {
                ManifestElement[] jrePackages;
                ManifestElement[] manifestElementArray = jrePackages = ManifestElement.parseHeader((String)PROFILE_SYSTEM_PACKAGES, (String)packages);
                int n = jrePackages.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestElement jrePackage = manifestElementArray[n2];
                    String packageName = jrePackage.getValue();
                    Version packageVersion = Version.create((String)jrePackage.getAttribute(VERSION_OSGI_EE));
                    result.add(MetadataFactory.createProvidedCapability((String)"java.package", (String)packageName, (Version)packageVersion));
                    ++n2;
                }
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    void generateOsgiEESystemCapabilities(List<IProvidedCapability> result) {
        String message = NLS.bind((String)Messages.message_problemsWhileParsingProfileProperty, (Object)"org.osgi.framework.system.capabilities");
        MultiStatus parsingStatus = new MultiStatus(Activator.ID, 0, message, null);
        String systemCapabilities = this.profileProperties.get("org.osgi.framework.system.capabilities");
        JREAction.parseSystemCapabilities(systemCapabilities, parsingStatus, result);
        if (!parsingStatus.isOK()) {
            this.resultStatus.add((IStatus)parsingStatus);
        }
    }

    static void parseSystemCapabilities(String systemCapabilities, MultiStatus parsingStatus, List<IProvidedCapability> parsingResult) {
        if (systemCapabilities == null || systemCapabilities.trim().length() == 0) {
            return;
        }
        try {
            ManifestElement[] eeEntries = ManifestElement.parseHeader((String)"org.osgi.framework.system.capabilities", (String)systemCapabilities);
            JREAction.parseSystemCapabilities(eeEntries, parsingStatus, parsingResult);
        }
        catch (BundleException e) {
            parsingStatus.add((IStatus)JREAction.newErrorStatus(e.getLocalizedMessage(), (Exception)((Object)e)));
        }
    }

    private static void parseSystemCapabilities(ManifestElement[] systemCapabilities, MultiStatus parsingStatus, List<IProvidedCapability> parsingResult) {
        ManifestElement[] manifestElementArray = systemCapabilities;
        int n = systemCapabilities.length;
        int n2 = 0;
        while (n2 < n) {
            String[] namespaces;
            ManifestElement systemCapability = manifestElementArray[n2];
            String[] stringArray = namespaces = systemCapability.getValueComponents();
            int n3 = namespaces.length;
            int n4 = 0;
            while (n4 < n3) {
                String namespace = stringArray[n4];
                if (NAMESPACE_OSGI_EE.equals(namespace)) {
                    JREAction.parseEECapability(systemCapability, parsingStatus, parsingResult);
                } else {
                    parsingStatus.add((IStatus)JREAction.newWarningStatus(NLS.bind((String)Messages.message_eeIgnoringNamespace, (Object)namespace)));
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void parseEECapability(ManifestElement eeCapability, MultiStatus parsingStatus, List<IProvidedCapability> parsingResult) {
        String eeName = eeCapability.getAttribute(NAMESPACE_OSGI_EE);
        if (eeName == null) {
            parsingStatus.add((IStatus)JREAction.newErrorStatus(NLS.bind((String)Messages.message_eeMissingNameAttribute, (Object)eeCapability), null));
            return;
        }
        String[] eeVersions = JREAction.parseEECapabilityVersion(eeCapability, parsingStatus);
        if (eeVersions == null) {
            return;
        }
        String[] stringArray = eeVersions;
        int n = eeVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String rawVersion = stringArray[n2];
            try {
                Version parsedVersion = Version.parseVersion((String)rawVersion);
                HashMap<String, String> capAttrs = new HashMap<String, String>();
                capAttrs.put(NAMESPACE_OSGI_EE, eeName);
                capAttrs.put(VERSION_OSGI_EE, (String)parsedVersion);
                parsingResult.add(MetadataFactory.createProvidedCapability((String)NAMESPACE_OSGI_EE, capAttrs));
            }
            catch (IllegalArgumentException e) {
                parsingStatus.add((IStatus)JREAction.newErrorStatus(NLS.bind((String)Messages.message_eeInvalidVersionAttribute, (Object)rawVersion), e));
            }
            ++n2;
        }
    }

    private static String[] parseEECapabilityVersion(ManifestElement eeCapability, MultiStatus parsingStatus) {
        String singleVersion = eeCapability.getAttribute("version:Version");
        String[] multipleVersions = ManifestElement.getArrayFromList((String)eeCapability.getAttribute("version:List<Version>"));
        if (singleVersion == null && multipleVersions == null) {
            parsingStatus.add((IStatus)JREAction.newErrorStatus(NLS.bind((String)Messages.message_eeMissingVersionAttribute, (Object)eeCapability), null));
            return null;
        }
        if (singleVersion == null) {
            return multipleVersions;
        }
        if (multipleVersions == null) {
            return new String[]{singleVersion};
        }
        parsingStatus.add((IStatus)JREAction.newErrorStatus(NLS.bind((String)Messages.message_eeDuplicateVersionAttribute, (Object)eeCapability), null));
        return null;
    }

    private void generateJREIUData(MetadataFactory.InstallableUnitDescription iu) {
        String profileName;
        if (this.profileProperties == null || this.profileProperties.size() == 0) {
            return;
        }
        String profileLocation = this.profileProperties.get(PROFILE_LOCATION);
        String string = profileName = profileLocation != null ? IPath.fromOSString((String)profileLocation).lastSegment() : this.profileProperties.get(PROFILE_NAME);
        if (profileName.endsWith(".profile")) {
            profileName = profileName.substring(0, profileName.length() - 8);
        }
        Version version = null;
        int idx = profileName.indexOf(45);
        if (idx != -1) {
            try {
                version = Version.parseVersion((String)profileName.substring(idx + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            profileName = profileName.substring(0, idx);
        }
        if (version == null) {
            try {
                String targetVersion = this.profileProperties.get(PROFILE_TARGET_VERSION);
                version = targetVersion != null ? Version.parseVersion((String)targetVersion) : null;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (version == null) {
            version = DEFAULT_JRE_VERSION;
        }
        iu.setVersion(version);
        profileName = profileName.replace('-', '.');
        profileName = profileName.replace('/', '.');
        profileName = profileName.replace('_', '.');
        iu.setId("a.jre." + profileName.toLowerCase());
        List<IProvidedCapability> capabilities = this.generateJRECapability(iu.getId(), iu.getVersion());
        iu.addProvidedCapabilities(capabilities);
    }

    private void initialize(IPublisherInfo publisherInfo) {
        File runtimeProfile = null;
        this.info = publisherInfo;
        if (this.jreLocation == null && this.environment == null) {
            StringBuilder buffer = this.createDefaultProfileFromRunningJvm();
            try {
                File tempDirectory = Files.createTempDirectory("JREAction", new FileAttribute[0]).toFile();
                runtimeProfile = new File(tempDirectory, "JavaSE-11.profile");
                Throwable throwable = null;
                Object var6_7 = null;
                try (FileWriter writer = new FileWriter(runtimeProfile);){
                    writer.write(buffer.toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.jreLocation = runtimeProfile;
            }
            catch (IOException iOException) {}
        }
        if (this.jreLocation != null) {
            File javaProfile = null;
            if (this.jreLocation.isDirectory()) {
                File[] profiles = this.jreLocation.listFiles(pathname -> pathname.getAbsolutePath().endsWith(".profile"));
                if (profiles != null && profiles.length > 0) {
                    javaProfile = profiles[0];
                }
            } else if (this.jreLocation.isFile()) {
                javaProfile = this.jreLocation;
            } else {
                throw new IllegalArgumentException(NLS.bind((String)Messages.exception_nonExistingJreLocationFile, (Object)this.jreLocation.getAbsolutePath()));
            }
            this.profileProperties = this.loadProfile(javaProfile);
        }
        if (this.profileProperties == null) {
            String profileFile = (this.environment != null ? this.environment : DEFAULT_PROFILE).replace('/', '_') + ".profile";
            URL profileURL = JREAction.getResouceFromSystemBundle(profileFile);
            this.profileProperties = this.loadProfile(profileURL);
        }
        if (runtimeProfile != null) {
            runtimeProfile.delete();
            runtimeProfile.getParentFile().delete();
        }
    }

    private String calculateVMPackages() {
        try {
            ArrayList<String> packages = new ArrayList<String>();
            ModuleLayer bootLayer = ModuleLayer.boot();
            Set<Module> bootModules = bootLayer.modules();
            for (Module m : bootModules) {
                ModuleDescriptor descriptor = m.getDescriptor();
                if (descriptor.isAutomatic()) {
                    packages.addAll(descriptor.packages());
                    continue;
                }
                for (ModuleDescriptor.Exports export : descriptor.exports()) {
                    String pkg = export.source();
                    if (export.isQualified()) continue;
                    packages.add(pkg);
                }
            }
            Collections.sort(packages);
            StringBuilder result = new StringBuilder();
            for (String pkg : packages) {
                if (result.length() != 0) {
                    result.append(',').append(' ');
                }
                result.append(pkg);
            }
            return result.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private StringBuilder createDefaultProfileFromRunningJvm() {
        StringBuilder buffer = new StringBuilder();
        String NEWLINE = System.lineSeparator();
        buffer.append("org.osgi.framework.system.packages = \\");
        buffer.append(NEWLINE);
        buffer.append(' ');
        String calculateVMPackages = this.calculateVMPackages();
        if (calculateVMPackages != null) {
            String[] pack = calculateVMPackages.split(",");
            int i = 0;
            while (i < pack.length) {
                buffer.append(pack[i]);
                if (i != pack.length - 1) {
                    buffer.append(',');
                    buffer.append("\\");
                }
                buffer.append(NEWLINE);
                ++i;
            }
        }
        buffer.append("org.osgi.framework.executionenvironment = \\\n OSGi/Minimum-1.0,\\\n OSGi/Minimum-1.1,\\\n OSGi/Minimum-1.2,\\\n JavaSE/compact1-1.8,\\\n JavaSE/compact2-1.8,\\\n JavaSE/compact3-1.8,\\\n JRE-1.1,\\\n J2SE-1.2,\\\n J2SE-1.3,\\\n J2SE-1.4,\\\n J2SE-1.5,\\\n JavaSE-1.6,\\\n JavaSE-1.7,\\\n JavaSE-1.8,\\\n");
        String version = DEFAULT_PROFILE.substring(DEFAULT_PROFILE.indexOf(45) + 1);
        int ver = Integer.parseInt(version);
        int i = 9;
        while (i < ver) {
            buffer.append(" JavaSE-" + String.valueOf(i) + ",\\\n");
            ++i;
        }
        buffer.append(" JavaSE-" + String.valueOf(ver));
        buffer.append(NEWLINE);
        StringBuilder versionList = new StringBuilder();
        versionList.append("1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8");
        int i2 = 9;
        while (i2 <= ver) {
            versionList.append(", " + String.valueOf(i2) + ".0");
            ++i2;
        }
        buffer.append("org.osgi.framework.system.capabilities = \\\n osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"1.0, 1.1, 1.2\",\\\n osgi.ee; osgi.ee=\"JRE\"; version:List<Version>=\"1.0, 1.1\",\\\n osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"" + versionList.toString() + "\",\\\n osgi.ee; osgi.ee=\"JavaSE/compact1\"; version:List<Version>=\"1.8," + String.valueOf(ver) + ".0\",\\\n osgi.ee; osgi.ee=\"JavaSE/compact2\"; version:List<Version>=\"1.8," + String.valueOf(ver) + ".0\",\\\n osgi.ee; osgi.ee=\"JavaSE/compact3\"; version:List<Version>=\"1.8," + String.valueOf(ver) + ".0\"");
        buffer.append(NEWLINE);
        buffer.append("osgi.java.profile.name = JavaSE-11\norg.eclipse.jdt.core.compiler.compliance=" + String.valueOf(ver) + "\norg.eclipse.jdt.core.compiler.source=" + String.valueOf(ver) + "\norg.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode=enabled\norg.eclipse.jdt.core.compiler.codegen.targetPlatform=" + String.valueOf(ver) + "\norg.eclipse.jdt.core.compiler.problem.assertIdentifier=error\norg.eclipse.jdt.core.compiler.problem.enumIdentifier=error");
        buffer.append(NEWLINE);
        return buffer;
    }

    private static URL getResouceFromSystemBundle(String entry) {
        ClassLoader loader = FrameworkUtil.class.getClassLoader();
        return loader == null ? ClassLoader.getSystemResource(entry) : loader.getResource(entry);
    }

    private Map<String, String> loadProfile(File profileFile) {
        if (profileFile == null || !profileFile.exists()) {
            return null;
        }
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(profileFile));
            Map<String, String> properties = this.loadProfile(stream);
            if (properties != null) {
                properties.put(PROFILE_LOCATION, profileFile.getAbsolutePath());
            }
            return properties;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private Map<String, String> loadProfile(URL profileURL) {
        if (profileURL == null) {
            return null;
        }
        try {
            InputStream stream = profileURL.openStream();
            return this.loadProfile(stream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    private Map<String, String> loadProfile(InputStream stream) {
        if (stream != null) {
            Map map = CollectionUtils.loadProperties((InputStream)stream);
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            return map;
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException3) {}
                return null;
            }
        }
        return null;
    }
}

