/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.structure.DocumentModelProviderFactory;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelListener;
import org.netbeans.modules.editor.structure.api.DocumentModelStateListener;
import org.netbeans.modules.editor.structure.api.DocumentModelUtils;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class DocumentModel {
    private static int MODEL_UPDATE_TIMEOUT = 2000;
    private BaseDocument doc;
    private DocumentModelProvider provider;
    private DocumentChangesWatcher changesWatcher;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;
    private ElementsArray elements = new ElementsArray();
    private DocumentElement rootElement;
    private DocumentModelModificationTransaction modelUpdateTransaction = null;
    boolean documentDirty = true;
    private int numReaders = 0;
    private int numWriters = 0;
    private Thread currWriter = null;
    private Thread currReader = null;
    private HashSet<DocumentModelListener> dmListeners = new HashSet();
    private HashSet<DocumentModelStateListener> dmsListeners = new HashSet();
    private static final int ELEMENT_ADDED = 1;
    private static final int ELEMENT_REMOVED = 2;
    private static final int ELEMENT_CHANGED = 3;
    private static final int ELEMENT_ATTRS_CHANGED = 4;
    private static Map<Document, Object> locks = new WeakHashMap<Document, Object>();
    final Map<String, String> elementsNamesCache = new WeakHashMap<String, String>();
    final Map<String, String> elementsTypesCache = new WeakHashMap<String, String>();
    final Map<String, String> elementsAttrNamesCache = new WeakHashMap<String, String>();
    final Map<String, String> elementsAttrValueCache = new WeakHashMap<String, String>();
    private static final Map<String, String> EMPTY_ATTRS_MAP = Collections.emptyMap();
    private static final List<DocumentElement> EMPTY_ELEMENTS_LIST = Collections.emptyList();
    public static final Comparator<DocumentElement> ELEMENTS_COMPARATOR = new Comparator<DocumentElement>(){

        @Override
        public int compare(DocumentElement de1, DocumentElement de2) {
            DocumentModel model = de1.getDocumentModel();
            if (model.isRootElement(de1) && !model.isRootElement(de2)) {
                return -1;
            }
            if (!model.isRootElement(de1) && model.isRootElement(de2)) {
                return 1;
            }
            if (model.isRootElement(de2) && model.isRootElement(de1)) {
                return 0;
            }
            int startOffsetDelta = de1.getStartOffset() - de2.getStartOffset();
            if (startOffsetDelta != 0) {
                return startOffsetDelta;
            }
            int endOffsetDelta = de2.getEndOffset() - de1.getEndOffset();
            if (endOffsetDelta != 0) {
                return de1.isEmpty() || de2.isEmpty() ? -endOffsetDelta : endOffsetDelta;
            }
            int typesDelta = de1.getType().compareTo(de2.getType());
            if (typesDelta != 0) {
                return typesDelta;
            }
            int namesDelta = de1.getName().compareTo(de2.getName());
            if (namesDelta != 0) {
                return namesDelta;
            }
            int attrsComp = ((DocumentElement.Attributes)de1.getAttributes()).compareTo(de2.getAttributes());
            if (attrsComp != 0) {
                return attrsComp;
            }
            return de1.isEmpty() ? System.identityHashCode(de2) - System.identityHashCode(de1) : 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj.equals(ELEMENTS_COMPARATOR);
        }
    };
    private long parent = 0L;
    private long parent_count = 0L;
    private DocumentElement last_parent = null;
    private int last_empty_element_start_offset = -1;
    private static final String DOCUMENT_ROOT_ELEMENT_TYPE = "ROOT_ELEMENT";
    private static final boolean debug = Boolean.getBoolean("org.netbeans.editor.model.debug");
    private static final boolean measure = Boolean.getBoolean("org.netbeans.editor.model.measure");
    private static final String GENERATING_MODEL_PROPERTY = "generating_document_model";

    DocumentModel(Document doc, DocumentModelProvider provider) throws DocumentModelException {
        this.doc = (BaseDocument)doc;
        this.provider = provider;
        this.requestProcessor = new RequestProcessor(DocumentModel.class.getName());
        this.task = this.requestProcessor.create(new Runnable(){

            @Override
            public void run() {
                DocumentModel.this.updateModel();
            }
        });
        this.addRootElement();
        this.initDocumentModel();
        this.changesWatcher = new DocumentChangesWatcher();
        this.getDocument().addDocumentListener(WeakListeners.document((DocumentListener)this.changesWatcher, (Object)doc));
    }

    public static DocumentModel getDocumentModel(Document doc) throws DocumentModelException {
        Object object = DocumentModel.getLock(doc);
        synchronized (object) {
            DocumentModel cachedInstance;
            if (!(doc instanceof BaseDocument)) {
                throw new ClassCastException("Currently it is necessary to pass org.netbeans.editor.BaseDocument instance into the DocumentModel.getDocumentProvider(j.s.t.Document) method.");
            }
            WeakReference modelWR = (WeakReference)doc.getProperty(DocumentModel.class);
            DocumentModel documentModel = cachedInstance = modelWR == null ? null : (DocumentModel)modelWR.get();
            if (cachedInstance != null) {
                return cachedInstance;
            }
            Class editorKitClass = ((BaseDocument)doc).getKitClass();
            BaseKit kit = BaseKit.getKit((Class)editorKitClass);
            if (kit != null) {
                String mimeType = kit.getContentType();
                DocumentModelProvider provider = DocumentModelProviderFactory.getDefault().getDocumentModelProvider(mimeType);
                if (provider != null) {
                    DocumentModel model = new DocumentModel(doc, provider);
                    doc.putProperty(DocumentModel.class, new WeakReference<DocumentModel>(model));
                    return model;
                }
                return null;
            }
            throw new IllegalStateException("No editor kit for document " + doc + "!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getLock(Document doc) {
        Map<Document, Object> map = locks;
        synchronized (map) {
            Object lock = locks.get(doc);
            if (lock == null) {
                lock = new Object();
                locks.put(doc, lock);
            }
            return lock;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public DocumentElement getRootElement() {
        return this.rootElement;
    }

    public void addDocumentModelListener(DocumentModelListener dml) {
        this.dmListeners.add(dml);
    }

    public void removeDocumentModelListener(DocumentModelListener dml) {
        this.dmListeners.remove(dml);
    }

    public void addDocumentModelStateListener(DocumentModelStateListener dml) {
        this.dmsListeners.add(dml);
    }

    public void removeDocumentModelStateListener(DocumentModelStateListener dml) {
        this.dmsListeners.remove(dml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDescendantOf(DocumentElement ancestor, DocumentElement descendant) {
        this.readLock();
        try {
            if (ancestor == descendant) {
                if (debug) {
                    System.out.println("ERROR in " + ancestor);
                }
                this.debugElements();
                throw new IllegalArgumentException("ancestor == descendant!!!");
            }
            if (this.isRootElement(ancestor)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = DocumentModel.isDescendantOf(ancestor.getStartOffset(), ancestor.getEndOffset(), descendant.getStartOffset(), descendant.getEndOffset());
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    private static boolean isDescendantOf(int ancestorSO, int ancestorEO, int descendantSO, int descendantEO) {
        if (descendantEO != descendantSO && (ancestorSO == descendantSO && ancestorEO > descendantEO || ancestorEO == descendantEO && ancestorSO < descendantSO)) {
            return true;
        }
        return ancestorSO < descendantSO && ancestorEO > descendantEO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentElement getLeafElementForOffset(int offset) {
        this.readLock();
        this.checkDocumentDirty();
        try {
            DocumentElement de;
            if (this.getDocument().getLength() == 0) {
                DocumentElement documentElement = this.getRootElement();
                return documentElement;
            }
            DocumentElement leaf = null;
            for (int i = 0; i < this.elements.size() && (de = this.elements.get(i)).getStartOffset() <= offset; ++i) {
                if (de.getEndOffset() < offset) continue;
                if (de.getStartOffset() == de.getEndOffset() && de.getStartOffset() == offset) break;
                leaf = de;
            }
            if (leaf == null) {
                leaf = this.getRootElement();
            }
            DocumentElement documentElement = leaf;
            return documentElement;
        }
        finally {
            this.readUnlock();
        }
    }

    public void forceUpdate() {
        this.requestModelUpdate(true);
    }

    static void setModelUpdateTimout(int timeout) {
        MODEL_UPDATE_TIMEOUT = timeout;
    }

    private boolean isRootElement(DocumentElement de) {
        return de == this.getRootElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentElement getDocumentElement(int startOffset, int endOffset) throws BadLocationException {
        this.readLock();
        this.checkDocumentDirty();
        try {
            for (int i = 0; i < this.elements.size(); ++i) {
                DocumentElement de = this.elements.get(i);
                if (de.getStartOffset() == startOffset && de.getEndOffset() == endOffset) {
                    DocumentElement documentElement = de;
                    return documentElement;
                }
                if (de.getStartOffset() > startOffset) break;
            }
            DocumentElement documentElement = null;
            return documentElement;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DocumentElement> getDocumentElements(int startOffset) throws BadLocationException {
        this.readLock();
        this.checkDocumentDirty();
        try {
            DocumentElement next;
            DocumentElement previous;
            int elementIndex = this.elements.binarySearchForOffset(startOffset);
            if (elementIndex < 0) {
                List<DocumentElement> list = Collections.emptyList();
                return list;
            }
            ArrayList<DocumentElement> found = new ArrayList<DocumentElement>();
            found.add(this.elements.get(elementIndex));
            int eli = elementIndex;
            while (--eli >= 0 && (previous = this.elements.get(eli)).getStartOffset() == startOffset) {
                found.add(0, previous);
            }
            while (++elementIndex < this.elements.size() && (next = this.elements.get(elementIndex)).getStartOffset() == startOffset) {
                found.add(next);
            }
            ArrayList<DocumentElement> arrayList = found;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private DocumentModelModificationTransaction createTransaction(boolean init) {
        return new DocumentModelModificationTransaction(init);
    }

    private void initDocumentModel() throws DocumentModelException {
        block2: {
            try {
                DocumentModelModificationTransaction trans = this.createTransaction(true);
                this.provider.updateModel(trans, this, new DocumentChange[]{new DocumentChange(this.getDocument().getStartPosition(), this.getDocument().getLength(), 0)});
                trans.commit();
            }
            catch (DocumentModelTransactionCancelledException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"We should never get here");
            }
        }
    }

    private void requestModelUpdate(boolean updateImmediately) {
        if (this.modelUpdateTransaction != null) {
            this.modelUpdateTransaction.setTransactionCancelled();
        }
        this.task.schedule(updateImmediately ? 0 : MODEL_UPDATE_TIMEOUT);
    }

    private void updateModel() {
        block8: {
            this.fireScanningStarted();
            try {
                this.modelUpdateTransaction = this.createTransaction(false);
                DocumentChange[] changes = this.changesWatcher.getDocumentChanges();
                if (debug) {
                    this.debugElements();
                }
                this.provider.updateModel(this.modelUpdateTransaction, this, changes);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DocumentModel.this.writeLock();
                                DocumentModel.this.fireUpdateStarted();
                                DocumentModel.this.modelUpdateTransaction.commit();
                                DocumentModel.this.changesWatcher.clearChanges();
                                DocumentModel.this.modelUpdateTransaction = null;
                            }
                            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                            }
                            catch (Exception e) {
                                ErrorManager.getDefault().notify(4096, (Throwable)e);
                            }
                            finally {
                                DocumentModel.this.writeUnlock();
                                DocumentModel.this.fireUpdateFinished();
                            }
                        }
                    });
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
            catch (DocumentModelException e) {
                if (debug) {
                    System.err.println("[DocumentModelUpdate] " + e.getMessage());
                }
            }
            catch (DocumentModelTransactionCancelledException dmcte) {
                if (!debug) break block8;
                System.out.println("[document model] update transaction cancelled.");
            }
        }
        if (debug) {
            DocumentModelUtils.dumpElementStructure(this.getRootElement());
        }
    }

    private void checkDocumentDirty() {
        if (this.documentDirty) {
            this.writeLock();
            try {
                this.doc.readLock();
                try {
                    this.elements.resort();
                }
                finally {
                    this.doc.readUnlock();
                }
            }
            finally {
                this.writeUnlock();
            }
            this.documentDirty = false;
        }
    }

    private void addRootElement() {
        block3: {
            try {
                DocumentModelModificationTransaction dmt = this.createTransaction(false);
                this.rootElement = dmt.addDocumentElement("root", DOCUMENT_ROOT_ELEMENT_TYPE, EMPTY_ATTRS_MAP, 0, this.getDocument().getLength());
                dmt.commit();
            }
            catch (BadLocationException e) {
                throw new IllegalStateException("Adding of root document element failed - strange!");
            }
            catch (DocumentModelTransactionCancelledException dmtce) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"We should never get here");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DocumentElement> getChildren(DocumentElement de) {
        this.readLock();
        this.checkDocumentDirty();
        try {
            int index = this.elements.indexof(de);
            if (index < 0) {
                if (debug) {
                    System.out.println("Warning: DocumentModel.getChildren(...) called for " + de + " which has already been removed!");
                }
                List<DocumentElement> list = Collections.emptyList();
                return list;
            }
            if (de.isEmpty()) {
                if (this.isRootElement(de)) {
                    if (this.elements.size() > 1) {
                        List<DocumentElement> list = Arrays.asList(this.elements.subarray(1, this.elements.size()));
                        return list;
                    }
                    List<DocumentElement> list = Collections.emptyList();
                    return list;
                }
                List<DocumentElement> list = Collections.emptyList();
                return list;
            }
            ArrayList<DocumentElement> children = new ArrayList<DocumentElement>();
            if (++index < this.elements.size()) {
                DocumentElement docel;
                int docel_so;
                DocumentElement firstChild = this.elements.get(index);
                children.add(firstChild);
                if (!this.isDescendantOf(de, firstChild)) {
                    List<DocumentElement> list = Collections.emptyList();
                    return list;
                }
                DocumentElement nextChild = firstChild;
                for (int i = index + 1; i < this.elements.size() && (docel_so = (docel = this.elements.get(i)).getStartOffset()) <= de.getEndOffset(); ++i) {
                    if (docel_so < nextChild.getEndOffset()) continue;
                    children.add(docel);
                    nextChild = docel;
                }
            }
            ArrayList<DocumentElement> arrayList = children;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    DocumentElement getParent(DocumentElement de) {
        int index = this.elements.indexof(de);
        if (index < 0) {
            throw new IllegalArgumentException("getParent() called for " + de + " which is not in the elements list!");
        }
        return this.getParent(index, de.getStartOffset(), de.getEndOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentElement getParent(int index, int de_so, int de_eo) {
        if (index < 0) {
            throw new IllegalArgumentException("index must be positive!");
        }
        if (index == 0) {
            return null;
        }
        this.readLock();
        this.checkDocumentDirty();
        try {
            for (int i = index - 1; i >= 0; --i) {
                DocumentElement el = this.elements.get(i);
                int el_so = el.getStartOffset();
                int el_eo = el.getEndOffset();
                if (el_so >= de_so || el_so == el_eo || !DocumentModel.isDescendantOf(el_so, el_eo, de_so, de_eo)) continue;
                DocumentElement documentElement = el;
                return documentElement;
            }
            DocumentElement documentElement = this.getRootElement();
            return documentElement;
        }
        finally {
            this.readUnlock();
        }
    }

    private DocumentElement createDocumentElement(String name, String type, Map<String, String> attributes, int startOffset, int endOffset) throws BadLocationException {
        return new DocumentElement(name, type, attributes, startOffset, endOffset, this);
    }

    private void fireDocumentModelEvent(DocumentElement de, int type) {
        for (DocumentModelListener cl : this.dmListeners) {
            switch (type) {
                case 1: {
                    cl.documentElementAdded(de);
                    break;
                }
                case 2: {
                    cl.documentElementRemoved(de);
                    break;
                }
                case 3: {
                    cl.documentElementChanged(de);
                    break;
                }
                case 4: {
                    cl.documentElementAttributesChanged(de);
                }
            }
        }
    }

    private void fireSourceChanged() {
        for (DocumentModelStateListener cl : this.dmsListeners) {
            cl.sourceChanged();
        }
    }

    private void fireScanningStarted() {
        for (DocumentModelStateListener cl : this.dmsListeners) {
            cl.scanningStarted();
        }
    }

    private void fireUpdateStarted() {
        for (DocumentModelStateListener cl : this.dmsListeners) {
            cl.updateStarted();
        }
    }

    private void fireUpdateFinished() {
        for (DocumentModelStateListener cl : this.dmsListeners) {
            cl.updateFinished();
        }
    }

    public final synchronized void readLock() {
        try {
            while (this.currWriter != null) {
                if (this.currWriter == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            this.currReader = Thread.currentThread();
            ++this.numReaders;
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to aquire read lock");
        }
    }

    public final synchronized void readUnlock() {
        if (this.currWriter == Thread.currentThread()) {
            return;
        }
        assert (this.numReaders > 0) : "Bad read lock state!";
        --this.numReaders;
        if (this.numReaders == 0) {
            this.currReader = null;
        }
        this.notify();
    }

    private final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currWriter != null) {
                if (Thread.currentThread() == this.currWriter) {
                    ++this.numWriters;
                    return;
                }
                if (Thread.currentThread() == this.currReader) {
                    return;
                }
                this.wait();
            }
            this.currWriter = Thread.currentThread();
            this.numWriters = 1;
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    private final synchronized void writeUnlock() {
        if (--this.numWriters <= 0) {
            this.numWriters = 0;
            this.currWriter = null;
            this.notifyAll();
        }
    }

    void debugElements() {
        System.out.println("DEBUG ELEMENTS:");
        for (int i = 0; i < this.elements.size(); ++i) {
            System.out.println(this.elements.get(i));
        }
        System.out.println("*****\n");
    }

    DocumentElement[] elements() {
        this.readLock();
        try {
            DocumentElement[] clone = new DocumentElement[this.elements.size()];
            System.arraycopy(this.elements.elements, 0, clone, 0, clone.length);
            DocumentElement[] documentElementArray = clone;
            return documentElementArray;
        }
        finally {
            this.readUnlock();
        }
    }

    private static class ElementsArray {
        private DocumentElement[] elements = new DocumentElement[1000];
        private int size = 0;
        private int increase_capacity_delta = 100;
        private boolean needs_resort = false;

        ElementsArray() {
        }

        public void fastAdd(DocumentElement de) {
            this.checkCapacity();
            this.elements[this.size++] = de;
            this.needs_resort = true;
        }

        public void add(DocumentElement de) {
            this.checkIntegrity();
            int index = this.indexof(de);
            if (index >= 0) {
                return;
            }
            this.checkCapacity();
            index = -index - 1;
            this.checkIndex(index);
            int move = this.size - index - 1;
            if (move > 0) {
                System.arraycopy(this.elements, index, this.elements, index + 1, move);
            }
            this.elements[index] = de;
            ++this.size;
        }

        public void remove(int index) {
            this.checkIntegrity();
            if (index < 0) {
                return;
            }
            this.checkIndex(index);
            int move = this.size - index - 1;
            if (move > 0) {
                System.arraycopy(this.elements, index + 1, this.elements, index, move);
            }
            this.elements[--this.size] = null;
        }

        public void remove(DocumentElement de) {
            this.checkIntegrity();
            this.remove(this.indexof(de));
        }

        public int indexof(DocumentElement de) {
            this.checkIntegrity();
            return this.binarySearch(de);
        }

        public DocumentElement get(int index) {
            this.checkIntegrity();
            this.checkIndex(index);
            return this.elements[index];
        }

        public boolean contains(DocumentElement de) {
            return this.indexof(de) >= 0;
        }

        public int size() {
            this.checkIntegrity();
            return this.size;
        }

        public void resort() {
            Arrays.sort(this.elements, 0, this.size, ELEMENTS_COMPARATOR);
            this.needs_resort = false;
        }

        public DocumentElement[] subarray(int from, int to) {
            this.checkIntegrity();
            this.checkIndex(from);
            if (to < 0 || to > this.size) {
                throw new IllegalArgumentException("Index out of range: " + to + " (size = " + this.size + ")");
            }
            int len = to - from;
            if (len < 0) {
                throw new IllegalArgumentException("from > to: " + from + " > " + to);
            }
            DocumentElement[] sub = new DocumentElement[len];
            System.arraycopy(this.elements, from, sub, 0, len);
            return sub;
        }

        private void checkIntegrity() {
            if (this.needs_resort) {
                throw new IllegalStateException("Elements are inconsistent - fastAdd() called without subsequent resort() call!");
            }
        }

        private void checkIndex(int index) {
            if (index < 0 || index >= this.size) {
                throw new IllegalArgumentException("Index out of range: " + index + " (size = " + this.size + ")");
            }
        }

        private void checkCapacity() {
            int free = this.elements.length - this.size;
            assert (free >= 0);
            if (free == 0) {
                this.increase_capacity_delta *= 5;
                DocumentElement[] old_elements = this.elements;
                this.elements = new DocumentElement[this.size + this.increase_capacity_delta];
                System.arraycopy(old_elements, 0, this.elements, 0, old_elements.length);
            }
        }

        private int binarySearch(DocumentElement key) {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                DocumentElement midVal = this.elements[mid];
                int cmp = ELEMENTS_COMPARATOR.compare(midVal, key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public int binarySearchForOffset(int offset) {
            this.checkIntegrity();
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                DocumentElement midVal = this.elements[mid];
                int so = midVal.getStartOffset();
                int cmp = so - offset;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }
    }

    public class DocumentChange {
        public static final int INSERT = 0;
        public static final int REMOVE = 1;
        private Position changeStart;
        private int changeLength;
        private int type;

        DocumentChange(Position changeStart, int changeLength, int type) {
            this.changeStart = changeStart;
            this.changeLength = changeLength;
            this.type = type;
        }

        public Position getChangeStart() {
            return this.changeStart;
        }

        public int getChangeLength() {
            return this.changeLength;
        }

        public int getChangeType() {
            return this.type;
        }

        public String toString() {
            return "Change[" + this.getChangeStart().getOffset() + "-" + (this.getChangeStart().getOffset() + this.getChangeLength()) + "-" + (this.type == 0 ? "INSERT" : "REMOVE") + "] text: " + this.getChangeText();
        }

        private String getChangeText() {
            try {
                String text = DocumentModel.this.getDocument().getText(this.getChangeStart().getOffset(), this.getChangeLength());
                if (this.type == 0) {
                    return text;
                }
                if (this.type == 1) {
                    return "[cannot provide removed text]; the text on remove offset: " + text;
                }
                assert (false) : "Wrong document change type!";
            }
            catch (BadLocationException e) {
                return "BadLocationException thrown: " + e.getMessage();
            }
            return null;
        }
    }

    private final class DocumentChangesWatcher
    implements DocumentListener {
        private ArrayList<DocumentChange> documentChanges = new ArrayList();

        private DocumentChangesWatcher() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        private void documentChanged(DocumentEvent documentEvent) {
            if (!DocumentModel.this.documentDirty) {
                DocumentModel.this.fireSourceChanged();
            }
            DocumentModel.this.documentDirty = true;
            try {
                if (DocumentModel.this.getRootElement().getStartOffset() > 0 || DocumentModel.this.getRootElement().getEndOffset() < DocumentModel.this.getDocument().getLength()) {
                    DocumentModel.this.getRootElement().setStartPosition(0);
                    DocumentModel.this.getRootElement().setEndPosition(DocumentModel.this.getDocument().getLength());
                }
                int change_offset = documentEvent.getOffset();
                int change_length = documentEvent.getLength();
                int type = documentEvent.getType().equals(DocumentEvent.EventType.REMOVE) ? 1 : 0;
                DocumentChange dchi = new DocumentChange(DocumentModel.this.getDocument().createPosition(change_offset), change_length, type);
                this.documentChanges.add(dchi);
                if (debug) {
                    System.out.println(dchi);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            DocumentModel.this.requestModelUpdate(false);
        }

        public DocumentChange[] getDocumentChanges() {
            List changes = (List)this.documentChanges.clone();
            return changes.toArray(new DocumentChange[0]);
        }

        public void clearChanges() {
            this.documentChanges.clear();
        }
    }

    public final class DocumentModelTransactionCancelledException
    extends Exception {
    }

    public final class DocumentModelModificationTransaction {
        private ArrayList<DocumentModelModification> modifications = new ArrayList();
        private boolean transactionCancelled = false;
        private boolean init;

        DocumentModelModificationTransaction(boolean init) {
            this.init = init;
        }

        public DocumentElement addDocumentElement(String name, String type, Map<String, String> attributes, int startOffset, int endOffset) throws BadLocationException, DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentElement de = DocumentModel.this.createDocumentElement(name, type, attributes, startOffset, endOffset);
            assert (startOffset < endOffset);
            if (!DocumentModel.this.elements.contains(de)) {
                if (debug) {
                    System.out.println("# ADD " + de + " adding into transaction");
                }
                DocumentModelModification dmm = new DocumentModelModification(de, 1);
                this.modifications.add(dmm);
            }
            return de;
        }

        public void removeDocumentElement(DocumentElement de, boolean removeAllItsDescendants) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            if (DocumentModel.this.isRootElement(de)) {
                if (debug) {
                    System.out.println("WARNING: root element cannot be removed!");
                }
                return;
            }
            if (debug) {
                System.out.println("# REMOVE " + de + " adding into transaction ");
            }
            if (removeAllItsDescendants) {
                for (DocumentElement child : DocumentModel.this.getChildren(de)) {
                    this.removeDocumentElement(child, true);
                }
            }
            DocumentModelModification dmm = new DocumentModelModification(de, 2);
            this.modifications.add(dmm);
        }

        public void updateDocumentElementText(DocumentElement de) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentModelModification dmm = new DocumentModelModification(de, 3);
            if (!this.modifications.contains(dmm)) {
                this.modifications.add(dmm);
            }
        }

        public void updateDocumentElementAttribs(DocumentElement de, Map<String, String> attrs) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentModelModification dmm = new DocumentModelModification(de, 4, attrs);
            if (!this.modifications.contains(dmm)) {
                this.modifications.add(dmm);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit() throws DocumentModelTransactionCancelledException {
            long a = System.currentTimeMillis();
            DocumentModel.this.writeLock();
            try {
                if (this.transactionCancelled) {
                    throw new DocumentModelTransactionCancelledException();
                }
                long r = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting REMOVEs");
                }
                Iterator<DocumentModelModification> mods = this.modifications.iterator();
                int removes = 0;
                DocumentModel.this.last_empty_element_start_offset = -1;
                DocumentModel.this.last_parent = null;
                while (mods.hasNext()) {
                    DocumentModelModification dmm = mods.next();
                    if (dmm.type != 2) continue;
                    if (this.removeDE(dmm.de)) {
                        ++removes;
                        continue;
                    }
                    System.out.println("[DMT] cannot remove element " + dmm.de);
                }
                if (measure) {
                    System.out.println("[xmlmodel] " + removes + " removes commited in " + (System.currentTimeMillis() - r));
                }
                long adds = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting ADDs");
                }
                mods = this.modifications.iterator();
                ArrayList<DocumentElement> added = new ArrayList<DocumentElement>();
                while (mods.hasNext()) {
                    DocumentModelModification dmm = mods.next();
                    if (dmm.type != 1) continue;
                    added.add(dmm.de);
                    DocumentModel.this.elements.fastAdd(dmm.de);
                }
                DocumentModel.this.elements.resort();
                if (!this.init) {
                    for (DocumentElement de : added) {
                        this.fireElementAddedEvent(de);
                    }
                }
                if (measure) {
                    System.out.println("[xmlmodel] " + added.size() + " adds commited in " + (System.currentTimeMillis() - adds));
                }
                long upds = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting text UPDATESs");
                }
                for (DocumentModelModification dmm : this.modifications) {
                    if (dmm.type != 3) continue;
                    this.updateDEText(dmm.de);
                }
                if (debug) {
                    System.out.println("\n# commiting attribs UPDATESs");
                }
                for (DocumentModelModification dmm : this.modifications) {
                    if (dmm.type != 4) continue;
                    this.updateDEAttrs(dmm.de, dmm.attrs);
                }
                if (measure) {
                    System.out.println("[xmlmodel] updates commit done in " + (System.currentTimeMillis() - upds));
                }
            }
            finally {
                DocumentModel.this.writeUnlock();
            }
            if (debug) {
                System.out.println("# commit finished\n");
            }
            if (measure) {
                System.out.println("[xmlmodel] commit done in " + (System.currentTimeMillis() - a));
            }
        }

        private void updateDEText(DocumentElement de) {
            DocumentModel.this.fireDocumentModelEvent(de, 3);
            de.contentChanged();
        }

        private void updateDEAttrs(DocumentElement de, Map<String, String> attrs) {
            de.setAttributes(attrs);
            DocumentModel.this.fireDocumentModelEvent(de, 4);
            de.attributesChanged();
        }

        private void fireElementAddedEvent(DocumentElement de) {
            DocumentElement parent = de.getParentElement();
            if (parent != null) {
                List<DocumentElement> children = de.getChildren();
                parent.childAdded(de);
                for (DocumentElement child : children) {
                    parent.childRemoved(child);
                    de.childAdded(child);
                }
            }
            DocumentModel.this.fireDocumentModelEvent(de, 1);
        }

        private boolean removeDE(DocumentElement de) {
            boolean empty;
            if (debug) {
                System.out.println("[DTM] removing " + de);
            }
            DocumentElement parent = null;
            int index = DocumentModel.this.elements.indexof(de);
            if (index <= 0) {
                return false;
            }
            int de_so = de.getStartOffset();
            int de_eo = de.getEndOffset();
            boolean bl = empty = de_eo - de_so == 0;
            if (empty && DocumentModel.this.last_empty_element_start_offset == de_so) {
                parent = DocumentModel.this.last_parent;
            }
            if (parent == null) {
                parent = DocumentModel.this.getParent(index, de_so, de_eo);
                if (empty) {
                    DocumentModel.this.last_empty_element_start_offset = de_so;
                    DocumentModel.this.last_parent = parent;
                }
            }
            List<DocumentElement> children = empty ? null : de.getChildren();
            DocumentModel.this.elements.remove(index);
            if (!empty) {
                for (DocumentElement child : children) {
                    if (debug) {
                        System.out.println("switching child " + child + "from removed " + de + "to parent " + parent);
                    }
                    de.childRemoved(child);
                    parent.childAdded(child);
                }
            }
            if (parent != null) {
                parent.childRemoved(de);
            }
            DocumentModel.this.fireDocumentModelEvent(de, 2);
            if (debug) {
                System.out.println("[DMT] removed element " + de + " ;parent = " + parent);
            }
            return true;
        }

        private void setTransactionCancelled() {
            this.transactionCancelled = true;
        }

        private final class DocumentModelModification {
            public static final int ELEMENT_ADD = 1;
            public static final int ELEMENT_REMOVED = 2;
            public static final int ELEMENT_CHANGED = 3;
            public static final int ELEMENT_ATTRS_CHANGED = 4;
            public int type;
            public DocumentElement de;
            public Map<String, String> attrs = null;

            public DocumentModelModification(DocumentElement de, int type) {
                this.de = de;
                this.type = type;
            }

            public DocumentModelModification(DocumentElement de, int type, Map<String, String> attrs) {
                this(de, type);
                this.attrs = attrs;
            }

            public boolean equals(Object o) {
                if (!(o instanceof DocumentModelModification)) {
                    return false;
                }
                DocumentModelModification dmm = (DocumentModelModification)o;
                return dmm.type == this.type && dmm.de.equals(this.de);
            }
        }
    }
}

