/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jsui.frames.models;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.modules.debugger.jpda.js.frames.JSStackFrame;
import org.netbeans.modules.debugger.jpda.jsui.frames.models.Bundle;
import org.netbeans.modules.debugger.jpda.jsui.frames.models.DebuggingJSTreeModel;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.awt.Actions;
import org.openide.util.NbPreferences;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;

public class DebuggingJSFramesInJavaModelFilter
implements TreeModelFilter,
NodeActionsProviderFilter {
    static final Preferences preferences = NbPreferences.forModule(DebuggingJSFramesInJavaModelFilter.class);
    static final String PREF_DISPLAY_JS_STACKS = "displayJSStacks";
    private final Set<DebuggingView.DVThread> threadsWithJSStacks = Collections.synchronizedSet(new WeakSet());
    private volatile boolean displayJSStacks = preferences.getBoolean("displayJSStacks", true);
    private final DisplayJSStacksAction displayJSStacksAction = new DisplayJSStacksAction();
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        Object[] jsChildren;
        Object[] children = original.getChildren(parent, from, to);
        if (parent instanceof DebuggingView.DVThread && (jsChildren = DebuggingJSTreeModel.createChildrenWithJSStack(children)) != null) {
            this.threadsWithJSStacks.add((DebuggingView.DVThread)parent);
            if (this.displayJSStacks) {
                children = DebuggingJSTreeModel.filterChildren(jsChildren);
            }
        }
        return children;
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSStackFrame) {
            return true;
        }
        boolean leaf = original.isLeaf(node);
        if (leaf && node instanceof DebuggingView.DVThread) {
            this.threadsWithJSStacks.remove((DebuggingView.DVThread)node);
        }
        return leaf;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireModelListeners() {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        if (node instanceof DebuggingView.DVThread && this.threadsWithJSStacks.contains((DebuggingView.DVThread)node)) {
            Action[] newActions = new Action[actions.length + 2];
            System.arraycopy(actions, 0, newActions, 0, actions.length);
            newActions[actions.length] = null;
            newActions[actions.length + 1] = this.displayJSStacksAction;
            actions = newActions;
        }
        return actions;
    }

    private class DisplayJSStacksAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem cbb;

        public DisplayJSStacksAction() {
            this.cbb = new JCheckBoxMenuItem(Bundle.LBL_DisplayAllJavaFrames(), !DebuggingJSFramesInJavaModelFilter.this.displayJSStacks);
            Actions.connect((AbstractButton)this.cbb, (Action)this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebuggingJSFramesInJavaModelFilter.this.displayJSStacks = !DebuggingJSFramesInJavaModelFilter.this.displayJSStacks;
            preferences.putBoolean(DebuggingJSFramesInJavaModelFilter.PREF_DISPLAY_JS_STACKS, DebuggingJSFramesInJavaModelFilter.this.displayJSStacks);
            DebuggingJSFramesInJavaModelFilter.this.fireModelListeners();
        }

        public JMenuItem getPopupPresenter() {
            this.cbb.setSelected(!DebuggingJSFramesInJavaModelFilter.this.displayJSStacks);
            return this.cbb;
        }
    }
}

