/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Language;

public class ASTNode
extends ASTItem {
    private String nt;
    private Map<String, ASTItem> nameToChild = null;

    public static ASTNode createCompoundASTNode(Language language, String nt, List<ASTItem> children, int offset) {
        return new CompoundNode(language, nt, offset, children);
    }

    public static ASTNode create(Language language, String nt, List<ASTItem> children, int offset) {
        return new ASTNode(language, nt, offset, children);
    }

    public static ASTNode create(Language language, String nt, int offset) {
        return new ASTNode(language, nt, offset, Collections.<ASTItem>emptyList());
    }

    private ASTNode(Language language, String nt, int offset, List<ASTItem> children) {
        super(language, offset, -1, children);
        if (!this.getClass().equals(ASTNode.class) && !this.getClass().equals(CompoundNode.class)) {
            throw new IllegalArgumentException("Do not extend ASTNode!");
        }
        this.nt = nt;
    }

    public String getNT() {
        return this.nt;
    }

    public ASTNode findNode(String nt, int offset) {
        if (nt.equals(this.getNT())) {
            return this;
        }
        for (ASTItem e : this.getChildren()) {
            ASTNode node;
            if (!(e instanceof ASTNode) || (node = (ASTNode)e).getOffset() > offset || offset >= node.getEndOffset()) continue;
            return node.findNode(nt, offset);
        }
        return null;
    }

    public String getTokenTypeIdentifier(String type) {
        ASTToken token = this.getTokenType(type);
        if (token == null) {
            return null;
        }
        return token.getIdentifier();
    }

    public ASTToken getTokenType(String type) {
        ASTNode node = this;
        int i = type.lastIndexOf(46);
        if (i >= 0) {
            node = this.getNode(type.substring(0, i));
        }
        if (node == null) {
            return null;
        }
        Object o = node.getChild("token-type-" + type.substring(i + 1));
        if (o == null) {
            return null;
        }
        if (!(o instanceof ASTToken)) {
            return null;
        }
        return (ASTToken)o;
    }

    public ASTNode getNode(String path) {
        ASTNode node = this;
        int s = 0;
        int e = path.indexOf(46);
        while (e >= 0) {
            if ((node = (ASTNode)node.getChild("node-" + path.substring(s, e))) == null) {
                return null;
            }
            s = e + 1;
            e = path.indexOf(46, s);
        }
        return (ASTNode)node.getChild("node-" + path.substring(s));
    }

    @Override
    public void addChildren(ASTItem item) {
        super.addChildren(item);
        if (this.nameToChild != null) {
            if (item instanceof ASTToken) {
                ASTToken t = (ASTToken)item;
                this.nameToChild.put("token-type-" + t.getTypeName(), t);
            } else {
                this.nameToChild.put("node-" + ((ASTNode)item).getNT(), item);
            }
        }
    }

    @Override
    public void removeChildren(ASTItem item) {
        super.removeChildren(item);
        if (this.nameToChild != null) {
            if (item instanceof ASTToken) {
                ASTToken t = (ASTToken)item;
                this.nameToChild.remove("token-type-" + t.getTypeName());
            } else {
                this.nameToChild.remove("node-" + ((ASTNode)item).getNT());
            }
        }
    }

    @Override
    public void setChildren(int index, ASTItem item) {
        ASTToken t;
        ASTItem old = this.getChildren().get(index);
        if (this.nameToChild != null) {
            if (old instanceof ASTToken) {
                t = (ASTToken)old;
                this.nameToChild.remove("token-type-" + t.getTypeName());
            } else {
                this.nameToChild.remove("node-" + ((ASTNode)old).getNT());
            }
        }
        super.setChildren(index, item);
        if (this.nameToChild != null) {
            if (item instanceof ASTToken) {
                t = (ASTToken)item;
                this.nameToChild.put("token-type-" + t.getTypeName(), item);
            } else {
                this.nameToChild.put("node-" + ((ASTNode)item).getNT(), item);
            }
        }
    }

    private Object getChild(String name) {
        if (this.nameToChild == null) {
            this.nameToChild = new HashMap<String, ASTItem>();
            for (ASTItem item : this.getChildren()) {
                if (item instanceof ASTToken) {
                    ASTToken t = (ASTToken)item;
                    this.nameToChild.put("token-type-" + t.getTypeName(), t);
                    continue;
                }
                this.nameToChild.put("node-" + ((ASTNode)item).getNT(), item);
            }
        }
        return this.nameToChild.get(name);
    }

    public String print() {
        return this.print("");
    }

    private String print(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("ASTNode ").append(this.getNT()).append(' ').append(this.getOffset()).append('-').append(this.getEndOffset());
        indent = "  " + indent;
        for (ASTItem elem : this.getChildren()) {
            if (elem instanceof ASTNode) {
                sb.append('\n').append(((ASTNode)elem).print(indent));
                continue;
            }
            sb.append('\n').append(indent).append(elem);
        }
        return sb.toString();
    }

    public String getAsText() {
        StringBuilder sb = new StringBuilder();
        for (ASTItem elem : this.getChildren()) {
            if (elem instanceof ASTNode) {
                sb.append(((ASTNode)elem).getAsText());
                continue;
            }
            sb.append(((ASTToken)elem).getIdentifier());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ASTNode ").append(this.getNT()).append(' ').append(this.getOffset()).append('-').append(this.getEndOffset());
        for (ASTItem elem : this.getChildren()) {
            if (elem instanceof ASTNode) {
                sb.append("\n    ").append(((ASTNode)elem).getNT() + "...");
                continue;
            }
            sb.append("\n    ").append(elem);
        }
        return sb.toString();
    }

    private static final class CompoundNode
    extends ASTNode {
        CompoundNode(Language language, String nt, int offset, List<ASTItem> children) {
            super(language, nt, offset, children);
        }

        @Override
        public ASTPath findPath(int offset) {
            ASTPath result = null;
            for (ASTItem item : this.getChildren()) {
                if (offset >= item.getEndOffset() || item.getOffset() > offset) continue;
                ArrayList<ASTItem> p = new ArrayList<ASTItem>();
                p.add(this);
                ASTPath path = item.findPath(p, offset);
                if (result != null && path.getLeaf().getLength() >= result.getLeaf().getLength()) continue;
                result = path;
            }
            if (result == null) {
                result = ASTPath.create(this);
            }
            return result;
        }
    }
}

