/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.phrase;

import org.eclipse.mylyn.internal.wikitext.textile.core.Textile;
import org.eclipse.mylyn.internal.wikitext.textile.core.TextileContentState;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.core.parser.util.Matcher;

public class HyperlinkPhraseModifier
extends PatternBasedElement {
    protected static final int ATTRIBUTES_OFFSET = 2;

    protected String getPattern(int groupOffset) {
        return "(?:(\")(?:(?:\\(([^#\\)]+)?(?:#([^\\(\\)]+))?\\))|(?:\\{([^\\{\\}]+)\\})|(?:\\[([^\\[\\]]+)\\])){0,3}([^\"]+)\\" + (1 + groupOffset) + ":([^\\s]*[^\\s!.(,:;]))";
    }

    protected int getPatternGroupCount() {
        return 7;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkProcessor();
    }

    private static class HyperlinkProcessor
    extends PatternBasedElementProcessor {
        private HyperlinkProcessor() {
        }

        public void emit() {
            String hyperlinkBoundaryText = this.group(1);
            String hyperlinkSrc = this.group(6);
            String href = this.group(7);
            String namedLinkUrl = ((TextileContentState)this.getState()).getNamedLinkUrl(href);
            if (namedLinkUrl != null) {
                href = namedLinkUrl;
            }
            if (hyperlinkBoundaryText.equals("\"")) {
                LinkAttributes attributes = new LinkAttributes();
                attributes.setHref(href);
                Textile.configureAttributes((Matcher)this, (Attributes)attributes, 2, false);
                this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
                int textOffset = this.start(2);
                if (textOffset == -1) {
                    textOffset = this.start(6);
                }
                this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, textOffset, hyperlinkSrc, 0);
                this.builder.endSpan();
            } else {
                ImageAttributes attributes = new ImageAttributes();
                Textile.configureAttributes((Matcher)this, (Attributes)attributes, 2, false);
                this.builder.imageLink((Attributes)attributes, href, hyperlinkSrc);
            }
        }
    }
}

