/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.ClassLoaderFieldValue;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofFieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;
import org.netbeans.lib.profiler.heap.TagBounds;

class ClassDump
extends HprofObject
implements JavaClass {
    private static final boolean DEBUG = false;
    private static final Set CANNOT_CONTAIN_ITSELF = new HashSet<String>(Arrays.asList("java.lang.String", "java.lang.StringBuffer", "java.lang.StringBuilder", "java.io.File"));
    final ClassDumpSegment classDumpSegment;
    private int instances;
    private long firstInstanceOffset;
    private long loadClassOffset;
    private long retainedSizeByClass;

    ClassDump(ClassDumpSegment segment, long offset) {
        super(offset);
        this.classDumpSegment = segment;
        assert (this.getHprofBuffer().get(offset) == 32);
    }

    @Override
    public long getAllInstancesSize() {
        if (this.isArray()) {
            return (Long)this.classDumpSegment.arrayMap.get(this);
        }
        return (long)this.getInstancesCount() * (long)this.getInstanceSize();
    }

    @Override
    public boolean isArray() {
        return this.classDumpSegment.arrayMap.get(this) != null;
    }

    @Override
    public Instance getClassLoader() {
        return this.getHprof().getInstanceByID(this.getClassLoaderId());
    }

    public Field getField(String name) {
        for (Field field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List getFields() {
        List filedsList = (List)this.classDumpSegment.fieldsCache.get(this);
        if (filedsList == null) {
            filedsList = Collections.unmodifiableList(this.computeFields());
            this.classDumpSegment.fieldsCache.put(this, filedsList);
        }
        return filedsList;
    }

    @Override
    public int getInstanceSize() {
        if (this.isArray()) {
            return -1;
        }
        int size = this.getRawInstanceSize();
        if (!this.classDumpSegment.newSize) {
            size += this.classDumpSegment.getMinimumInstanceSize();
        }
        return size;
    }

    @Override
    public long getRetainedSizeByClass() {
        this.getHprof().computeRetainedSizeByClass();
        return this.retainedSizeByClass;
    }

    @Override
    public List getInstances() {
        int instancesCount = this.getInstancesCount();
        if (instancesCount == 0) {
            return Collections.EMPTY_LIST;
        }
        long classId = this.getJavaClassId();
        HprofHeap heap = this.getHprof();
        HprofByteBuffer dumpBuffer = this.getHprofBuffer();
        int idSize = dumpBuffer.getIDSize();
        ArrayList<InstanceDump> instancesList = new ArrayList<InstanceDump>(instancesCount);
        TagBounds allInstanceDumpBounds = heap.getAllInstanceDumpBounds();
        long[] offset = new long[]{this.firstInstanceOffset};
        while (offset[0] < allInstanceDumpBounds.endOffset) {
            InstanceDump instance;
            long start = offset[0];
            int classIdOffset = 0;
            long instanceClassId = 0L;
            int tag = heap.readDumpTag(offset);
            if (tag == 33) {
                classIdOffset = idSize + 4;
            } else if (tag == 34) {
                classIdOffset = idSize + 4 + 4;
            } else if (tag == 35) {
                byte type = dumpBuffer.get(start + 1L + (long)idSize + 4L + 4L);
                instanceClassId = this.classDumpSegment.getPrimitiveArrayClass(type).getJavaClassId();
            }
            if (classIdOffset != 0) {
                instanceClassId = dumpBuffer.getID(start + 1L + (long)classIdOffset);
            }
            if (instanceClassId != classId) continue;
            if (tag == 33) {
                instance = new InstanceDump(this, start);
            } else if (tag == 34) {
                instance = new ObjectArrayDump(this, start);
            } else if (tag == 35) {
                instance = new PrimitiveArrayDump(this, start);
            } else {
                throw new IllegalArgumentException("Illegal tag " + tag);
            }
            instancesList.add(instance);
            if (--instancesCount != 0) continue;
            return instancesList;
        }
        return instancesList;
    }

    @Override
    public Iterator getInstancesIterator() {
        int instancesCount = this.getInstancesCount();
        if (instancesCount == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new InstancesIterator(instancesCount);
    }

    @Override
    public int getInstancesCount() {
        if (this.instances == 0) {
            this.getHprof().computeInstances();
        }
        return this.instances;
    }

    @Override
    public long getJavaClassId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classIDOffset);
    }

    @Override
    public String getName() {
        return this.getLoadClass().getName();
    }

    @Override
    public List getStaticFieldValues() {
        return this.getStaticFieldValues(true);
    }

    @Override
    public Collection getSubClasses() {
        List classes = this.getHprof().getAllClasses();
        ArrayList<JavaClass> subclasses = new ArrayList<JavaClass>(classes.size() / 10);
        HashMap<ClassDump, Boolean> subclassesMap = new HashMap<ClassDump, Boolean>(classes.size() * 4 / 3);
        subclassesMap.put(this, Boolean.TRUE);
        for (int i = 0; i < classes.size(); ++i) {
            JavaClass jcls = (JavaClass)classes.get(i);
            Boolean b = (Boolean)subclassesMap.get(jcls);
            if (b == null) {
                b = ClassDump.isSubClass(jcls, subclassesMap);
            }
            if (!b.booleanValue() || jcls == this) continue;
            subclasses.add(jcls);
        }
        return subclasses;
    }

    @Override
    public JavaClass getSuperClass() {
        long superClassId = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.superClassIDOffset);
        return this.classDumpSegment.getClassDumpByID(superClassId);
    }

    @Override
    public Object getValueOfStaticField(String name) {
        for (FieldValue fieldValue : this.getStaticFieldValues()) {
            if (!fieldValue.getField().getName().equals(name)) continue;
            if (fieldValue instanceof HprofFieldObjectValue) {
                return ((HprofFieldObjectValue)fieldValue).getInstance();
            }
            return ((HprofFieldValue)fieldValue).getTypeValue();
        }
        return null;
    }

    private List computeFields() {
        HprofByteBuffer buffer = this.getHprofBuffer();
        long offset = this.fileOffset + (long)this.getInstanceFieldOffset();
        int fields = buffer.getShort(offset);
        ArrayList<HprofField> filedsList = new ArrayList<HprofField>(fields);
        for (int i = 0; i < fields; ++i) {
            filedsList.add(new HprofField(this, offset + 2L + (long)(i * this.classDumpSegment.fieldSize)));
        }
        return filedsList;
    }

    List getStaticFieldValues(boolean addClassLoader) {
        HprofByteBuffer buffer = this.getHprofBuffer();
        long offset = this.fileOffset + (long)this.getStaticFieldOffset();
        HprofHeap heap = this.getHprof();
        int fields = buffer.getShort(offset);
        offset += 2L;
        ArrayList<HprofFieldObjectValue> filedsList = new ArrayList<HprofFieldObjectValue>(fields + (addClassLoader ? (short)0 : 1));
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(offset + (long)this.classDumpSegment.fieldTypeOffset);
            int fieldSize = this.classDumpSegment.fieldSize + heap.getValueSize(type);
            HprofFieldValue value = type == 2 ? new HprofFieldObjectValue(this, offset) : new HprofFieldValue(this, offset);
            filedsList.add((HprofFieldObjectValue)value);
            offset += (long)fieldSize;
        }
        if (addClassLoader) {
            long classLoaderOffset = this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset;
            filedsList.add(new ClassLoaderFieldValue(this, classLoaderOffset));
        }
        return filedsList;
    }

    List getAllInstanceFields() {
        ArrayList fields = new ArrayList(50);
        for (JavaClass jcls = this; jcls != null; jcls = jcls.getSuperClass()) {
            fields.addAll(jcls.getFields());
        }
        return fields;
    }

    void setClassLoadOffset(long offset) {
        this.loadClassOffset = offset;
    }

    int getConstantPoolSize() {
        long cpOffset = this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset;
        HprofByteBuffer buffer = this.getHprofBuffer();
        int cpRecords = buffer.getShort(cpOffset);
        HprofHeap heap = this.getHprof();
        cpOffset += 2L;
        for (int i = 0; i < cpRecords; ++i) {
            byte type = buffer.get(cpOffset + 2L);
            int size = heap.getValueSize(type);
            cpOffset += (long)(3 + size);
        }
        return (int)(cpOffset - (this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset));
    }

    int getRawInstanceSize() {
        return this.getHprofBuffer().getInt(this.fileOffset + (long)this.classDumpSegment.instanceSizeOffset);
    }

    HprofHeap getHprof() {
        return this.classDumpSegment.hprofHeap;
    }

    HprofByteBuffer getHprofBuffer() {
        return this.classDumpSegment.hprofHeap.dumpBuffer;
    }

    int getInstanceFieldOffset() {
        int staticFieldOffset = this.getStaticFieldOffset();
        return staticFieldOffset + this.getStaticFiledSize(staticFieldOffset);
    }

    LoadClass getLoadClass() {
        return new LoadClass(this.getHprof().getLoadClassSegment(), this.loadClassOffset);
    }

    long getClassLoaderId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset);
    }

    List getReferences() {
        return this.getHprof().findReferencesFor(this.getJavaClassId());
    }

    int getStaticFieldOffset() {
        return this.classDumpSegment.constantPoolSizeOffset + this.getConstantPoolSize();
    }

    int getStaticFiledSize(int staticFieldOffset) {
        HprofByteBuffer buffer = this.getHprofBuffer();
        int idSize = buffer.getIDSize();
        long fieldOffset = this.fileOffset + (long)staticFieldOffset;
        int fields = buffer.getShort(fieldOffset);
        HprofHeap heap = this.getHprof();
        fieldOffset += 2L;
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(fieldOffset + (long)idSize);
            int size = heap.getValueSize(type);
            fieldOffset += (long)(idSize + 1 + size);
        }
        return (int)(fieldOffset - (long)staticFieldOffset - this.fileOffset);
    }

    void findStaticReferencesFor(long instanceId, List refs) {
        HprofByteBuffer buffer = this.getHprofBuffer();
        int idSize = buffer.getIDSize();
        long fieldOffset = this.fileOffset + (long)this.getStaticFieldOffset();
        int fields = buffer.getShort(fieldOffset);
        List staticFileds = null;
        HprofHeap heap = this.getHprof();
        fieldOffset += 2L;
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(fieldOffset + (long)idSize);
            int size = heap.getValueSize(type);
            if (type == 2 && instanceId == buffer.getID(fieldOffset + (long)idSize + 1L)) {
                if (staticFileds == null) {
                    staticFileds = this.getStaticFieldValues();
                }
                refs.add(staticFileds.get(i));
            }
            fieldOffset += (long)(idSize + 1 + size);
        }
        if (instanceId == this.getClassLoaderId()) {
            if (staticFileds == null) {
                staticFileds = this.getStaticFieldValues();
            }
            refs.add(staticFileds.get(fields));
        }
    }

    void registerInstance(long offset) {
        ++this.instances;
        if (this.firstInstanceOffset == 0L) {
            this.firstInstanceOffset = offset;
        }
    }

    void addSizeForInstance(Instance i) {
        this.retainedSizeByClass += i.getRetainedSize();
    }

    boolean canContainItself() {
        if (this.getInstancesCount() >= 2 && !CANNOT_CONTAIN_ITSELF.contains(this.getName())) {
            for (Field f : this.getAllInstanceFields()) {
                if (!f.getType().getName().equals("object")) continue;
                return true;
            }
        }
        return false;
    }

    private static Boolean isSubClass(JavaClass jcls, Map subclassesMap) {
        Boolean b;
        JavaClass superClass = jcls.getSuperClass();
        if (superClass == null) {
            b = Boolean.FALSE;
        } else {
            b = (Boolean)subclassesMap.get(superClass);
            if (b == null) {
                b = ClassDump.isSubClass(superClass, subclassesMap);
            }
        }
        subclassesMap.put(jcls, b);
        return b;
    }

    void writeToStream(DataOutputStream out) throws IOException {
        out.writeLong(this.fileOffset);
        out.writeInt(this.instances);
        out.writeLong(this.firstInstanceOffset);
        out.writeLong(this.loadClassOffset);
        out.writeLong(this.retainedSizeByClass);
    }

    ClassDump(ClassDumpSegment segment, long offset, DataInputStream dis) throws IOException {
        this(segment, offset);
        this.instances = dis.readInt();
        this.firstInstanceOffset = dis.readLong();
        this.loadClassOffset = dis.readLong();
        this.retainedSizeByClass = dis.readLong();
    }

    private class InstancesIterator
    implements Iterator {
        private long instancesCount;
        private long[] offset;
        TagBounds allInstanceDumpBounds;
        HprofHeap heap;
        long classId;

        InstancesIterator(long ic) {
            this.instancesCount = ic;
            this.allInstanceDumpBounds = ClassDump.this.getHprof().getAllInstanceDumpBounds();
            this.offset = new long[]{ClassDump.this.firstInstanceOffset};
            this.heap = ClassDump.this.getHprof();
            this.classId = ClassDump.this.getJavaClassId();
        }

        @Override
        public boolean hasNext() {
            return this.instancesCount > 0L && this.offset[0] < this.allInstanceDumpBounds.endOffset;
        }

        public Object next() {
            while (this.hasNext()) {
                Instance i = this.heap.getInstanceByOffset(this.offset, ClassDump.this, this.classId);
                if (i == null) continue;
                --this.instancesCount;
                return i;
            }
            throw new NoSuchElementException();
        }
    }
}

