/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebView;
import net.java.html.BrwsrCtx;
import org.netbeans.html.boot.fx.AbstractFXPresenter;

public final class InitializeWebView
extends AbstractFXPresenter
implements Runnable {
    private final WebView webView;
    private final Runnable myLoad;
    BrwsrCtx ctx;

    public InitializeWebView(WebView webView, Runnable onLoad) {
        this.webView = webView;
        this.myLoad = onLoad;
        webView.setUserData((Object)this);
    }

    @Override
    public void run() {
        this.ctx = BrwsrCtx.findDefault(InitializeWebView.class);
        if (this.myLoad != null) {
            this.myLoad.run();
        }
    }

    @Override
    void waitFinished() {
    }

    @Override
    WebView findView(final URL resource) {
        final Worker w = this.webView.getEngine().getLoadWorker();
        w.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){
            private String previous;

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State newState) {
                if (newState.equals((Object)Worker.State.SUCCEEDED) && this.checkValid()) {
                    InitializeWebView.this.onPageLoad();
                }
                if (newState.equals((Object)Worker.State.FAILED)) {
                    this.checkValid();
                    throw new IllegalStateException("Failed to load " + resource);
                }
            }

            private boolean checkValid() {
                String crnt = InitializeWebView.this.webView.getEngine().getLocation();
                if (this.previous != null && !this.previous.equals(crnt)) {
                    w.stateProperty().removeListener((ChangeListener)this);
                    return false;
                }
                this.previous = crnt;
                return true;
            }
        });
        return this.webView;
    }

    public final void runInContext(Runnable r) {
        this.ctx.execute(r);
    }
}

