/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.historystore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

class Entry {
    private final File storeFile;

    Entry(File storeFile) {
        this.storeFile = storeFile;
    }

    public OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException {
        return this.createStoreFileOutputStream(this.storeFile);
    }

    public InputStream getStoreFileInputStream() throws FileNotFoundException, IOException {
        ZipEntry entry;
        this.storeFile.setLastModified(System.currentTimeMillis());
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.storeFile)));
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals(this.storeFile.getName())) continue;
            return zis;
        }
        throw new FileNotFoundException();
    }

    private OutputStream createStoreFileOutputStream(File storeFile) throws FileNotFoundException, IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(storeFile)));
        ZipEntry entry = new ZipEntry(storeFile.getName());
        zos.putNextEntry(entry);
        return zos;
    }
}

