/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import java.io.IOException;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.java.Util;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JavaResourceHolder
extends ResourceHolder {
    private String selectedLocale;

    public JavaResourceHolder() {
        super(new Class[]{PropertiesDataObject.class});
    }

    public void setLocalization(String locale) {
        this.selectedLocale = locale;
    }

    public String getLocalization() {
        return this.selectedLocale;
    }

    private String getLocalizationFileName() {
        return this.selectedLocale != null && !this.selectedLocale.equals("") ? this.resource.getName() + this.selectedLocale : this.resource.getName();
    }

    @Override
    public String[] getAllKeys() {
        try {
            return ((PropertiesDataObject)this.resource).getBundleStructure().getKeys();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new String[0];
    }

    public String findFreeKey(String keySpec) {
        BundleStructure bundleStructure = ((PropertiesDataObject)this.resource).getBundleStructure();
        return bundleStructure != null ? bundleStructure.findFreeKey(keySpec) : null;
    }

    @Override
    public String getValueForKey(String key) {
        if (this.resource == null) {
            return null;
        }
        Element.ItemElem item = this.getItem(key);
        return item == null ? null : item.getValue();
    }

    @Override
    public String getCommentForKey(String key) {
        if (this.resource == null) {
            return null;
        }
        Element.ItemElem item = this.getItem(key);
        return item == null ? null : item.getComment();
    }

    private Element.ItemElem getItem(String key) {
        BundleStructure bundleStructure = ((PropertiesDataObject)this.resource).getBundleStructure();
        if (bundleStructure == null) {
            return null;
        }
        return bundleStructure.getItem(this.getLocalizationFileName(), key);
    }

    public Object getAllData(String key) {
        BundleStructure bundleStructure;
        if (this.resource instanceof PropertiesDataObject && (bundleStructure = ((PropertiesDataObject)this.resource).getBundleStructure()) != null) {
            return bundleStructure.getAllData(key);
        }
        return null;
    }

    public void setAllData(String key, Object data) {
        BundleStructure bundleStructure;
        if (this.resource instanceof PropertiesDataObject && (bundleStructure = ((PropertiesDataObject)this.resource).getBundleStructure()) != null) {
            bundleStructure.setAllData(key, (String[])data);
        }
    }

    @Override
    public void addProperty(Object key, Object value, String comment, boolean forceNewValue) {
        if (this.resource == null || key == null) {
            return;
        }
        String keyValue = key.toString();
        String valueValue = value == null ? "" : value.toString();
        String commentValue = comment;
        BundleStructure bundleStructure = ((PropertiesDataObject)this.resource).getBundleStructure();
        if (bundleStructure != null) {
            bundleStructure.addItem(this.getLocalizationFileName(), keyValue, valueValue, commentValue, forceNewValue);
        }
    }

    public void removeProperty(Object key) {
        BundleStructure bundleStructure;
        if (this.resource != null && (bundleStructure = ((PropertiesDataObject)this.resource).getBundleStructure()) != null) {
            bundleStructure.removeItem(key.toString());
        }
    }

    @Override
    protected DataObject createTemplate(Class clazz) throws IOException {
        return JavaResourceHolder.getTemplate();
    }

    public static DataObject getTemplate() throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)"Templates/Other/properties.properties");
        if (fileObject == null) {
            throw new IOException(Util.getString("EXC_TemplateNotFound"));
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException e) {
            throw new IOException(Util.getString("EXC_TemplateNotFound"));
        }
    }
}

