/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ThreadInfo;

public class ProfilerRuntimeObjAlloc
extends ProfilerRuntimeMemory {
    protected static boolean objAllocProfilingDisabled = true;

    public static void enableProfiling(boolean v) {
        if (!v) {
            objAllocProfilingDisabled = true;
        }
        if (v) {
            ProfilerRuntimeObjAlloc.createNewDataStructures();
            ProfilerRuntimeMemory.enableProfiling(v);
        } else {
            ProfilerRuntimeMemory.enableProfiling(v);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerRuntimeObjAlloc.clearDataStructures();
        }
        if (v) {
            objAllocProfilingDisabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceObjAlloc(Object object, char classId) {
        int classInt;
        if (objAllocProfilingDisabled) {
            return;
        }
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread() || classId == '\u0000' && ProfilerRuntimeObjAlloc.isInternalClass(object.getClass())) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!ti.isInitialized()) {
            ti.initialize();
            if (lockContentionMonitoringEnabled) {
                ProfilerRuntimeObjAlloc.writeThreadCreationEvent(ti);
            }
        }
        ++ti.inProfilingRuntimeMethod;
        if (classId == '\u0000') {
            classInt = ProfilerRuntimeObjAlloc.getClassId(object.getClass());
            if (classInt == -1) {
                --ti.inProfilingRuntimeMethod;
                return;
            }
        } else {
            classInt = classId & 0xFF;
            classInt |= classId & 0xFF00;
        }
        int[] nArray = allocatedInstancesCount;
        synchronized (allocatedInstancesCount) {
            int n = classInt;
            allocatedInstancesCount[n] = allocatedInstancesCount[n] + 1;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (allocatedInstThreshold[classInt] <= 0) {
                long objSize = ProfilerRuntimeObjAlloc.getCachedObjectSize(classInt, object);
                ProfilerRuntimeObjAlloc.getAndSendCurrentStackTrace(classInt, objSize);
                ProfilerRuntimeObjAlloc.allocatedInstThreshold[classInt] = ProfilerRuntimeObjAlloc.nextRandomizedInterval();
            }
            int n2 = classInt;
            allocatedInstThreshold[n2] = (short)(allocatedInstThreshold[n2] - 1);
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeMemory.clearDataStructures();
    }

    protected static void createNewDataStructures() {
        ProfilerRuntimeMemory.createNewDataStructures();
    }
}

