/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class GetClassFileBytesCommand
extends Command {
    private String[] classes;
    private int[] classLoaderIds;

    public GetClassFileBytesCommand(String[] classes, int[] classLoaderIds) {
        this();
        this.classes = classes;
        this.classLoaderIds = classLoaderIds;
    }

    GetClassFileBytesCommand() {
        super(47);
    }

    public int[] getClassLoaderIds() {
        return this.classLoaderIds;
    }

    public String[] getClasses() {
        return this.classes;
    }

    void readObject(ObjectInputStream in) throws IOException {
        int nClasses = in.readInt();
        if (nClasses == 0) {
            return;
        }
        this.classes = new String[nClasses];
        this.classLoaderIds = new int[nClasses];
        for (int i = 0; i < nClasses; ++i) {
            this.classes[i] = in.readUTF().replace('/', '.');
            this.classLoaderIds[i] = in.readInt();
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        if (this.classes == null) {
            out.writeInt(0);
            return;
        }
        int nClasses = this.classes.length;
        out.writeInt(nClasses);
        for (int i = 0; i < nClasses; ++i) {
            out.writeUTF(this.classes[i]);
            out.writeInt(this.classLoaderIds[i]);
        }
        this.classes = null;
        this.classLoaderIds = null;
    }

    public String toString() {
        return super.toString() + " " + this.classes.length + " classes(): " + Arrays.toString(this.classes);
    }
}

