/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.commons.TextUtils;

public final class LogUtils {
    private static final Logger METRICS_LOG = Logger.getLogger("org.netbeans.ui.metrics.bugtracking");
    public static final String USG_BUGTRACKING_AUTOMATIC_REFRESH = "USG_BUGTRACKING_AUTOMATIC_REFRESH";
    public static final String USG_BUGTRACKING_QUERY = "USG_BUGTRACKING_QUERY";
    private static final String USG_ISSUE_TRACKING = "USG_ISSUE_TRACKING";
    private static final String USG_ISSUE_TRACKING_REPOSITORY = "USG_ISSUE_TRACKING_REPOSITORY";
    private static final Set<String> loggedParams = new HashSet<String>(1);

    public static void logQueryEvent(String connector, String name, int count, boolean isFromTeamServer, boolean isAutoRefresh) {
        name = LogUtils.obfuscateQueryName(name);
        LogUtils.logBugtrackingEvents(USG_BUGTRACKING_QUERY, new Object[]{connector, name, count, isFromTeamServer, isAutoRefresh});
    }

    public static void logAutoRefreshEvent(String connector, String queryName, boolean isFromTeamServer, boolean on) {
        queryName = LogUtils.obfuscateQueryName(queryName);
        LogUtils.logBugtrackingEvents(USG_BUGTRACKING_AUTOMATIC_REFRESH, new Object[]{connector, queryName, isFromTeamServer, on});
    }

    public static synchronized void logBugtrackingUsage(String connectorID, String operation) {
        if (connectorID == null || operation == null) {
            return;
        }
        String bugtrackingType = LogUtils.getBugtrackingType(connectorID);
        if (!LogUtils.checkMetricsKey(LogUtils.getParamString(USG_ISSUE_TRACKING, bugtrackingType, operation))) {
            LogRecord rec = new LogRecord(Level.INFO, USG_ISSUE_TRACKING);
            rec.setParameters(new Object[]{bugtrackingType, operation});
            rec.setLoggerName(METRICS_LOG.getName());
            METRICS_LOG.log(rec);
        }
    }

    public static void logRepositoryUsage(String connectorID, String repositoryUrl) {
        String knownRepositoryFor;
        if (connectorID == null || repositoryUrl == null) {
            return;
        }
        String bugtrackingType = LogUtils.getBugtrackingType(connectorID);
        if (!LogUtils.checkMetricsKey(LogUtils.getParamString(USG_ISSUE_TRACKING_REPOSITORY, bugtrackingType, knownRepositoryFor = LogUtils.getKnownRepositoryFor(repositoryUrl)))) {
            LogRecord rec = new LogRecord(Level.INFO, USG_ISSUE_TRACKING_REPOSITORY);
            rec.setParameters(new Object[]{LogUtils.getBugtrackingType(connectorID), knownRepositoryFor});
            rec.setLoggerName(METRICS_LOG.getName());
            METRICS_LOG.log(rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkMetricsKey(String key) {
        Set<String> set = loggedParams;
        synchronized (set) {
            if (loggedParams.contains(key)) {
                return true;
            }
            loggedParams.add(key);
        }
        return false;
    }

    public static String getKnownRepositoryFor(String repositoryUrl) {
        if ((repositoryUrl = repositoryUrl.toLowerCase()).contains("github.com")) {
            return "GITHUB";
        }
        if (repositoryUrl.contains("gitorious.org")) {
            return "GITORIOUS";
        }
        if (repositoryUrl.contains("bitbucket.org")) {
            return "BITBUCKET";
        }
        if (repositoryUrl.contains("sourceforge.net")) {
            return "SOURCEFORGE";
        }
        if (repositoryUrl.contains("googlecode.com") || repositoryUrl.contains("code.google.com") || repositoryUrl.contains("googlesource.com")) {
            return "GOOGLECODE";
        }
        if (repositoryUrl.contains("kenai.com")) {
            return "KENAI";
        }
        if (repositoryUrl.contains("java.net")) {
            return "JAVANET";
        }
        if (repositoryUrl.contains("netbeans.org")) {
            return "NETBEANS";
        }
        if (repositoryUrl.contains("codeplex.com")) {
            return "CODEPLEX";
        }
        if (repositoryUrl.contains(".eclipse.org")) {
            return "ECLIPSE";
        }
        return "OTHER";
    }

    private static String getParamString(Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        if (parameters.length == 1) {
            return parameters[0].toString();
        }
        StringBuilder buf = new StringBuilder();
        for (Object p : parameters) {
            buf.append(p.toString());
        }
        return buf.toString();
    }

    public static String getBugtrackingType(String id) {
        if (id.contains("bugzilla")) {
            return "Bugzilla";
        }
        if (id.contains("jira")) {
            return "Jira";
        }
        if (id.contains("odcs") || id.contains("CloudDev")) {
            return "ODCS";
        }
        return id;
    }

    public static String getPasswordLog(char[] psswd) {
        if (psswd == null) {
            return "";
        }
        if ("true".equals(System.getProperty("org.netbeans.modules.bugtracking.logPasswords", "false")) || "true".equals(System.getProperty("org.netbeans.modules.team.logPasswords", "false"))) {
            return new String(psswd);
        }
        return "******";
    }

    private static void logBugtrackingEvents(String key, Object[] parameters) {
        LogRecord rec = new LogRecord(Level.INFO, key);
        rec.setParameters(parameters);
        rec.setLoggerName(METRICS_LOG.getName());
        METRICS_LOG.log(rec);
    }

    private static String obfuscateQueryName(String name) {
        name = name == null ? "Find Issues" : TextUtils.getMD5(name);
        return name;
    }
}

