/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;

public abstract class AbstractPathArchive
implements Archive {
    private static final Logger LOG = Logger.getLogger(AbstractPathArchive.class.getName());
    protected final Path root;
    protected final String rootURI;
    protected final char separator;
    private volatile Boolean multiRelease;

    protected AbstractPathArchive(@NonNull Path root, @NullAllowed URI rootURI) {
        assert (root != null);
        this.root = root;
        this.rootURI = rootURI == null ? null : rootURI.toString();
        String separator = root.getFileSystem().getSeparator();
        if (separator.length() != 1) {
            throw new IllegalArgumentException("Multi character separators are unsupported");
        }
        this.separator = separator.charAt(0);
    }

    @Override
    public void clear() {
        this.multiRelease = null;
    }

    @Override
    public boolean isMultiRelease() {
        Boolean res = this.multiRelease;
        if (res == null) {
            block16: {
                res = Boolean.FALSE;
                if ("jar".equals(this.root.getFileSystem().provider().getScheme())) {
                    try {
                        JavaFileObject jfo = this.getFile("META-INF/MANIFEST.MF");
                        if (jfo == null) break block16;
                        try (BufferedInputStream in = new BufferedInputStream(jfo.openInputStream());){
                            res = FileObjects.isMultiVersionArchive(in);
                        }
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.WARNING, "Cannot read: {0} manifest", this.rootURI.toString());
                    }
                }
            }
            this.multiRelease = res;
        }
        return res;
    }
}

