/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.awt.Mnemonics;

public class TriggerCustomizer
extends ValidityAwarePanel
implements ActionListener {
    private static int defaultTextComponentHeight = -1;
    private final SpinnerModel percentsModel = new SpinnerNumberModel(1, 1, 99, 1);
    private final SpinnerModel unitsModel = new SpinnerNumberModel(1, 1, 9999, 1);
    private JComboBox triggerWhenCombo;
    private JLabel triggerExceedsLabel;
    private JLabel triggerGenerationsLabel;
    private JLabel triggerWhenLabel;
    private JRadioButton triggerAlwaysRadio;
    private JRadioButton triggerOnceRadio;
    private JSpinner triggerValueSpinner;

    public TriggerCustomizer() {
        this.initComponents();
    }

    public int getPreferredCaptionAreaWidth() {
        return -1;
    }

    public void setTriggerCondition(TriggeredGlobalProfilingPoint.TriggerCondition condition) {
        switch (condition.getMetric()) {
            case 1: {
                this.triggerWhenCombo.setSelectedItem(Bundle.TriggerCustomizer_HeapUsgRelKey());
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
            case 2: {
                this.triggerWhenCombo.setSelectedItem(Bundle.TriggerCustomizer_HeapSizeAbsKey());
                this.triggerValueSpinner.setValue((int)(condition.getValue() / 0x100000L));
                break;
            }
            case 3: {
                this.triggerWhenCombo.setSelectedItem(Bundle.TriggerCustomizer_SurvgenCountKey());
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
            case 4: {
                this.triggerWhenCombo.setSelectedItem(Bundle.TriggerCustomizer_LdClassCountKey());
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
            case 6: {
                this.triggerWhenCombo.setSelectedItem(Bundle.TriggerCustomizer_CpuTimeKey());
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
            case 7: {
                this.triggerWhenCombo.setSelectedItem(Bundle.TriggerCustomizer_GcTimeKey());
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
            case 5: {
                this.triggerWhenCombo.setSelectedItem(Bundle.TriggerCustomizer_ThreadsCountKey());
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
        }
        this.triggerOnceRadio.setSelected(condition.isOnetime());
        this.triggerAlwaysRadio.setSelected(!condition.isOnetime());
    }

    public TriggeredGlobalProfilingPoint.TriggerCondition getTriggerCondition() {
        TriggeredGlobalProfilingPoint.TriggerCondition condition = new TriggeredGlobalProfilingPoint.TriggerCondition();
        Object key = this.triggerWhenCombo.getSelectedItem();
        if (Bundle.TriggerCustomizer_HeapUsgRelKey().equals(key)) {
            condition.setMetric(1);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (Bundle.TriggerCustomizer_HeapSizeAbsKey().equals(key)) {
            condition.setMetric(2);
            condition.setValue((long)((Integer)this.triggerValueSpinner.getValue()).intValue() * 0x100000L);
        } else if (Bundle.TriggerCustomizer_SurvgenCountKey().equals(key)) {
            condition.setMetric(3);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (Bundle.TriggerCustomizer_LdClassCountKey().equals(key)) {
            condition.setMetric(4);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (Bundle.TriggerCustomizer_CpuTimeKey().equals(key)) {
            condition.setMetric(6);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (Bundle.TriggerCustomizer_GcTimeKey().equals(key)) {
            condition.setMetric(7);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (Bundle.TriggerCustomizer_ThreadsCountKey().equals(key)) {
            condition.setMetric(5);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        }
        condition.setOnetime(this.triggerOnceRadio.isSelected());
        return condition;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.triggerWhenCombo) {
            Object key = this.triggerWhenCombo.getSelectedItem();
            if (Bundle.TriggerCustomizer_HeapUsgRelKey().equals(key)) {
                this.triggerGenerationsLabel.setText(Bundle.TriggerCustomizer_HeapUsgRelUnit());
                this.triggerValueSpinner.setModel(this.percentsModel);
            } else if (Bundle.TriggerCustomizer_HeapSizeAbsKey().equals(key)) {
                this.triggerGenerationsLabel.setText(Bundle.TriggerCustomizer_HeapSizeAbsUnit());
                this.triggerValueSpinner.setModel(this.unitsModel);
            } else if (Bundle.TriggerCustomizer_SurvgenCountKey().equals(key)) {
                this.triggerGenerationsLabel.setText(Bundle.TriggerCustomizer_SurvgenCountUnit());
                this.triggerValueSpinner.setModel(this.unitsModel);
            } else if (Bundle.TriggerCustomizer_LdClassCountKey().equals(key)) {
                this.triggerGenerationsLabel.setText(Bundle.TriggerCustomizer_LdClassCountUnit());
                this.triggerValueSpinner.setModel(this.unitsModel);
            } else if (Bundle.TriggerCustomizer_CpuTimeKey().equals(key)) {
                this.triggerGenerationsLabel.setText(Bundle.TriggerCustomizer_CpuTimeUnit());
                this.triggerValueSpinner.setModel(this.percentsModel);
            } else if (Bundle.TriggerCustomizer_GcTimeKey().equals(key)) {
                this.triggerGenerationsLabel.setText(Bundle.TriggerCustomizer_GcTimeUnit());
                this.triggerValueSpinner.setModel(this.percentsModel);
            } else if (Bundle.TriggerCustomizer_ThreadsCountKey().equals(key)) {
                this.triggerGenerationsLabel.setText(Bundle.TriggerCustomizer_ThreadsCountUnit());
                this.triggerValueSpinner.setModel(this.unitsModel);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TriggerCustomizer main = new TriggerCustomizer();
        JFrame frame = new JFrame("Customize Profiling Point");
        frame.getContentPane().add(main);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel triggerSettingsContainer = new JPanel(new GridBagLayout());
        this.triggerWhenLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.triggerWhenLabel, (String)Bundle.TriggerCustomizer_TakeWhenLabelText());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerWhenLabel, constraints);
        this.triggerWhenCombo = new JComboBox(new Object[]{Bundle.TriggerCustomizer_CpuTimeKey(), Bundle.TriggerCustomizer_GcTimeKey(), Bundle.TriggerCustomizer_HeapUsgRelKey(), Bundle.TriggerCustomizer_HeapSizeAbsKey(), Bundle.TriggerCustomizer_SurvgenCountKey(), Bundle.TriggerCustomizer_ThreadsCountKey(), Bundle.TriggerCustomizer_LdClassCountKey()}){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(Math.min(super.getPreferredSize().width, 200), super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.triggerWhenLabel.setLabelFor(this.triggerWhenCombo);
        this.triggerWhenCombo.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerWhenCombo, constraints);
        this.triggerExceedsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.triggerExceedsLabel, (String)Bundle.TriggerCustomizer_ExceedsLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerExceedsLabel, constraints);
        this.triggerValueSpinner = new JExtendedSpinner(this.percentsModel){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), 2.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.triggerExceedsLabel.setLabelFor(this.triggerValueSpinner);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerValueSpinner, constraints);
        this.triggerGenerationsLabel = new JLabel(Bundle.TriggerCustomizer_HeapUsgRelKey());
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerGenerationsLabel, constraints);
        JPanel triggerFillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 5;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerSettingsContainer.add((Component)triggerFillerPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)triggerSettingsContainer, constraints);
        ButtonGroup triggerRadiosGroup = new ButtonGroup();
        JPanel triggerRadiosContainer = new JPanel(new GridBagLayout());
        this.triggerOnceRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.triggerOnceRadio, (String)Bundle.TriggerCustomizer_TakeOnceRadioText());
        triggerRadiosGroup.add(this.triggerOnceRadio);
        this.triggerOnceRadio.setSelected(true);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerRadiosContainer.add((Component)this.triggerOnceRadio, constraints);
        this.triggerAlwaysRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.triggerAlwaysRadio, (String)Bundle.TriggerCustomizer_TakeAlwaysRadioText());
        triggerRadiosGroup.add(this.triggerAlwaysRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerRadiosContainer.add((Component)this.triggerAlwaysRadio, constraints);
        JPanel takeRadiosSpacer = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerRadiosContainer.add((Component)takeRadiosSpacer, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)triggerRadiosContainer, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
    }

    private void updateValidity() {
        boolean isValid = true;
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }
}

