/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.netbeans.spi.editor.AbstractEditorAction;

public class AddCaretSelectNextAction
extends AbstractEditorAction {
    private static final Logger LOGGER = Logger.getLogger(AddCaretSelectNextAction.class.getName());

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            Caret caret = target.getCaret();
            if (Utilities.isSelectionShowing((Caret)caret)) {
                EditorFindSupport findSupport = EditorFindSupport.getInstance();
                HashMap<String, Object> props = new HashMap<String, Object>(findSupport.createDefaultFindProperties());
                String searchWord = target.getSelectedText();
                int n = searchWord.indexOf(10);
                if (n >= 0) {
                    searchWord = searchWord.substring(0, n);
                }
                props.put("find-what", searchWord);
                props.put("add-multi-caret", Boolean.TRUE);
                EditorUI eui = Utilities.getEditorUI((JTextComponent)target);
                if (eui.getComponent().getClientProperty("AsTextField") == null) {
                    findSupport.setFocusedTextComponent(eui.getComponent());
                }
                findSupport.putFindProperties(props);
                findSupport.find(null, false);
                props.put("add-multi-caret", Boolean.FALSE);
                findSupport.putFindProperties(props);
            } else {
                try {
                    int[] identifierBlock = Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)target.getDocument()), (int)caret.getDot());
                    if (identifierBlock != null) {
                        caret.setDot(identifierBlock[0]);
                        caret.moveDot(identifierBlock[1]);
                    }
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
            }
        }
    }
}

