/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.spi;

import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.spi.CssPreprocessorImplementation;
import org.openide.util.Parameters;

public interface CssPreprocessorImplementationListener
extends EventListener {
    public void optionsChanged(@NonNull CssPreprocessorImplementation var1);

    public void customizerChanged(@NonNull Project var1, @NonNull CssPreprocessorImplementation var2);

    public void processingErrorOccured(@NonNull Project var1, @NonNull CssPreprocessorImplementation var2, @NonNull String var3);

    public static final class Support {
        private final List<CssPreprocessorImplementationListener> listeners = new CopyOnWriteArrayList<CssPreprocessorImplementationListener>();

        public void addCssPreprocessorListener(@NullAllowed CssPreprocessorImplementationListener listener) {
            if (listener == null) {
                return;
            }
            this.listeners.add(listener);
        }

        public void removeCssPreprocessorListener(@NullAllowed CssPreprocessorImplementationListener listener) {
            if (listener == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        public void fireOptionsChanged(@NonNull CssPreprocessorImplementation cssPreprocessor) {
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            for (CssPreprocessorImplementationListener listener : this.listeners) {
                listener.optionsChanged(cssPreprocessor);
            }
        }

        public void fireCustomizerChanged(@NonNull Project project, @NonNull CssPreprocessorImplementation cssPreprocessor) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            for (CssPreprocessorImplementationListener listener : this.listeners) {
                listener.customizerChanged(project, cssPreprocessor);
            }
        }

        public void fireProcessingErrorOccured(@NonNull Project project, @NonNull CssPreprocessorImplementation cssPreprocessor, @NonNull String error) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            Parameters.notNull((CharSequence)"error", (Object)error);
            for (CssPreprocessorImplementationListener listener : this.listeners) {
                listener.processingErrorOccured(project, cssPreprocessor, error);
            }
        }

        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }
    }
}

