/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CollectionValuedPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionMemberExpressionStateObject
extends AbstractStateObject {
    private CollectionValuedPathExpressionStateObject collectionValuedPath;
    private StateObject entityStateObject;
    private boolean not;
    private boolean of;
    public static final String ENTITY_STATE_OBJECT_PROPERTY = "entityStateObject";
    public static final String NOT_PROPERTY = "not";
    public static final String OF_PROPERTY = "of";

    public CollectionMemberExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public CollectionMemberExpressionStateObject(StateObject parent, StateObject entityStateObject, boolean not, boolean of, String collectionValuedPath) {
        super(parent);
        this.not = not;
        this.of = of;
        this.entityStateObject = this.parent(entityStateObject);
        this.collectionValuedPath.setPath(collectionValuedPath);
    }

    public CollectionMemberExpressionStateObject(StateObject parent, StateObject entityStateObject, String collectionValuedPath) {
        this(parent, entityStateObject, false, false, collectionValuedPath);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.entityStateObject != null) {
            children.add(this.entityStateObject);
        }
        if (this.collectionValuedPath != null) {
            children.add(this.collectionValuedPath);
        }
    }

    public CollectionMemberExpressionStateObject addNot() {
        if (!this.not) {
            this.setNot(true);
        }
        return this;
    }

    public CollectionMemberExpressionStateObject addOf() {
        if (!this.of) {
            this.setOf(true);
        }
        return this;
    }

    public CollectionValuedPathExpressionStateObject getCollectionValuedPath() {
        return this.collectionValuedPath;
    }

    public StateObject getEntityStateObject() {
        return this.entityStateObject;
    }

    @Override
    public CollectionMemberExpression getExpression() {
        return (CollectionMemberExpression)super.getExpression();
    }

    public boolean hasEntityStateObject() {
        return this.entityStateObject != null;
    }

    public boolean hasNot() {
        return this.not;
    }

    public boolean hasOf() {
        return this.of;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.collectionValuedPath = new CollectionValuedPathExpressionStateObject(this);
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            CollectionMemberExpressionStateObject collection = (CollectionMemberExpressionStateObject)stateObject;
            return this.not == collection.not && this.of == collection.of && this.collectionValuedPath.isEquivalent(collection.collectionValuedPath) && this.areEquivalent(this.entityStateObject, collection.entityStateObject);
        }
        return false;
    }

    public void removeNot() {
        if (this.not) {
            this.setNot(false);
        }
    }

    public void removeOf() {
        if (this.of) {
            this.setOf(false);
        }
    }

    public void setEntityStateObject(StateObject entityStateObject) {
        StateObject oldEntityStateObject = entityStateObject;
        this.entityStateObject = this.parent(entityStateObject);
        this.firePropertyChanged(ENTITY_STATE_OBJECT_PROPERTY, oldEntityStateObject, entityStateObject);
    }

    public void setExpression(CollectionMemberExpression expression) {
        super.setExpression(expression);
    }

    public void setNot(boolean not) {
        boolean oldNot = this.not;
        this.not = not;
        this.firePropertyChanged(NOT_PROPERTY, oldNot, not);
    }

    public void setOf(boolean of) {
        boolean oldOf = this.of;
        this.of = of;
        this.firePropertyChanged(OF_PROPERTY, oldOf, of);
    }

    public void toggleNot() {
        this.setNot(!this.not);
    }

    public void toggleOf() {
        this.setOf(!this.of);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.entityStateObject != null) {
            this.entityStateObject.toString(writer);
            writer.append(' ');
        }
        if (this.not && this.of) {
            writer.append("NOT MEMBER OF");
        } else if (this.not) {
            writer.append("NOT MEMBER");
        } else if (this.of) {
            writer.append("MEMBER OF");
        } else {
            writer.append("MEMBER");
        }
        writer.append(' ');
        this.collectionValuedPath.toString(writer);
    }
}

