/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractStandardUpgradeStrategy;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;
import org.xnio.StreamConnection;

public class UndertowRequestUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    private final Handshake[] handshakes = new Handshake[]{new Hybi13Handshake(), new Hybi08Handshake(), new Hybi07Handshake()};
    private final String[] supportedVersions = this.initSupportedVersions(this.handshakes);

    private String[] initSupportedVersions(Handshake[] handshakes) {
        String[] versions = new String[handshakes.length];
        for (int i = 0; i < versions.length; ++i) {
            versions[i] = handshakes[i].getVersion().toHttpHeaderValue();
        }
        return versions;
    }

    @Override
    public String[] getSupportedVersions() {
        return this.supportedVersions;
    }

    @Override
    protected void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint) throws HandshakeFailureException {
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        HttpServletResponse servletResponse = this.getHttpServletResponse(response);
        final ServletWebSocketHttpExchange exchange = new ServletWebSocketHttpExchange(servletRequest, servletResponse);
        exchange.putAttachment(HandshakeUtil.PATH_PARAMS, Collections.emptyMap());
        ServerWebSocketContainer wsContainer = (ServerWebSocketContainer)this.getContainer(servletRequest);
        final EndpointSessionHandler endpointSessionHandler = new EndpointSessionHandler(wsContainer);
        final Handshake handshake = this.getHandshakeToUse(exchange);
        final ConfiguredServerEndpoint configuredServerEndpoint = this.createConfiguredServerEndpoint(selectedProtocol, selectedExtensions, endpoint, servletRequest);
        exchange.upgradeChannel(new HttpUpgradeListener(){

            public void handleUpgrade(StreamConnection connection, HttpServerExchange serverExchange) {
                WebSocketChannel channel = handshake.createChannel((WebSocketHttpExchange)exchange, connection, exchange.getBufferPool());
                HandshakeUtil.setConfig((WebSocketChannel)channel, (ConfiguredServerEndpoint)configuredServerEndpoint);
                endpointSessionHandler.onConnect((WebSocketHttpExchange)exchange, channel);
            }
        });
        handshake.handshake((WebSocketHttpExchange)exchange);
    }

    private Handshake getHandshakeToUse(ServletWebSocketHttpExchange exchange) {
        for (Handshake handshake : this.handshakes) {
            if (!handshake.matches((WebSocketHttpExchange)exchange)) continue;
            return handshake;
        }
        throw new HandshakeFailureException("No matching Undertow Handshake found: " + exchange.getRequestHeaders());
    }

    private ConfiguredServerEndpoint createConfiguredServerEndpoint(String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint, HttpServletRequest servletRequest) {
        String path = servletRequest.getRequestURI();
        ServerEndpointRegistration endpointRegistration = new ServerEndpointRegistration(path, endpoint);
        endpointRegistration.setSubprotocols(Arrays.asList(selectedProtocol));
        endpointRegistration.setExtensions(selectedExtensions);
        return new ConfiguredServerEndpoint((ServerEndpointConfig)endpointRegistration, (InstanceFactory)new EndpointInstanceFactory(endpoint), null, new EncodingFactory(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap()));
    }

    private static class EndpointInstanceFactory
    implements InstanceFactory<Endpoint> {
        private final Endpoint endpoint;

        public EndpointInstanceFactory(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public InstanceHandle<Endpoint> createInstance() throws InstantiationException {
            return new InstanceHandle<Endpoint>(){

                public Endpoint getInstance() {
                    return EndpointInstanceFactory.this.endpoint;
                }

                public void release() {
                }
            };
        }
    }
}

