/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.netbeans.modules.javafx2.editor.completion.impl.AbstractCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.openide.util.ImageUtilities;

final class ValueItem
extends AbstractCompletionItem {
    private String iconResource;
    private ImageIcon icon;
    private boolean attribute;
    private String valPrefix;
    private static final Map<String, ImageIcon> cache = new HashMap<String, ImageIcon>();

    public ValueItem(CompletionContext ctx, String text, String valPrefix, String icon) {
        super(ctx, text);
        this.iconResource = icon;
        this.attribute = ctx.isAttribute();
        this.valPrefix = valPrefix;
    }

    public ValueItem(CompletionContext ctx, String text, String icon) {
        this(ctx, text, "", icon);
    }

    public void setAttribute(boolean attribute) {
        this.attribute = attribute;
    }

    @Override
    protected String getSubstituteText() {
        if (this.attribute) {
            return "\"" + this.valPrefix + super.getSubstituteText() + "\"";
        }
        return this.valPrefix + super.getSubstituteText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ImageIcon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Map<String, ImageIcon> map = cache;
        synchronized (map) {
            this.icon = cache.get(this.iconResource);
        }
        if (this.icon == null) {
            this.icon = ImageUtilities.loadImageIcon((String)this.iconResource, (boolean)false);
        }
        map = cache;
        synchronized (map) {
            cache.put(this.iconResource, this.icon);
        }
        return this.icon;
    }

    public String toString() {
        return "value[" + this.getSubstituteText() + "]";
    }
}

