/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.json.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SimpleList<E>
implements List<E> {
    private Object[] arr;
    private int size;

    public SimpleList() {
    }

    private SimpleList(Object[] data) {
        this.arr = (Object[])data.clone();
        this.size = data.length;
    }

    public static <T> List<T> asList(T ... arr) {
        return new SimpleList(arr);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.containsImpl(o, 0, this.size);
    }

    final boolean containsImpl(Object o, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (!SimpleList.equals(o, this.arr[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new LI(0, this.size);
    }

    @Override
    public Object[] toArray() {
        return this.toArrayImpl(0, this.size);
    }

    final Object[] toArrayImpl(int from, int to) {
        Object[] ret = new Object[to - from];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.arr[i + from];
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArrayImpl(a, 0, this.size);
    }

    final <T> T[] toArrayImpl(T[] a, int from, int to) {
        if (a.length < to - from) {
            a = SimpleList.newArr(a, to - from);
        }
        for (int i = 0; i < this.size; ++i) {
            a[i] = this.arr[i + from];
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        return this.addImpl(e);
    }

    private boolean addImpl(E e) {
        this.ensureAccess(this.size + 1);
        this.arr[this.size++] = e;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeImpl(o, 0, this.size);
    }

    private boolean removeImpl(Object o, int from, int to) {
        boolean found = false;
        for (int i = from; i < to; ++i) {
            if (found) {
                this.arr[i - 1] = this.arr[i];
                continue;
            }
            if (!SimpleList.equals(o, this.arr[i])) continue;
            found = true;
        }
        if (found) {
            this.arr[--this.size] = null;
        }
        return found;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.ensureAccess(this.size + c.size());
        for (E o : c) {
            this.addImpl(o);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addImpl(index, c);
    }

    private boolean addImpl(int index, Collection<? extends E> c) {
        int toAdd = c.size();
        if (toAdd == 0) {
            return false;
        }
        int nowSize = this.size;
        this.ensureAccess(nowSize + toAdd);
        for (int i = nowSize - 1; i >= index; --i) {
            this.arr[i + toAdd] = this.arr[i];
        }
        for (E o : c) {
            this.arr[index++] = o;
        }
        this.size += toAdd;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int prev = this.size;
        for (Object o : c) {
            this.remove(o);
        }
        return prev != this.size;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.retainImpl(this, c);
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.sortImpl(c, 0, this.size);
    }

    final void sortImpl(Comparator<? super E> c, int from, int to) {
        for (int i = from; i < to; ++i) {
            Object min = this.arr[i];
            int minIndex = i;
            for (int j = i + 1; j < to; ++j) {
                int compare = c == null ? ((Comparable)min).compareTo(this.arr[j]) : c.compare(min, this.arr[j]);
                if (compare <= 0) continue;
                min = this.arr[j];
                minIndex = j;
            }
            if (i == minIndex) continue;
            this.arr[minIndex] = this.arr[i];
            this.arr[i] = min;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    void clearImpl(int from, int to) {
        int i = 0;
        while (i + from < this.size) {
            this.arr[from + i] = this.arr[to + i];
            ++i;
        }
        this.size += from;
        this.size -= to;
    }

    @Override
    public E get(int index) {
        this.checkAccess(index);
        return (E)this.arr[index];
    }

    private void checkAccess(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private void ensureAccess(int reqSize) {
        int newSize;
        if (reqSize < this.size) {
            return;
        }
        int n = newSize = this.arr == null ? 0 : this.arr.length;
        if (newSize < 4) {
            newSize = 4;
        }
        while (newSize < reqSize) {
            newSize *= 2;
        }
        Object[] newArr = new Object[newSize];
        for (int i = 0; i < this.size; ++i) {
            newArr[i] = this.arr[i];
        }
        this.arr = newArr;
    }

    @Override
    public E set(int index, E element) {
        this.checkAccess(index);
        Object prev = this.arr[index];
        this.arr[index] = element;
        return (E)prev;
    }

    @Override
    public void add(int index, E element) {
        this.addImpl(index, SimpleList.asList(element));
    }

    @Override
    public E remove(int index) {
        this.checkAccess(index);
        Object prev = this.arr[index];
        for (int i = index + 1; i < this.size; ++i) {
            this.arr[i - 1] = this.arr[i];
        }
        this.arr[--this.size] = null;
        return (E)prev;
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOfImpl(o, 0, this.size);
    }

    final int indexOfImpl(Object o, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (!SimpleList.equals(o, this.arr[i])) continue;
            return i - from;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.lastIndexOfImpl(o, 0, this.size);
    }

    public int lastIndexOfImpl(Object o, int from, int to) {
        for (int i = to - 1; i >= from; --i) {
            if (!SimpleList.equals(o, this.arr[i])) continue;
            return i - from;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new LI(0, this.size);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new LI(index, 0, this.size);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new Sub(fromIndex, toIndex);
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private static <T> T[] newArr(T[] a, int size) {
        return (Object[])Array.newInstance(a.getClass().getComponentType(), size);
    }

    @Override
    public boolean equals(Object obj) {
        return SimpleList.equalsList(this, obj);
    }

    @Override
    public int hashCode() {
        return SimpleList.hashList(this);
    }

    public String toString() {
        return SimpleList.toStringList(this);
    }

    boolean retainImpl(Collection<?> thiz, Collection<?> c) {
        boolean changed = false;
        Iterator<?> it = thiz.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (c.contains(obj)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    static boolean equalsList(List<?> thiz, Object obj) {
        if (obj == thiz) {
            return true;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (thiz.size() != list.size()) {
                return false;
            }
            for (int i = 0; i < thiz.size(); ++i) {
                if (SimpleList.equals(thiz.get(i), list.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static int hashList(List<?> thiz) {
        int hashCode = 1;
        for (Object e : thiz) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    static String toStringList(List<?> thiz) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        String sep = "";
        for (Object e : thiz) {
            sb.append(sep);
            sb.append(e);
            sep = ", ";
        }
        sb.append(']');
        return sb.toString();
    }

    private class LI
    implements ListIterator<E> {
        private int prev = -1;
        private int at;
        private final int min;
        private final int max;
        private int add;

        LI(int at, int min, int max) {
            this.at = at;
            this.min = min;
            this.max = max;
        }

        LI(int min, int max) {
            this(min, min, max);
        }

        @Override
        public boolean hasNext() {
            return this.at < this.max + this.add;
        }

        @Override
        public E next() {
            if (this.at == this.max + this.add) {
                throw new NoSuchElementException();
            }
            this.prev = this.at;
            return SimpleList.this.arr[this.at++];
        }

        @Override
        public boolean hasPrevious() {
            return this.at > this.min;
        }

        @Override
        public E previous() {
            if (this.at == this.min) {
                throw new NoSuchElementException();
            }
            this.prev = --this.at;
            return SimpleList.this.arr[this.prev];
        }

        @Override
        public int nextIndex() {
            return this.at - this.min;
        }

        @Override
        public int previousIndex() {
            return this.at - 1 - this.min;
        }

        @Override
        public void remove() {
            if (this.prev == -1) {
                throw new IllegalStateException();
            }
            SimpleList.this.remove(this.prev);
            this.at = this.prev;
            this.prev = -1;
            --this.add;
        }

        @Override
        public void set(E e) {
            SimpleList.this.set(this.min + this.prev, e);
        }

        @Override
        public void add(E e) {
            SimpleList.this.add(this.min + this.at, e);
            ++this.add;
        }
    }

    private final class Sub
    implements List<E> {
        private final int from;
        private int to;

        Sub(int from, int to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public boolean isEmpty() {
            return this.to <= this.from;
        }

        @Override
        public boolean contains(Object o) {
            return SimpleList.this.containsImpl(o, this.from, this.to);
        }

        @Override
        public Object[] toArray() {
            return SimpleList.this.toArrayImpl(this.from, this.to);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return SimpleList.this.toArrayImpl(a, this.from, this.to);
        }

        @Override
        public boolean add(E e) {
            SimpleList.this.add(this.to++, e);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            if (SimpleList.this.removeImpl(o, this.from, this.to)) {
                --this.to;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            SimpleList.this.addAll(this.to, c);
            this.to += c.size();
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            SimpleList.this.addAll(this.from + index, c);
            this.to += c.size();
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            int prev = this.size();
            for (Object o : c) {
                this.remove(o);
            }
            return prev != this.size();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return SimpleList.this.retainImpl(this, c);
        }

        @Override
        public void sort(Comparator<? super E> c) {
            SimpleList.this.sortImpl(c, this.from, this.to);
        }

        @Override
        public void clear() {
            SimpleList.this.clearImpl(this.from, this.to);
            this.to = this.from;
        }

        @Override
        public E get(int index) {
            return SimpleList.this.get(this.from + index);
        }

        @Override
        public E set(int index, E element) {
            return SimpleList.this.set(this.from + index, element);
        }

        @Override
        public void add(int index, E element) {
            SimpleList.this.add(index + this.from, element);
            ++this.to;
        }

        @Override
        public E remove(int index) {
            Object ret = SimpleList.this.remove(index + this.from);
            --this.to;
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            return SimpleList.this.indexOfImpl(o, this.from, this.to);
        }

        @Override
        public int lastIndexOf(Object o) {
            return SimpleList.this.lastIndexOfImpl(o, this.from, this.to);
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new LI(this.from + index, this.from, this.to){

                @Override
                public void remove() {
                    super.remove();
                    Sub.this.to--;
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new Sub(this.from + fromIndex, this.from + toIndex);
        }

        @Override
        public boolean equals(Object obj) {
            return SimpleList.equalsList(this, obj);
        }

        @Override
        public int hashCode() {
            return SimpleList.hashList(this);
        }

        public String toString() {
            return SimpleList.toStringList(this);
        }
    }
}

