/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.awt.Dimension;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TableExtendedDelete {
    private static final Logger LOG = Logger.getLogger(TableExtendedDelete.class.getName());

    private static void retainOnlyLocalDependencies(Map<MetadataElementHandle, Set<MetadataElementHandle>> dependencies) {
        Set<MetadataElementHandle> keys = dependencies.keySet();
        for (Map.Entry<MetadataElementHandle, Set<MetadataElementHandle>> e : dependencies.entrySet()) {
            e.getValue().retainAll(keys);
        }
    }

    private static TopolocationSortResult getTopologicalSort(DatabaseConnection dbconn, final List<TableNode> tableNodes) {
        boolean isCyclic = false;
        final HashMap<MetadataElementHandle, Set<MetadataElementHandle>> dependencies = new HashMap<MetadataElementHandle, Set<MetadataElementHandle>>();
        try {
            dbconn.getMetadataModel().runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    for (TableNode tn : tableNodes) {
                        Table t = (Table)tn.getTableHandle().resolve(metaData);
                        HashSet<MetadataElementHandle> deps = new HashSet<MetadataElementHandle>();
                        for (ForeignKey k : t.getForeignKeys()) {
                            for (ForeignKeyColumn fkc : k.getColumns()) {
                                deps.add(MetadataElementHandle.create((MetadataElement)fkc.getReferredColumn().getParent()));
                            }
                        }
                        dependencies.put(tn.getTableHandle(), deps);
                    }
                }
            });
        }
        catch (MetadataModelException ex) {
            LOG.warning(ex.getMessage());
        }
        TableExtendedDelete.retainOnlyLocalDependencies(dependencies);
        LinkedList<MetadataElementHandle> deleteOrder = new LinkedList<MetadataElementHandle>();
        while (dependencies.size() > 0) {
            int candidateSize = Integer.MAX_VALUE;
            MetadataElementHandle candidate = null;
            for (Map.Entry e2 : dependencies.entrySet()) {
                if (candidate != null && ((Set)e2.getValue()).size() >= candidateSize) continue;
                candidate = (MetadataElementHandle)e2.getKey();
                candidateSize = ((Set)e2.getValue()).size();
            }
            deleteOrder.add(candidate);
            dependencies.remove(candidate);
            TableExtendedDelete.retainOnlyLocalDependencies(dependencies);
            if (candidateSize <= 0) continue;
            isCyclic = true;
        }
        Collections.reverse(deleteOrder);
        LinkedList<TableNode> deleteOrder2 = new LinkedList<TableNode>();
        block4: for (MetadataElementHandle meh : deleteOrder) {
            for (TableNode tn : tableNodes) {
                if (!tn.getTableHandle().equals((Object)meh)) continue;
                deleteOrder2.add(tn);
                continue block4;
            }
        }
        return new TopolocationSortResult(deleteOrder2, isCyclic);
    }

    public static void delete(Node[] inputNodes) {
        LinkedList<String> errors = new LinkedList<String>();
        HashMap nodes = new HashMap();
        for (Node n : inputNodes) {
            TableNode tn = (TableNode)n.getLookup().lookup(TableNode.class);
            if (tn == null) continue;
            DatabaseConnection connection = (DatabaseConnection)tn.getLookup().lookup(DatabaseConnection.class);
            if (nodes.get(connection) == null) {
                nodes.put(connection, new LinkedList());
            }
            ((List)nodes.get(connection)).add(tn);
        }
        boolean isCyclic = false;
        for (Map.Entry e : nodes.entrySet()) {
            TopolocationSortResult deleteHelper = TableExtendedDelete.getTopologicalSort((DatabaseConnection)e.getKey(), (List)e.getValue());
            isCyclic |= deleteHelper.isCyclic;
            for (TableNode tn : deleteHelper.list) {
                DatabaseConnector connector = ((DatabaseConnection)e.getKey()).getConnector();
                Specification spec = connector.getDatabaseSpecification();
                try {
                    AbstractCommand command = spec.createCommandDropTable(tn.getName());
                    String schemaName = tn.getSchemaName();
                    String catalogName = tn.getCatalogName();
                    if (schemaName == null) {
                        schemaName = catalogName;
                    }
                    command.setObjectOwner(schemaName);
                    command.execute();
                }
                catch (CommandNotSupportedException | DDLException ex) {
                    LOG.log(Level.INFO, "Error while deleting table " + tn.getName(), ex);
                    errors.add(NbBundle.getMessage(TableExtendedDelete.class, (String)"TableExtendedDelete_TableDeleteError", (Object)tn.getName(), (Object)ex.getMessage()));
                }
            }
            ConnectionManager.getDefault().refreshConnectionInExplorer(((DatabaseConnection)e.getKey()).getDatabaseConnection());
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            if (isCyclic) {
                sb.append(NbBundle.getMessage(TableExtendedDelete.class, (String)"TableExtendedDelete_CyclicDependency"));
            }
            for (int i = 0; i < errors.size(); ++i) {
                if (i > 0) {
                    sb.append("\n\n");
                }
                sb.append((String)errors.get(i));
            }
            JTextArea output = new JTextArea(sb.toString());
            output.setLineWrap(true);
            output.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(output);
            scrollPane.setMinimumSize(new Dimension(600, 200));
            scrollPane.setPreferredSize(new Dimension(600, 200));
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setVerticalScrollBarPolicy(20);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)scrollPane, 0));
        }
    }

    private static class TopolocationSortResult {
        public final List<TableNode> list;
        public final boolean isCyclic;

        public TopolocationSortResult(List<TableNode> list, boolean isCyclic) {
            this.list = list;
            this.isCyclic = isCyclic;
        }
    }
}

