/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.dlg.AddIndexDialog;
import org.netbeans.modules.db.explorer.dlg.AddViewDDL;
import org.netbeans.modules.db.explorer.dlg.CreateTableDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddViewDialog {
    private static final Logger LOGGER = Logger.getLogger(AddIndexDialog.class.getName());
    Dialog dialog = null;
    JTextField namefld;
    JTextArea tarea;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport statusLine;

    public AddViewDialog(final Specification spec, final String schemaName) {
        try {
            JPanel pane = new JPanel();
            pane.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints con = new GridBagConstraints();
            pane.setLayout(layout);
            JLabel label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(AddViewDialog.class, (String)"AddViewName"));
            label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddViewDialog.class, (String)"ACS_AddViewNameA11yDesc"));
            con.anchor = 17;
            con.insets = new Insets(2, 2, 2, 2);
            con.gridx = 0;
            con.gridy = 0;
            layout.setConstraints(label, con);
            pane.add(label);
            con.fill = 2;
            con.weightx = 1.0;
            con.gridx = 1;
            con.gridy = 0;
            con.insets = new Insets(2, 2, 2, 2);
            this.namefld = new JTextField(35);
            this.namefld.setToolTipText(NbBundle.getMessage(AddViewDialog.class, (String)"ACS_AddViewNameTextFieldA11yDesc"));
            this.namefld.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddViewDialog.class, (String)"ACS_AddViewNameTextFieldA11yName"));
            label.setLabelFor(this.namefld);
            layout.setConstraints(this.namefld, con);
            pane.add(this.namefld);
            DocumentListener docListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    AddViewDialog.this.validate();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    AddViewDialog.this.validate();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    AddViewDialog.this.validate();
                }
            };
            this.namefld.getDocument().addDocumentListener(docListener);
            label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(AddViewDialog.class, (String)"AddViewLabel"));
            label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddViewDialog.class, (String)"ACS_AddViewLabelA11yDesc"));
            con.weightx = 0.0;
            con.anchor = 17;
            con.insets = new Insets(2, 2, 2, 2);
            con.gridx = 0;
            con.gridy = 1;
            con.gridwidth = 2;
            layout.setConstraints(label, con);
            pane.add(label);
            this.tarea = new JTextArea(5, 50);
            this.tarea.setToolTipText(NbBundle.getMessage(AddViewDialog.class, (String)"ACS_AddViewTextAreaA11yDesc"));
            this.tarea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddViewDialog.class, (String)"ACS_AddViewTextAreaA11yName"));
            label.setLabelFor(this.tarea);
            this.tarea.getDocument().addDocumentListener(docListener);
            con.weightx = 1.0;
            con.weighty = 1.0;
            con.gridwidth = 2;
            con.fill = 1;
            con.insets = new Insets(0, 0, 0, 0);
            con.gridx = 0;
            con.gridy = 2;
            JScrollPane spane = new JScrollPane(this.tarea);
            layout.setConstraints(spane, con);
            pane.add(spane);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == DialogDescriptor.OK_OPTION) {
                        try {
                            boolean wasException = DbUtilities.doWithProgress(null, new Callable<Boolean>(){

                                @Override
                                public Boolean call() throws Exception {
                                    return AddViewDDL.addView(spec, schemaName, AddViewDialog.this.getViewName(), AddViewDialog.this.getViewCode());
                                }
                            });
                            if (!wasException) {
                                AddViewDialog.this.dialog.setVisible(false);
                                AddViewDialog.this.dialog.dispose();
                            }
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof DDLException) {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                            }
                            LOGGER.log(Level.INFO, cause.getLocalizedMessage(), cause);
                            DbUtilities.reportError(NbBundle.getMessage(AddViewDialog.class, (String)"ERR_UnableToCreateView"), e.getMessage());
                        }
                    }
                }
            };
            pane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddViewDialog.class, (String)"ACS_AddViewDialogA11yDesc"));
            this.descriptor = new DialogDescriptor((Object)pane, NbBundle.getMessage(AddViewDialog.class, (String)"AddViewTitle"), true, listener);
            this.descriptor.setHelpCtx(new HelpCtx("createviews"));
            this.statusLine = this.descriptor.createNotificationLineSupport();
            Object[] closingOptions = new Object[]{DialogDescriptor.CANCEL_OPTION};
            this.descriptor.setClosingOptions(closingOptions);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
            this.dialog.setResizable(true);
            this.validate();
        }
        catch (MissingResourceException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public String getViewName() {
        return this.namefld.getText();
    }

    public String getViewCode() {
        return this.tarea.getText();
    }

    private void validate() {
        assert (this.statusLine != null) : "Notification status line not available";
        String message = null;
        String viewName = this.getViewName();
        if (viewName == null || viewName.length() == 0) {
            message = NbBundle.getMessage(AddViewDialog.class, (String)"AddViewMissingViewName");
        } else if (this.getViewCode() == null || this.getViewCode().length() == 0) {
            message = NbBundle.getMessage(CreateTableDialog.class, (String)"AddViewMissingViewCode");
        }
        if (message == null) {
            this.statusLine.clearMessages();
            this.descriptor.setValid(true);
        } else {
            this.statusLine.setInformationMessage(message);
            this.descriptor.setValid(false);
        }
    }

    public static boolean showDialogAndCreate(Specification spec, String schema) {
        AddViewDialog panel = new AddViewDialog(spec, schema);
        panel.dialog.setVisible(true);
        return panel.descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }
}

