/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUnsupportedOperationException;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEventManager;
import org.netbeans.tax.event.TreeNodeContentEventModel;

public class TreeObjectList
extends TreeObject
implements TreeNodeContentEventModel,
List {
    public static final String PROP_CONTENT_INSERT = "contentInsert";
    public static final String PROP_CONTENT_REMOVE = "contentRemove";
    public static final String PROP_CONTENT_ORDER = "contentOrder";
    private ContentManager contentManager;
    private List list;

    protected TreeObjectList(ContentManager contentManager) {
        this.contentManager = contentManager;
        this.list = new LinkedList();
    }

    protected TreeObjectList(TreeObjectList objectList) {
        super(objectList);
        this.contentManager = null;
        this.list = new LinkedList();
        Iterator it = objectList.iterator();
        boolean wasReadOnly = this.isReadOnly();
        if (wasReadOnly) {
            this.setReadOnly(false);
        }
        while (it.hasNext()) {
            this.add(((TreeObject)it.next()).clone());
        }
        if (wasReadOnly) {
            this.setReadOnly(true);
        }
    }

    @Override
    public Object clone() {
        return new TreeObjectList(this);
    }

    @Override
    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeObjectList peer = (TreeObjectList)object;
        if (this.list.size() != peer.list.size()) {
            return false;
        }
        Iterator thisIt = this.list.iterator();
        Iterator peerIt = peer.list.iterator();
        while (thisIt.hasNext()) {
            Object peerNext;
            Object thisNext = thisIt.next();
            if (Util.equals(thisNext, peerNext = peerIt.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeObjectList peer = (TreeObjectList)treeObject;
        boolean wasReadOnly = this.isReadOnly();
        if (wasReadOnly) {
            this.setReadOnly(false);
        }
        TreeObject[] backupArray = this.list.toArray(new TreeObject[0]);
        this.list.clear();
        short policy = 2;
        TreeEventManager manager = this.getEventManager();
        if (manager != null) {
            policy = manager.getFirePolicy();
            manager.setFirePolicy((short)2);
        }
        boolean reordered = true;
        int[] permutation = null;
        int originalIndex = 0;
        if (backupArray.length == peer.list.size()) {
            permutation = new int[backupArray.length];
        } else {
            reordered = false;
        }
        for (TreeObject peerNode : peer.list) {
            TreeObject suitableNode = null;
            int suitableIndex = this.findMergeCandidate(peerNode, backupArray);
            if (suitableIndex >= 0) {
                suitableNode = backupArray[suitableIndex];
                backupArray[suitableIndex] = null;
            }
            if (suitableNode != null) {
                suitableNode.merge(peerNode);
                this.addNoFire(suitableNode);
                if (permutation != null) {
                    permutation[originalIndex] = suitableIndex;
                }
            } else {
                suitableNode = peerNode;
                this.add(suitableNode);
                reordered = false;
            }
            ++originalIndex;
        }
        if (reordered) {
            reordered = false;
            for (int i = 0; i < permutation.length; ++i) {
                if (permutation[i] == i) continue;
                reordered = true;
                break;
            }
            if (reordered) {
                this.firePropertyOrder(permutation);
            }
        } else {
            for (int i = 0; i < backupArray.length; ++i) {
                if (backupArray[i] == null) continue;
                this.contentManagerObjectRemoved(backupArray[i]);
                this.firePropertyRemove(backupArray[i]);
            }
        }
        if (wasReadOnly) {
            this.setReadOnly(true);
        }
        if (manager != null) {
            manager.setFirePolicy(policy);
        }
    }

    protected int findMergeCandidate(TreeObject original, TreeObject[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            TreeObject candidate = candidates[i];
            if (candidate == null || !original.getClass().equals(candidate.getClass())) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void setReadOnly(boolean newReadOnly) {
        super.setReadOnly(newReadOnly);
        for (TreeObject obj : this.list) {
            obj.setReadOnly(newReadOnly);
        }
    }

    @Override
    public final boolean isInContext() {
        return true;
    }

    @Override
    public final void removeFromContext() throws ReadOnlyException {
        if (this.isInContext()) {
            this.clear();
        }
    }

    public final ContentManager getContentManager() {
        return this.contentManager;
    }

    public final boolean isAssignableObject(Object obj) {
        try {
            this.getContentManager().checkAssignableObject(obj);
            return true;
        }
        catch (ClassCastException exc) {
            return false;
        }
    }

    public final void reorder(int[] perm) throws ReadOnlyException, InvalidArgumentException {
        int i;
        if (this.equals(perm)) {
            return;
        }
        this.checkReadOnly();
        this.checkReorder(perm);
        LinkedList newList = new LinkedList();
        int len = this.size();
        int[] newPerm = new int[len];
        for (i = 0; i < len; ++i) {
            newPerm[perm[i]] = i;
        }
        for (i = 0; i < len; ++i) {
            newList.add(this.list.get(newPerm[i]));
        }
        this.list = newList;
        this.contentManagerOrderChanged(perm);
        this.firePropertyOrder(perm);
    }

    protected final void checkReorder(int[] perm) throws InvalidArgumentException {
        if (perm == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_reorder_permutation"), new NullPointerException());
        }
        if (perm.length != this.size()) {
            throw new InvalidArgumentException((Object)(perm.length + " != " + this.size()), Util.THIS.getString("EXC_invalid_reorder_permutation"));
        }
    }

    protected final boolean equals(int[] perm) {
        for (int i = 0; i < perm.length; ++i) {
            if (perm[i] == i) continue;
            return false;
        }
        return true;
    }

    public final void switchObjects(int fromIndex, int toIndex) throws ReadOnlyException, InvalidArgumentException {
        int len = this.size();
        int[] perm = new int[len];
        for (int i = 0; i < perm.length; ++i) {
            perm[i] = i;
        }
        perm[fromIndex] = toIndex;
        perm[toIndex] = fromIndex;
        this.reorder(perm);
    }

    protected final void checkUnsupportedOperation() throws TreeUnsupportedOperationException {
        try {
            this.checkReadOnly();
        }
        catch (TreeException exc) {
            throw new TreeUnsupportedOperationException(exc);
        }
    }

    @Override
    public final void clear() {
        this.checkUnsupportedOperation();
        for (Object obj : new LinkedList(this.list)) {
            this.remove(obj);
        }
    }

    @Override
    public final boolean removeAll(Collection collection) throws UnsupportedOperationException {
        this.checkUnsupportedOperation();
        throw new UnsupportedOperationException();
    }

    public final Object get(int index) {
        return this.list.get(index);
    }

    @Override
    public final int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    @Override
    public final boolean retainAll(Collection collection) throws UnsupportedOperationException {
        this.checkUnsupportedOperation();
        throw new UnsupportedOperationException();
    }

    protected boolean removeImpl(Object obj) {
        return this.list.remove(obj);
    }

    @Override
    public final boolean remove(Object obj) {
        this.checkUnsupportedOperation();
        boolean removed = this.removeImpl(obj);
        if (removed) {
            this.contentManagerObjectRemoved((TreeObject)obj);
            this.firePropertyRemove((TreeObject)obj);
        }
        return removed;
    }

    @Override
    public final int indexOf(Object obj) {
        return this.list.indexOf(obj);
    }

    @Override
    public final boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    @Override
    public final int lastIndexOf(Object obj) {
        return this.list.lastIndexOf(obj);
    }

    protected Object setImpl(int index, Object obj) {
        return this.list.set(index, obj);
    }

    public final Object set(int index, Object obj) {
        this.checkUnsupportedOperation();
        this.contentManagerCheckAssignableObject(obj);
        Object oldObj = this.setImpl(index, obj);
        this.contentManagerObjectRemoved((TreeObject)oldObj);
        this.firePropertyRemove((TreeObject)oldObj);
        this.contentManagerObjectInserted((TreeObject)obj);
        this.firePropertyInsert((TreeObject)obj);
        return oldObj;
    }

    public final ListIterator listIterator(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean containsAll(Collection collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public final Iterator iterator() {
        return new LinkedList(this.list).iterator();
    }

    @Override
    public final boolean addAll(Collection collection) {
        this.checkUnsupportedOperation();
        boolean changed = false;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.add(it.next());
            changed = true;
        }
        return changed;
    }

    protected Object removeImpl(int index) {
        return this.list.remove(index);
    }

    public final Object remove(int index) {
        this.checkUnsupportedOperation();
        Object oldObj = this.removeImpl(index);
        if (oldObj != null) {
            this.contentManagerObjectRemoved((TreeObject)oldObj);
            this.firePropertyRemove((TreeObject)oldObj);
        }
        return oldObj;
    }

    @Override
    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    protected void addImpl(int index, Object obj) {
        this.list.add(index, obj);
    }

    public final void add(int index, Object obj) {
        this.checkUnsupportedOperation();
        this.contentManagerCheckAssignableObject(obj);
        this.addImpl(index, obj);
        this.contentManagerObjectInserted((TreeObject)obj);
        this.firePropertyInsert((TreeObject)obj);
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof TreeObjectList)) {
            return false;
        }
        return this.list.equals(((TreeObjectList)obj).list);
    }

    public final boolean addAll(int index, Collection collection) throws UnsupportedOperationException {
        this.checkUnsupportedOperation();
        throw new UnsupportedOperationException();
    }

    protected boolean addImpl(Object obj) {
        return this.list.add(obj);
    }

    private boolean addNoFire(Object obj) {
        this.checkUnsupportedOperation();
        this.contentManagerCheckAssignableObject(obj);
        return this.addImpl(obj);
    }

    @Override
    public final boolean add(Object obj) {
        boolean added = this.addNoFire(obj);
        if (added) {
            this.contentManagerObjectInserted((TreeObject)obj);
            this.firePropertyInsert((TreeObject)obj);
        }
        return added;
    }

    @Override
    public final Object[] toArray(Object[] array) {
        return this.list.toArray(array);
    }

    @Override
    public final Object[] toArray() {
        return this.list.toArray();
    }

    public final ListIterator listIterator() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public final List subList(int fromIndex, int toIndex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public final TreeEventManager getEventManager() {
        TreeNode ownerNode = this.contentManagerGetOwnerNode();
        if (ownerNode == null) {
            return null;
        }
        return ownerNode.getEventManager();
    }

    @Override
    public final void addContentChangeListener(PropertyChangeListener listener) {
        this.getEventChangeSupport().addPropertyChangeListener(PROP_CONTENT_INSERT, listener);
        this.getEventChangeSupport().addPropertyChangeListener(PROP_CONTENT_REMOVE, listener);
        this.getEventChangeSupport().addPropertyChangeListener(PROP_CONTENT_ORDER, listener);
    }

    @Override
    public final void removeContentChangeListener(PropertyChangeListener listener) {
        this.getEventChangeSupport().removePropertyChangeListener(PROP_CONTENT_INSERT, listener);
        this.getEventChangeSupport().removePropertyChangeListener(PROP_CONTENT_REMOVE, listener);
        this.getEventChangeSupport().removePropertyChangeListener(PROP_CONTENT_ORDER, listener);
    }

    @Override
    public final boolean hasContentChangeListeners() {
        return this.getEventChangeSupport().hasPropertyChangeListeners(PROP_CONTENT_INSERT) || this.getEventChangeSupport().hasPropertyChangeListeners(PROP_CONTENT_REMOVE) || this.getEventChangeSupport().hasPropertyChangeListeners(PROP_CONTENT_ORDER);
    }

    public final void firePropertyInsert(TreeObject newNode) {
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_CONTENT_INSERT, null, newNode));
    }

    public final void firePropertyRemove(TreeObject oldNode) {
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_CONTENT_REMOVE, oldNode, null));
    }

    public final void firePropertyOrder(int[] permutation) {
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_CONTENT_ORDER, null, permutation));
    }

    protected final TreeNode contentManagerGetOwnerNode() {
        if (this.contentManager != null) {
            return this.contentManager.getOwnerNode();
        }
        return null;
    }

    protected final void contentManagerCheckAssignableObject(Object object) {
        if (this.contentManager != null) {
            this.contentManager.checkAssignableObject(object);
        }
    }

    protected final void contentManagerObjectInserted(TreeObject treeObject) {
        if (this.contentManager != null) {
            this.contentManager.objectInserted(treeObject);
        }
    }

    protected final void contentManagerObjectRemoved(TreeObject treeObject) {
        if (this.contentManager != null) {
            this.contentManager.objectRemoved(treeObject);
        }
    }

    protected final void contentManagerOrderChanged(int[] permutation) {
        if (this.contentManager != null) {
            this.contentManager.orderChanged(permutation);
        }
    }

    public static abstract class ContentManager {
        public abstract TreeNode getOwnerNode();

        public void checkAssignableObject(Object obj) throws ClassCastException {
            if (!(obj instanceof TreeObject)) {
                String msg = Util.THIS.getString("EXC_invalid_instance_of_TreeObject");
                throw new ClassCastException(msg);
            }
        }

        protected final void checkAssignableClass(Class cls, Object obj) throws ClassCastException {
            if (!cls.isInstance(obj)) {
                String msg = Util.THIS.getString("EXC_is_not_assignable_to", cls.getName());
                throw new ClassCastException(msg);
            }
        }

        public abstract void objectInserted(TreeObject var1);

        public abstract void objectRemoved(TreeObject var1);

        public abstract void orderChanged(int[] var1);
    }
}

