/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk.models;

import java.lang.ref.WeakReference;
import javax.security.auth.Refreshable;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.debugger.jpda.heapwalk.HeapImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.InstanceImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.views.DebuggerHeapFragmentWalker;
import org.netbeans.modules.debugger.jpda.heapwalk.views.InstancesView;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class HeapActionsFilter
implements NodeActionsProviderFilter {
    private JPDADebugger debugger;
    private RequestProcessor rp;
    private final Action HEAP_REFERENCES_ACTION = Models.createAction((String)NbBundle.getMessage(HeapActionsFilter.class, (String)"CTL_References_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            if (node == null || !(node instanceof ObjectVariable)) {
                return false;
            }
            ObjectVariable var = (ObjectVariable)node;
            if (var instanceof Refreshable && !((Refreshable)var).isCurrent()) {
                return false;
            }
            return var.getUniqueID() != 0L;
        }

        public void perform(Object[] nodes) {
            ObjectVariable var = (ObjectVariable)nodes[0];
            if (var.getUniqueID() == 0L) {
                return;
            }
            final InstancesView instances = this.openInstances(true);
            final WeakReference<ObjectVariable> varRef = new WeakReference<ObjectVariable>(var);
            final WeakReference<JPDADebugger> debuggerRef = new WeakReference<JPDADebugger>(HeapActionsFilter.this.debugger);
            InstancesView.HeapFragmentWalkerProvider provider = new InstancesView.HeapFragmentWalkerProvider(){

                @Override
                public synchronized HeapFragmentWalker getHeapFragmentWalker() {
                    HeapFragmentWalker hfw = instances.getCurrentFragmentWalker();
                    HeapImpl heap = hfw != null ? (HeapImpl)hfw.getHeapFragment() : null;
                    JPDADebugger debugger = (JPDADebugger)debuggerRef.get();
                    if (heap == null || debugger != null && heap.getDebugger() != debugger) {
                        heap = new HeapImpl(debugger);
                        hfw = new DebuggerHeapFragmentWalker(heap);
                    }
                    final ObjectVariable var = (ObjectVariable)varRef.get();
                    final HeapFragmentWalker fhfw = hfw;
                    if (var != null) {
                        final HeapImpl fheap = heap;
                        HeapActionsFilter.this.rp.post(new Runnable(){

                            @Override
                            public void run() {
                                final Instance instance = InstanceImpl.createInstance(fheap, var);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        fhfw.getInstancesController().showInstance(instance);
                                    }
                                });
                            }
                        });
                    }
                    return hfw;
                }
            };
            instances.setHeapFragmentWalkerProvider(provider);
        }

        private InstancesView openInstances(boolean activate) {
            TopComponent view = WindowManager.getDefault().findTopComponent("dbgInstances");
            if (view == null) {
                throw new IllegalArgumentException("dbgInstances");
            }
            view.open();
            if (activate) {
                view.requestActive();
            }
            return (InstancesView)view;
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public HeapActionsFilter(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.rp = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
        if (this.rp == null) {
            this.rp = new RequestProcessor(HeapActionsFilter.class);
        }
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        if (node instanceof ObjectVariable && this.debugger.canGetInstanceInfo()) {
            int index;
            for (index = 0; index < actions.length && actions[index] != null; ++index) {
            }
            Action[] newActions = new Action[actions.length + 1];
            System.arraycopy(actions, 0, newActions, 0, index);
            newActions[index] = this.HEAP_REFERENCES_ACTION;
            if (index < actions.length) {
                System.arraycopy(actions, index, newActions, index + 1, actions.length - index);
            }
            actions = newActions;
        }
        return actions;
    }
}

