/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;

public class PullUpTransformer
extends RefactoringVisitor {
    private MemberInfo<ElementHandle<? extends Element>>[] members;
    private TypeElement targetType;
    private TypeElement sourceType;
    private PullUpRefactoring refactoring;

    public PullUpTransformer(PullUpRefactoring refactoring) {
        this.refactoring = refactoring;
        this.members = refactoring.getMembers();
    }

    @Override
    public void setWorkingCopy(WorkingCopy copy) throws ToPhaseException {
        super.setWorkingCopy(copy);
        this.targetType = (TypeElement)this.refactoring.getTargetType().resolve((CompilationInfo)copy);
        this.sourceType = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)copy);
    }

    public Tree visitClass(ClassTree tree, Element p) {
        Element classElement = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        AtomicBoolean classIsAbstract = new AtomicBoolean(classElement.getKind().isInterface());
        if (classElement.equals(this.targetType)) {
            this.addMembersToTarget(tree, classIsAbstract, this.targetType, genUtils);
        } else if (classElement.equals(this.sourceType)) {
            this.removeMembersFromSource(tree, classIsAbstract);
        }
        return (Tree)super.visitClass(tree, (Object)p);
    }

    private void addMembersToTarget(ClassTree tree, AtomicBoolean classIsAbstract, TypeElement classElement, GeneratorUtilities genUtils) {
        ClassTree njuClass = tree;
        for (int i = 0; i < this.members.length; ++i) {
            MemberInfo.Group group;
            Element member = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
            if (member.getKind() == ElementKind.METHOD) {
                ExecutableElement method = (ExecutableElement)member;
                method = (ExecutableElement)this.workingCopy.getElementUtilities().getImplementationOf(method, this.sourceType);
                if (method != null) {
                    member = method;
                }
            }
            if ((group = this.members[i].getGroup()) == MemberInfo.Group.IMPLEMENTS) {
                njuClass = this.make.addClassImplementsClause(njuClass, (Tree)this.make.QualIdent(member));
                continue;
            }
            if (this.members[i].isMakeAbstract()) {
                if (classIsAbstract.compareAndSet(false, true)) {
                    this.makeClassAbstract(njuClass);
                }
                njuClass = this.addAbstractMemberToTarget(njuClass, member, classElement, genUtils);
                continue;
            }
            if (member.getModifiers().contains((Object)Modifier.ABSTRACT) && classIsAbstract.compareAndSet(false, true)) {
                this.makeClassAbstract(njuClass);
            }
            njuClass = this.addMemberToTarget(njuClass, member, classElement, group, genUtils);
        }
        if (njuClass != tree) {
            this.rewrite(tree, njuClass);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeMembersFromSource(ClassTree tree, AtomicBoolean classIsAbstract) {
        ClassTree njuClass = tree;
        for (int i = 0; i < this.members.length; ++i) {
            void var6_10;
            Object method;
            if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS) {
                for (Tree tree2 : njuClass.getImplementsClause()) {
                    Element currentInterface = this.workingCopy.getTrees().getElement(TreePath.getPath(this.getCurrentPath(), tree2));
                    if (currentInterface == null || !currentInterface.equals(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                    njuClass = this.make.removeClassImplementsClause(njuClass, tree2);
                    this.rewrite(tree, njuClass);
                }
                continue;
            }
            Element current = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            Element element = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
            if (element != null && element.getKind() == ElementKind.METHOD) {
                method = (ExecutableElement)element;
                method = (ExecutableElement)this.workingCopy.getElementUtilities().getImplementationOf((ExecutableElement)method, this.sourceType);
                if (method != null) {
                    ExecutableElement executableElement = method;
                }
            }
            if (var6_10 == null || !var6_10.getEnclosingElement().equals(current)) continue;
            if (classIsAbstract.get() && !var6_10.getModifiers().contains((Object)Modifier.DEFAULT) || !this.members[i].isMakeAbstract() || var6_10.getModifiers().contains((Object)Modifier.ABSTRACT) && this.targetType.getKind().isInterface()) {
                njuClass = this.make.removeClassMember(njuClass, this.workingCopy.getTrees().getTree((Element)var6_10));
                this.rewrite(tree, njuClass);
                continue;
            }
            if (!this.members[i].isMakeAbstract() || !var6_10.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            method = (MethodTree)this.workingCopy.getTrees().getTree((Element)var6_10);
            ModifiersTree mods = this.make.removeModifiersModifier(method.getModifiers(), Modifier.PRIVATE);
            mods = this.make.addModifiersModifier(mods, this.targetType.getKind().isInterface() ? Modifier.PUBLIC : Modifier.PROTECTED);
            this.rewrite(method.getModifiers(), mods);
        }
    }

    private ClassTree addAbstractMemberToTarget(ClassTree njuClass, Element methodElm, Element classElement, GeneratorUtilities genUtils) {
        MethodTree method = (MethodTree)this.workingCopy.getTrees().getTree(methodElm);
        Set<Modifier> flags = method.getModifiers().getFlags();
        EnumSet<Modifier> mod = flags.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(flags);
        mod.add(Modifier.ABSTRACT);
        mod.remove((Object)Modifier.FINAL);
        mod.remove((Object)Modifier.DEFAULT);
        mod.remove((Object)Modifier.SYNCHRONIZED);
        if (classElement.getKind().isInterface()) {
            mod.remove((Object)Modifier.PUBLIC);
            mod.remove((Object)Modifier.PROTECTED);
            mod.remove((Object)Modifier.PRIVATE);
            mod.remove((Object)Modifier.ABSTRACT);
        }
        if (mod.contains((Object)Modifier.PRIVATE)) {
            mod.remove((Object)Modifier.PRIVATE);
            mod.add(Modifier.PROTECTED);
        }
        MethodTree newMethod = this.make.Method(this.make.Modifiers(mod), (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), method.getParameters(), method.getThrows(), (BlockTree)null, (ExpressionTree)method.getDefaultValue());
        newMethod = (MethodTree)genUtils.importFQNs((Tree)newMethod);
        method = (MethodTree)genUtils.importComments((Tree)method, this.workingCopy.getTrees().getPath(methodElm).getCompilationUnit());
        genUtils.copyComments((Tree)method, (Tree)newMethod, false);
        genUtils.copyComments((Tree)method, (Tree)newMethod, true);
        njuClass = genUtils.insertClassMember(njuClass, (Tree)newMethod);
        return njuClass;
    }

    private void makeClassAbstract(ClassTree njuClass) {
        EnumSet<Modifier> mod = EnumSet.copyOf(njuClass.getModifiers().getFlags());
        mod.add(Modifier.ABSTRACT);
        mod.remove((Object)Modifier.FINAL);
        ModifiersTree modifiers = this.make.Modifiers(mod);
        this.rewrite(njuClass.getModifiers(), modifiers);
    }

    private ClassTree addMemberToTarget(ClassTree njuClass, Element member, TypeElement classElement, MemberInfo.Group group, GeneratorUtilities genUtils) {
        TreePath mpath = this.workingCopy.getTrees().getPath(member);
        Tree memberTree = genUtils.importComments(mpath.getLeaf(), mpath.getCompilationUnit());
        memberTree = genUtils.importFQNs(memberTree);
        memberTree = this.fixGenericTypes(memberTree, mpath, member);
        if (member.getModifiers().contains((Object)Modifier.PRIVATE)) {
            Tree newMemberTree = null;
            if (group == MemberInfo.Group.METHOD) {
                MethodTree oldOne = (MethodTree)memberTree;
                BlockTree body = this.updateSuperThisReferences(oldOne.getBody(), mpath);
                newMemberTree = this.make.Method(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getName(), oldOne.getReturnType(), oldOne.getTypeParameters(), oldOne.getParameters(), oldOne.getThrows(), body, (ExpressionTree)oldOne.getDefaultValue());
            } else if (group == MemberInfo.Group.FIELD) {
                VariableTree oldOne = (VariableTree)memberTree;
                newMemberTree = this.make.Variable(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getName(), oldOne.getType(), oldOne.getInitializer());
            } else if (group == MemberInfo.Group.TYPE) {
                ClassTree oldOne = (ClassTree)memberTree;
                switch (member.getKind()) {
                    case CLASS: {
                        newMemberTree = this.make.Class(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getTypeParameters(), oldOne.getExtendsClause(), oldOne.getImplementsClause(), oldOne.getMembers());
                        break;
                    }
                    case INTERFACE: {
                        newMemberTree = this.make.Interface(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getTypeParameters(), oldOne.getImplementsClause(), oldOne.getMembers());
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        newMemberTree = this.make.AnnotationType(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getMembers());
                        break;
                    }
                    case ENUM: {
                        newMemberTree = this.make.Enum(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getImplementsClause(), oldOne.getMembers());
                    }
                }
            }
            if (newMemberTree != null) {
                genUtils.copyComments(memberTree, newMemberTree, false);
                genUtils.copyComments(memberTree, newMemberTree, true);
                njuClass = genUtils.insertClassMember(njuClass, newMemberTree);
            }
        } else if (group == MemberInfo.Group.METHOD) {
            MethodTree oldOne = (MethodTree)memberTree;
            BlockTree body = this.updateSuperThisReferences(oldOne.getBody(), mpath);
            ExecutableElement overriddenMethod = this.workingCopy.getElementUtilities().getOverriddenMethod((ExecutableElement)member);
            MethodTree newMemberTree = this.make.Method(overriddenMethod != null && this.workingCopy.getElementUtilities().isMemberOf((Element)overriddenMethod, this.targetType) ? oldOne.getModifiers() : PullUpTransformer.removeAnnotations(this.workingCopy, this.make, oldOne.getModifiers(), mpath), (CharSequence)oldOne.getName(), oldOne.getReturnType(), oldOne.getTypeParameters(), oldOne.getParameters(), oldOne.getThrows(), body, (ExpressionTree)oldOne.getDefaultValue());
            genUtils.copyComments(memberTree, (Tree)newMemberTree, false);
            genUtils.copyComments(memberTree, (Tree)newMemberTree, true);
            njuClass = genUtils.insertClassMember(njuClass, (Tree)newMemberTree);
        } else {
            njuClass = genUtils.insertClassMember(njuClass, memberTree);
        }
        return njuClass;
    }

    static ModifiersTree removeAnnotations(WorkingCopy workingCopy, TreeMaker make, ModifiersTree oldOne, TreePath path) {
        TypeElement override = workingCopy.getElements().getTypeElement("java.lang.Override");
        if (override == null) {
            return oldOne;
        }
        LinkedList<AnnotationTree> newAnnotations = new LinkedList<AnnotationTree>();
        for (AnnotationTree annotationTree : oldOne.getAnnotations()) {
            Element el = workingCopy.getTrees().getElement(new TreePath(path, annotationTree));
            if (override.equals(el)) continue;
            newAnnotations.add(annotationTree);
        }
        return make.Modifiers(oldOne, newAnnotations);
    }

    private <E extends Tree> E fixGenericTypes(E tree, final TreePath path, final Element member) {
        final HashMap<TypeMirror, TypeParameterElement> mappings = new HashMap<TypeMirror, TypeParameterElement>();
        DeclaredType declaredType = (DeclaredType)this.sourceType.asType();
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            DeclaredType currentElement = declaredType;
            this.deepSearchTypes(currentElement, typeMirror, typeMirror, mappings);
        }
        final Types types = this.workingCopy.getTypes();
        final HashMap hashMap = new HashMap();
        ErrorAwareTreeScanner<Void, Void> scanner = new ErrorAwareTreeScanner<Void, Void>(){

            public Void visitIdentifier(IdentifierTree node, Void p) {
                TypeParameterElement parameterElement;
                Element genericElement;
                Element typeElement;
                Element element = PullUpTransformer.this.workingCopy.getTrees().getElement(new TreePath(path, node));
                if (element != null && element.getKind() == ElementKind.TYPE_PARAMETER && (typeElement = types.asElement(element.asType())) != null && typeElement.getKind() == ElementKind.TYPE_PARAMETER && (genericElement = (parameterElement = (TypeParameterElement)typeElement).getGenericElement()) != member) {
                    List<? extends TypeMirror> bounds;
                    TypeParameterElement target = (TypeParameterElement)mappings.get(parameterElement.asType());
                    Tree type = target != null ? PullUpTransformer.this.make.Type(target.asType()) : ((bounds = parameterElement.getBounds()).isEmpty() ? PullUpTransformer.this.make.Type("Object") : PullUpTransformer.this.make.Type(bounds.get(0)));
                    hashMap.put(node, type);
                }
                return (Void)super.visitIdentifier(node, (Object)p);
            }
        };
        scanner.scan(tree, null);
        Tree result = this.workingCopy.getTreeUtilities().translate(tree, hashMap);
        return (E)result;
    }

    private BlockTree updateSuperThisReferences(BlockTree body, final TreePath mpath) {
        boolean update;
        final HashMap original2Translated = new HashMap();
        final Trees trees = this.workingCopy.getTrees();
        ErrorAwareTreeScanner<Boolean, Void> idScan = new ErrorAwareTreeScanner<Boolean, Void>(){

            public Boolean visitMemberSelect(MemberSelectTree node, Void nothing) {
                TreePath currentPath;
                Element el;
                String isThis = node.getExpression().toString();
                if ((isThis.equals("super") || isThis.endsWith(".super")) && (el = trees.getElement(currentPath = new TreePath(mpath, node))) != null && el.getEnclosingElement().equals(PullUpTransformer.this.targetType)) {
                    original2Translated.put(node, PullUpTransformer.this.make.Identifier((CharSequence)node.getIdentifier()));
                    return Boolean.TRUE;
                }
                return (Boolean)super.visitMemberSelect(node, (Object)nothing);
            }

            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
            }
        };
        boolean bl = update = idScan.scan((Tree)body, null) == Boolean.TRUE;
        if (update) {
            body = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)body, original2Translated);
        }
        return body;
    }

    private boolean deepSearchTypes(DeclaredType currentElement, TypeMirror orig, TypeMirror something, Map<TypeMirror, TypeParameterElement> mappings) {
        Types types = this.workingCopy.getTypes();
        List<? extends TypeMirror> directSupertypes = types.directSupertypes(currentElement);
        for (TypeMirror typeMirror : directSupertypes) {
            DeclaredType type = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = type.getTypeArguments();
            for (int i = 0; i < typeArguments.size(); ++i) {
                TypeMirror typeArgument = typeArguments.get(i);
                if (!something.equals(typeArgument)) continue;
                TypeElement asElement = (TypeElement)type.asElement();
                mappings.put(orig, asElement.getTypeParameters().get(i));
                if (types.erasure(this.targetType.asType()).equals(types.erasure(typeMirror))) {
                    return true;
                }
                if (this.deepSearchTypes(type, orig, typeArgument, mappings)) break;
            }
            if (!types.erasure(this.targetType.asType()).equals(types.erasure(typeMirror))) continue;
            mappings.remove(orig);
            return true;
        }
        return false;
    }
}

