/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jvyamlb.Position;
import org.jvyamlb.PositioningParserImpl;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.YAMLTestCase;
import org.jvyamlb.events.Event;
import org.jvyamlb.events.PositionedAliasEvent;
import org.jvyamlb.events.PositionedDocumentEndEvent;
import org.jvyamlb.events.PositionedDocumentStartEvent;
import org.jvyamlb.events.PositionedMappingEndEvent;
import org.jvyamlb.events.PositionedMappingStartEvent;
import org.jvyamlb.events.PositionedScalarEvent;
import org.jvyamlb.events.PositionedSequenceEndEvent;
import org.jvyamlb.events.PositionedSequenceStartEvent;
import org.jvyamlb.events.PositionedStreamEndEvent;
import org.jvyamlb.events.PositionedStreamStartEvent;
import org.jvyamlb.exceptions.ParserException;
import org.jvyamlb.exceptions.PositionedParserException;

public class PositioningParserImplTest
extends YAMLTestCase {
    public PositioningParserImplTest(String name) {
        super(name);
    }

    protected List getParse(String input) {
        PositioningParserImpl parser = new PositioningParserImpl(new PositioningScannerImpl(input));
        ArrayList output = new ArrayList();
        Iterator iter = parser.iterator();
        while (iter.hasNext()) {
            output.add(iter.next());
        }
        return output;
    }

    public void testThatEmptyParserGeneratesPositionedEnvelope() {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 0, 0))));
        List events = this.getParse("");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatSimpleScalarGeneratesCorrectPositioning() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 1, 1))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 1, 1))));
        List events = this.getParse("a");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatComplicatedeScalarGeneratesCorrectPositioning() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(true, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{false, true}, this.s("abcdefafgsdfgsdfg sfgdfsg fdsgfgsdf"), '\"', new Position.Range(new Position(0, 4, 4), new Position(2, 10, 41))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(2, 10, 41))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(2, 10, 41))));
        List events = this.getParse("--- \"abcdefafgsdfgsdfg\nsfgdfsg\nfdsgfgsdf\"");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatAKeyValuePairGetsCorrectPositioning() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedMappingStartEvent(null, null, true, false, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(0, 3, 3), new Position(0, 4, 4))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(0, 4, 4))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 4, 4))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 4, 4))));
        List events = this.getParse("a: b");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatTwoKeyValuePairsGetsCorrectPositioning() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedMappingStartEvent(null, null, true, false, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(0, 3, 3), new Position(0, 4, 4))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("c"), '\u0000', new Position.Range(new Position(1, 0, 5), new Position(1, 1, 6))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("d"), '\u0000', new Position.Range(new Position(1, 4, 9), new Position(1, 5, 10))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(1, 5, 10))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(1, 5, 10))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(1, 5, 10))));
        List events = this.getParse("a: b\nc:  d");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatAOneItemSequenceWorks() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedSequenceStartEvent(null, null, true, false, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 2, 2), new Position(0, 3, 3))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(0, 3, 3))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 3, 3))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 3, 3))));
        List events = this.getParse("- a");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatMoreThanOneItemSequenceWorks() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedSequenceStartEvent(null, null, true, false, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 2, 2), new Position(0, 3, 3))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(1, 4, 8), new Position(1, 5, 9))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("c"), '\u0000', new Position.Range(new Position(2, 2, 12), new Position(2, 3, 13))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(2, 3, 13))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(2, 3, 13))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(2, 3, 13))));
        List events = this.getParse("- a\n-   b\n- c");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatListedSequenesWorks() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedSequenceStartEvent(null, null, true, false, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 2, 2), new Position(0, 3, 3))));
        expected.add(new PositionedSequenceStartEvent(null, null, true, false, new Position.Range(new Position(1, 2, 6))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("foo"), '\u0000', new Position.Range(new Position(1, 4, 8), new Position(1, 7, 11))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("bar"), '\u0000', new Position.Range(new Position(2, 4, 16), new Position(2, 7, 19))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(2, 7, 19))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(3, 2, 22), new Position(3, 3, 23))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(3, 3, 23))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(3, 3, 23))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(3, 3, 23))));
        List events = this.getParse("- a\n- - foo\n  - bar\n- b");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatSimpleFlowMappingWorks() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedMappingStartEvent(null, null, true, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 1, 1), new Position(0, 2, 2))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(0, 4, 4), new Position(0, 5, 5))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(0, 6, 6))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 7, 7))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 7, 7))));
        List events = this.getParse("{a: b }");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatSimpleFlowSequenceWorks() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedSequenceStartEvent(null, null, true, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 1, 1), new Position(0, 2, 2))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(0, 2, 2))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 3, 3))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 3, 3))));
        List events = this.getParse("[a]");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testThatFlowSequenceWithMoreThanOneElementWorks() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedSequenceStartEvent(null, null, true, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 1, 1), new Position(0, 2, 2))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(0, 4, 4), new Position(0, 5, 5))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(0, 6, 6))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 7, 7))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 7, 7))));
        List events = this.getParse("[a, b ]");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testScalarWithTag() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, "!str", new boolean[]{false, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 6, 6))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 6, 6))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 6, 6))));
        List events = this.getParse("!str a");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testScalarWithAnchor() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent("blad", null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 7, 7))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 7, 7))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 7, 7))));
        List events = this.getParse("&blad a");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testScalarWithAnchorAndTag() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent("blad", "!str", new boolean[]{false, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 12, 12))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 12, 12))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 12, 12))));
        List events = this.getParse("&blad !str a");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
        events = this.getParse("!str &blad a");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testAlias() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedAliasEvent("blad", new Position.Range(new Position(0, 0, 0), new Position(0, 5, 5))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 5, 5))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 5, 5))));
        List events = this.getParse("*blad");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testSequenceWithTag() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedSequenceStartEvent(null, "!seq", false, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 6, 6), new Position(0, 7, 7))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(0, 7, 7))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 8, 8))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 8, 8))));
        List events = this.getParse("!seq [a]");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testSequenceWithAnchor() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedSequenceStartEvent("blad", null, true, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 7, 7), new Position(0, 8, 8))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(0, 8, 8))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 9, 9))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 9, 9))));
        List events = this.getParse("&blad [a]");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testSequenceWithAnchorAndTag() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedSequenceStartEvent("blad", "!seq", false, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 12, 12), new Position(0, 13, 13))));
        expected.add(new PositionedSequenceEndEvent(new Position.Range(new Position(0, 13, 13))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 14, 14))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 14, 14))));
        List events = this.getParse("&blad !seq [a]");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
        events = this.getParse("!seq &blad [a]");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testMappingWithTag() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedMappingStartEvent(null, "!map", false, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 6, 6), new Position(0, 7, 7))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(0, 9, 9), new Position(0, 10, 10))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(0, 10, 10))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 11, 11))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 11, 11))));
        List events = this.getParse("!map {a: b}");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testMappingWithAnchor() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedMappingStartEvent("blad", null, true, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 7, 7), new Position(0, 8, 8))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(0, 10, 10), new Position(0, 11, 11))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(0, 11, 11))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 12, 12))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 12, 12))));
        List events = this.getParse("&blad {a: b}");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testMappingWithAnchorAndTag() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedMappingStartEvent("blad", "!map", false, true, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 12, 12), new Position(0, 13, 13))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("b"), '\u0000', new Position.Range(new Position(0, 15, 15), new Position(0, 16, 16))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(0, 16, 16))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 17, 17))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 17, 17))));
        List events = this.getParse("&blad !map {a: b}");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
        events = this.getParse("!map &blad {a: b}");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testLiteralScalar() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{false, true}, this.s("abc\nfoobar"), '|', new Position.Range(new Position(0, 0, 0), new Position(2, 7, 14))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(2, 7, 14))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(2, 7, 14))));
        List events = this.getParse("|\n abc\n foobar");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testFoldedScalar() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{false, true}, this.s("abc foobar"), '>', new Position.Range(new Position(0, 0, 0), new Position(2, 7, 14))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(2, 7, 14))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(2, 7, 14))));
        List events = this.getParse(">\n abc\n foobar");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testSingleQuotedScalar() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{false, true}, this.s("abc"), '\'', new Position.Range(new Position(0, 0, 0), new Position(0, 5, 5))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(0, 5, 5))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(0, 5, 5))));
        List events = this.getParse("'abc'");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testParserExceptionIncludesPositioningInformation() throws Exception {
        try {
            this.getParse("*foobar bla");
            PositioningParserImplTest.assertTrue((String)"parsing should throw an exception", (boolean)false);
        }
        catch (ParserException e) {
            PositioningParserImplTest.assertTrue((String)"Exception should be instance of PositionedParserException", (boolean)(e instanceof PositionedParserException));
            PositioningParserImplTest.assertEquals((String)"Position should be correct for exception", (Object)new Position.Range(new Position(0, 8, 8), new Position(0, 11, 11)), (Object)((PositionedParserException)e).getRange());
        }
    }

    public void testCommentBeforeSecondKeyWithBlankFirst() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedMappingStartEvent(null, null, true, false, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s(""), '\u0000', new Position.Range(new Position(0, 2, 2), new Position(0, 2, 2))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("c"), '\u0000', new Position.Range(new Position(2, 0, 9), new Position(2, 1, 10))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("d"), '\u0000', new Position.Range(new Position(2, 3, 12), new Position(2, 4, 13))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(2, 4, 13))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(2, 4, 13))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(2, 4, 13))));
        List events = this.getParse("a: \n#foo\nc: d");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }

    public void testCommentBeforeSecondKeyWithBlankFirstAndSomeMore() throws Exception {
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add(new PositionedStreamStartEvent(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartEvent(false, new int[]{1, 1}, null, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedMappingStartEvent(null, null, true, false, new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("foo"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 3, 3))));
        expected.add(new PositionedMappingStartEvent(null, null, true, false, new Position.Range(new Position(1, 2, 7))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("inner"), '\u0000', new Position.Range(new Position(1, 2, 7), new Position(1, 7, 12))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("val"), '\u0000', new Position.Range(new Position(1, 9, 14), new Position(1, 12, 17))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(1, 12, 17))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("bar"), '\u0000', new Position.Range(new Position(4, 0, 27), new Position(4, 3, 30))));
        expected.add(new PositionedScalarEvent(null, null, new boolean[]{true, false}, this.s("baz"), '\u0000', new Position.Range(new Position(4, 5, 32), new Position(4, 8, 35))));
        expected.add(new PositionedMappingEndEvent(new Position.Range(new Position(4, 8, 35))));
        expected.add(new PositionedDocumentEndEvent(false, new Position.Range(new Position(4, 8, 35))));
        expected.add(new PositionedStreamEndEvent(new Position.Range(new Position(4, 8, 35))));
        List events = this.getParse("foo:\n  inner: val\n\n# Hello\nbar: baz");
        PositioningParserImplTest.assertEquals(expected, (Object)events);
    }
}

