/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.netbeans.modules.print.ui.Editor;
import org.netbeans.modules.print.ui.Preview;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.Macro;
import org.netbeans.modules.print.util.Percent;
import org.netbeans.modules.print.util.UI;
import org.openide.DialogDescriptor;

final class Attribute
extends UI.Dialog
implements Macro.Listener,
Percent.Listener {
    private JCheckBox myHeader;
    private JTextField myHeaderLeft;
    private JTextField myHeaderCenter;
    private JTextField myHeaderRight;
    private JButton myHeaderFont;
    private JButton myHeaderColor;
    private Color myHeaderColorValue;
    private Font myHeaderFontValue;
    private JCheckBox myFooter;
    private DialogDescriptor myDescriptor;
    private JTextField myFooterLeft;
    private JTextField myFooterCenter;
    private JTextField myFooterRight;
    private JButton myFooterFont;
    private JButton myFooterColor;
    private Color myFooterColorValue;
    private Font myFooterFontValue;
    private JCheckBox myBorder;
    private JButton myBorderColor;
    private Color myBorderColorValue;
    private JCheckBox myLineNumbers;
    private JCheckBox myWrapLines;
    private JCheckBox myUseFont;
    private JCheckBox myUseColor;
    private JButton myTextFont;
    private JButton myTextColor;
    private JButton myBackgroundColor;
    private JSpinner myLineSpacing;
    private Font myTextFontValue;
    private Color myTextColorValue;
    private Color myBackgroundColorValue;
    private JCheckBox mySelection;
    private JCheckBox myAsEditor;
    private JLabel myTextFontColorLabel;
    private JLabel myBackgroundColorLabel;
    private JLabel myLineSpacingLabel;
    private Percent myZoomFactor;
    private JTextField myZoomWidth;
    private JTextField myZoomHeight;
    private JRadioButton myFitToPage;
    private Preview myPreview;
    private JTextField myLastField;
    private static final int TEXT_WIDTH = 30;
    private static final int FIELD_WIDTH = 136;
    private static final int MACROS_WIDTH = 41;
    private static final int MAX_PAGE_NUBER = 32;
    private static final int MAX_HEADER_LENGTH = 100;
    private static final int MAX_FOOTER_LENGTH = 100;
    private static final double SPACING_MIN = 0.1;
    private static final double SPACING_MAX = 10.0;
    private static final double SPACING_STEP = 0.1;
    private static final int[] PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 200, 300, 500};

    Attribute(Preview preview) {
        this.myPreview = preview;
        this.myBorderColorValue = Config.getDefault().getBorderColor();
        this.myTextColorValue = Config.getDefault().getTextColor();
        this.myTextFontValue = Config.getDefault().getTextFont();
        this.myBackgroundColorValue = Config.getDefault().getBackgroundColor();
        this.myHeaderColorValue = Config.getDefault().getHeaderColor();
        this.myHeaderFontValue = Config.getDefault().getHeaderFont();
        this.myFooterColorValue = Config.getDefault().getFooterColor();
        this.myFooterFontValue = Config.getDefault().getFooterFont();
    }

    @Override
    public void invalidValue(String value) {
        UI.printError(this.i18n("ERR_Zoom_Value_Is_Invalid"));
    }

    @Override
    protected DialogDescriptor createDescriptor() {
        this.myDescriptor = new DialogDescriptor((Object)UI.getResizableX(this.createPanel()), this.i18n("LBL_Print_Options"), true, this.getButtons(), DialogDescriptor.OK_OPTION, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (DialogDescriptor.OK_OPTION == event.getSource()) {
                    if (Attribute.this.updatePreview()) {
                        Attribute.this.myDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
                    } else {
                        Attribute.this.myDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
                    }
                }
            }
        });
        return this.myDescriptor;
    }

    private Object[] getButtons() {
        return new Object[]{DialogDescriptor.OK_OPTION, UI.createButton(new UI.ButtonAction(this.i18n("LBL_Apply"), this.i18n("TLT_Apply")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.updatePreview();
            }
        }), DialogDescriptor.CANCEL_OPTION};
    }

    private boolean updatePreview() {
        int zoomHeight;
        int zoomWidth = UI.getInt(this.myZoomWidth.getText());
        if (!this.checkValue(zoomWidth, zoomHeight = UI.getInt(this.myZoomHeight.getText()))) {
            return false;
        }
        Config.getDefault().setBorder(this.myBorder.isSelected());
        Config.getDefault().setBorderColor(this.myBorderColorValue);
        Config.getDefault().setHeader(this.myHeader.isSelected());
        Config.getDefault().setHeaderLeft(this.myHeaderLeft.getText());
        Config.getDefault().setHeaderCenter(this.myHeaderCenter.getText());
        Config.getDefault().setHeaderRight(this.myHeaderRight.getText());
        Config.getDefault().setHeaderColor(this.myHeaderColorValue);
        Config.getDefault().setHeaderFont(this.myHeaderFontValue);
        Config.getDefault().setFooter(this.myFooter.isSelected());
        Config.getDefault().setFooterLeft(this.myFooterLeft.getText());
        Config.getDefault().setFooterCenter(this.myFooterCenter.getText());
        Config.getDefault().setFooterRight(this.myFooterRight.getText());
        Config.getDefault().setFooterColor(this.myFooterColorValue);
        Config.getDefault().setFooterFont(this.myFooterFontValue);
        Config.getDefault().setWrapLines(this.myWrapLines.isSelected());
        Config.getDefault().setLineNumbers(this.myLineNumbers.isSelected());
        Config.getDefault().setUseFont(this.myUseFont.isSelected());
        Config.getDefault().setUseColor(this.myUseColor.isSelected());
        Config.getDefault().setTextColor(this.myTextColorValue);
        Config.getDefault().setTextFont(this.myTextFontValue);
        Config.getDefault().setBackgroundColor(this.myBackgroundColorValue);
        Config.getDefault().setLineSpacing(this.getDouble(this.myLineSpacing.getValue()));
        Config.getDefault().setSelection(this.mySelection.isSelected());
        Config.getDefault().setAsEditor(this.myAsEditor.isSelected());
        double zoom = 0.0;
        if (this.myZoomFactor.isEnabled()) {
            zoom = this.myZoomFactor.getValue();
        } else if (this.myZoomWidth.isEnabled()) {
            zoom = Percent.createZoomWidth(zoomWidth);
        } else if (this.myZoomHeight.isEnabled()) {
            zoom = Percent.createZoomHeight(zoomHeight);
        } else if (this.myFitToPage.isSelected()) {
            zoom = 0.0;
        }
        Config.getDefault().setZoom(zoom);
        this.myPreview.updated();
        return true;
    }

    private boolean checkValue(int zoomWidth, int zoomHeight) {
        if (this.myHeaderFontValue.getSize() > 100) {
            UI.printError(this.i18n("ERR_Header_Size_Is_Too_Big"));
            return false;
        }
        if (this.myFooterFontValue.getSize() > 100) {
            UI.printError(this.i18n("ERR_Footer_Size_Is_Too_Big"));
            return false;
        }
        if (zoomWidth <= 0 || zoomHeight <= 0) {
            UI.printError(this.i18n("ERR_Page_Number_Is_Invalid"));
            return false;
        }
        if (zoomWidth > 32 || zoomHeight > 32) {
            UI.printError(this.i18n("ERR_Page_Number_Is_Too_Big"));
            return false;
        }
        return true;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        this.createSection(this.getBorderSection(), "LBL_Border", panel, c);
        this.createSection(this.getTitleSection(), "LBL_Header_Footer", panel, c);
        this.createSection(this.getTextSection(), "LBL_Text", panel, c);
        this.createSection(this.getZoomSection(), "LBL_Zoom", panel, c);
        this.updateControl();
        return panel;
    }

    private void createSection(JPanel section, String key, JPanel panel, GridBagConstraints c) {
        c.insets = new Insets(2, 0, 0, 0);
        panel.add((Component)UI.createSeparator(this.i18n(key)), c);
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)section, c);
        c.insets = new Insets(0, 0, 0, 0);
    }

    private JPanel getBorderSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.myBorder = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Print_Border")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.myBorderColor.setEnabled(Attribute.this.myBorder.isSelected());
            }
        });
        panel.add((Component)this.myBorder, c);
        c.weightx = 1.0;
        c.insets = new Insets(0, 8, 2, 0);
        this.myBorderColor = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "color"), this.i18n("TLT_Border_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.borderColor();
            }
        });
        panel.add((Component)this.myBorderColor, c);
        return panel;
    }

    private JPanel getTitleSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.setLabelPanel(panel, c);
        this.setHeaderPanel(panel, c);
        this.setFooterPanel(panel, c);
        this.setMacroPanel(panel, c);
        return panel;
    }

    private void setLabelPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.anchor = 10;
        c.insets = new Insets(0, 8, 2, 0);
        panel.add((Component)new JLabel(), c);
        panel.add((Component)UI.createLabel(this.i18n("LBL_Left")), c);
        panel.add((Component)UI.createLabel(this.i18n("LBL_Center")), c);
        panel.add((Component)UI.createLabel(this.i18n("LBL_Right")), c);
    }

    private void setHeaderPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        this.myHeader = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Print_Header")){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean enabled = Attribute.this.myHeader.isSelected();
                Attribute.this.myHeaderLeft.setEnabled(enabled);
                Attribute.this.myHeaderCenter.setEnabled(enabled);
                Attribute.this.myHeaderRight.setEnabled(enabled);
                Attribute.this.myHeaderColor.setEnabled(enabled);
                Attribute.this.myHeaderFont.setEnabled(enabled);
            }
        });
        panel.add((Component)this.myHeader, c);
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 8, 2, 0);
        this.myHeaderLeft = new JTextField();
        UI.setWidth(this.myHeaderLeft, 136);
        panel.add((Component)this.myHeaderLeft, c);
        this.myLastField = this.myHeaderLeft;
        this.myHeaderCenter = new JTextField();
        UI.setWidth(this.myHeaderCenter, 136);
        panel.add((Component)this.myHeaderCenter, c);
        this.myHeaderRight = new JTextField();
        UI.setWidth(this.myHeaderRight, 136);
        panel.add((Component)this.myHeaderRight, c);
        c.weightx = 0.0;
        c.fill = 0;
        this.myHeaderColor = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "color"), this.i18n("TLT_Header_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.headerColor();
            }
        });
        panel.add((Component)this.myHeaderColor, c);
        this.myHeaderFont = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "font"), this.i18n("TLT_Header_Font")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.headerFont();
            }
        });
        panel.add((Component)this.myHeaderFont, c);
    }

    private void setFooterPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        this.myFooter = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Print_Footer")){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean enabled = Attribute.this.myFooter.isSelected();
                Attribute.this.myFooterLeft.setEnabled(enabled);
                Attribute.this.myFooterCenter.setEnabled(enabled);
                Attribute.this.myFooterRight.setEnabled(enabled);
                Attribute.this.myFooterColor.setEnabled(enabled);
                Attribute.this.myFooterFont.setEnabled(enabled);
            }
        });
        panel.add((Component)this.myFooter, c);
        c.weightx = 1.0;
        c.insets = new Insets(0, 8, 2, 0);
        c.fill = 2;
        this.myFooterLeft = new JTextField();
        UI.setWidth(this.myFooterLeft, 136);
        panel.add((Component)this.myFooterLeft, c);
        this.myFooterCenter = new JTextField();
        UI.setWidth(this.myFooterCenter, 136);
        panel.add((Component)this.myFooterCenter, c);
        this.myFooterRight = new JTextField();
        UI.setWidth(this.myFooterRight, 136);
        panel.add((Component)this.myFooterRight, c);
        c.weightx = 0.0;
        c.fill = 0;
        this.myFooterColor = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "color"), this.i18n("TLT_Footer_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.footerColor();
            }
        });
        panel.add((Component)this.myFooterColor, c);
        this.myFooterFont = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "font"), this.i18n("TLT_Footer_Font")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.footerFont();
            }
        });
        panel.add((Component)this.myFooterFont, c);
    }

    private void setMacroPanel(JPanel panel, GridBagConstraints c) {
        JPanel p = new JPanel(new GridBagLayout());
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        panel.add((Component)UI.createLabel(this.i18n("LBL_Insert_Macros")), c);
        c.anchor = 10;
        for (Macro macro : Macro.values()) {
            JButton button = macro.getButton(this);
            UI.setWidth(button, 41);
            p.add((Component)button, c);
        }
        c.weightx = 1.0;
        c.insets = new Insets(8, 8, 2, 0);
        c.gridwidth = 3;
        panel.add((Component)p, c);
        c.gridwidth = 1;
    }

    @Override
    public void pressed(Macro macro) {
        JTextField focusable = this.getFocusableTextField();
        if (focusable == null) {
            this.myLastField.requestFocus();
        } else {
            this.myLastField = focusable;
        }
        String text = this.myLastField.getText();
        String head = text.substring(0, this.myLastField.getSelectionStart());
        String tail = text.substring(this.myLastField.getSelectionEnd(), text.length());
        this.myLastField.setText(head + macro.getName() + tail);
    }

    private JTextField getFocusableTextField() {
        if (this.myHeaderLeft.hasFocus()) {
            return this.myHeaderLeft;
        }
        if (this.myHeaderCenter.hasFocus()) {
            return this.myHeaderCenter;
        }
        if (this.myHeaderRight.hasFocus()) {
            return this.myHeaderRight;
        }
        if (this.myFooterLeft.hasFocus()) {
            return this.myFooterLeft;
        }
        if (this.myFooterCenter.hasFocus()) {
            return this.myFooterCenter;
        }
        if (this.myFooterRight.hasFocus()) {
            return this.myFooterRight;
        }
        return null;
    }

    private JPanel getTextSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.createTopTextPanel(panel, c);
        this.createBottomTextPanel(panel, c);
        return panel;
    }

    private void createTopTextPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        this.myLineNumbers = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Line_Numbers")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.myLineNumbers, c);
        this.myUseColor = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Use_Color"), this.i18n("TLT_Use_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.myUseColor, c);
        this.myTextFontColorLabel = UI.createLabel(this.i18n("LBL_Text_Font_and_Color"));
        panel.add((Component)this.myTextFontColorLabel, c);
        c.insets = new Insets(0, 8, 2, 0);
        this.myTextColor = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "color"), this.i18n("TLT_Text_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.textColor();
            }
        });
        panel.add((Component)this.myTextColor, c);
        this.myTextFont = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "font"), this.i18n("TLT_Text_Font")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.textFont();
            }
        });
        panel.add((Component)this.myTextFont, c);
    }

    private void createBottomTextPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        this.myWrapLines = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Wrap_Lines")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.myWrapLines, c);
        this.myUseFont = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Use_Font"), this.i18n("TLT_Use_Font")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.myUseFont, c);
        c.anchor = 13;
        c.insets = new Insets(2, 8, 2, 0);
        this.myBackgroundColorLabel = UI.createLabel(this.i18n("LBL_Background_Color"));
        panel.add((Component)this.myBackgroundColorLabel, c);
        c.anchor = 17;
        c.insets = new Insets(0, 8, 2, 0);
        this.myBackgroundColor = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "color"), this.i18n("TLT_Background_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Attribute.this.backgroundColor();
            }
        });
        panel.add((Component)this.myBackgroundColor, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.myAsEditor = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_As_Editor"), this.i18n("TLT_As_Editor")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        this.myAsEditor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Attribute.this.updateText();
            }
        });
        panel.add((Component)this.myAsEditor, c);
        this.mySelection = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Selection"), this.i18n("TLT_Selection")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.mySelection, c);
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(2, 8, 2, 0);
        this.myLineSpacingLabel = UI.createLabel(this.i18n("LBL_Line_Spacing"));
        panel.add((Component)this.myLineSpacingLabel, c);
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 8, 2, 0);
        double value = Config.getDefault().getLineSpacing();
        if (value < 0.0) {
            value = 1.0;
        }
        this.myLineSpacing = new JSpinner(new SpinnerNumberModel(value, 0.1, 10.0, 0.1));
        Dimension size = new Dimension(this.myLineSpacing.getPreferredSize().width, this.myTextColor.getPreferredSize().height);
        UI.setSize(this.myLineSpacing, size);
        this.myLineSpacingLabel.setLabelFor(this.myLineSpacing);
        panel.add((Component)this.myLineSpacing, c);
    }

    private JPanel getZoomSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        ButtonGroup group = new ButtonGroup();
        double zoom = Config.getDefault().getZoom();
        c.anchor = 17;
        ++c.gridy;
        c.insets = new Insets(8, 0, 0, 0);
        JRadioButton buttonWidth = UI.createRadioButton(this.i18n("LBL_Fit_Width_to"), this.i18n("TLT_Fit_Width_to"));
        buttonWidth.addItemListener(this.createItemListener(true, false, false));
        panel.add((Component)buttonWidth, c);
        group.add(buttonWidth);
        c.insets = new Insets(8, 8, 2, 0);
        this.myZoomWidth = new JTextField(this.getString(Percent.getZoomWidth(zoom, 1)));
        UI.setWidth(this.myZoomWidth, 30);
        panel.add((Component)this.myZoomWidth, c);
        c.weightx = 1.0;
        panel.add((Component)UI.createLabel(this.i18n("LBL_Pages")), c);
        c.weightx = 0.0;
        c.insets = new Insets(8, 0, 0, 0);
        JRadioButton buttonFactor = UI.createRadioButton(this.i18n("LBL_Zoom_to"), this.i18n("TLT_Zoom_to"));
        buttonFactor.addItemListener(this.createItemListener(false, false, true));
        panel.add((Component)buttonFactor, c);
        group.add(buttonFactor);
        c.insets = new Insets(8, 8, 2, 0);
        this.myZoomFactor = new Percent(this, Percent.getZoomFactor(zoom, 1.0), PERCENTS, 0, null, this.i18n("TLT_Print_Zoom"));
        panel.add((Component)this.myZoomFactor, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.insets = new Insets(8, 0, 0, 0);
        JRadioButton buttonHeight = UI.createRadioButton(this.i18n("LBL_Fit_Height_to"), this.i18n("TLT_Fit_Height_to"));
        buttonHeight.addItemListener(this.createItemListener(false, true, false));
        panel.add((Component)buttonHeight, c);
        group.add(buttonHeight);
        c.insets = new Insets(8, 8, 2, 0);
        this.myZoomHeight = new JTextField(this.getString(Percent.getZoomHeight(zoom, 1)));
        UI.setWidth(this.myZoomHeight, 30);
        panel.add((Component)this.myZoomHeight, c);
        panel.add((Component)UI.createLabel(this.i18n("LBL_Pages")), c);
        c.weightx = 0.0;
        c.insets = new Insets(8, 0, 0, 0);
        this.myFitToPage = UI.createRadioButton(this.i18n("LBL_Fit_to_Page"), this.i18n("TLT_Fit_to_Page"));
        this.myFitToPage.addItemListener(this.createItemListener(false, false, false));
        panel.add((Component)this.myFitToPage, c);
        group.add(this.myFitToPage);
        buttonFactor.setSelected(Percent.isZoomFactor(zoom));
        buttonWidth.setSelected(Percent.isZoomWidth(zoom));
        buttonHeight.setSelected(Percent.isZoomHeight(zoom));
        this.myFitToPage.setSelected(Percent.isZoomPage(zoom));
        return panel;
    }

    private ItemListener createItemListener(final boolean width, final boolean height, final boolean factor) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (Attribute.this.myZoomWidth != null) {
                    Attribute.this.myZoomWidth.setEnabled(width);
                }
                if (Attribute.this.myZoomHeight != null) {
                    Attribute.this.myZoomHeight.setEnabled(height);
                }
                if (Attribute.this.myZoomFactor != null) {
                    Attribute.this.myZoomFactor.setEnabled(factor);
                }
            }
        };
    }

    private void updateAttribute() {
    }

    private void updateText() {
        boolean enabled = !this.myAsEditor.isSelected();
        this.mySelection.setEnabled(enabled);
        this.myWrapLines.setEnabled(enabled);
        this.myUseColor.setEnabled(enabled);
        this.myUseFont.setEnabled(enabled);
        this.myTextFont.setEnabled(enabled);
        this.myTextColor.setEnabled(enabled);
        this.myTextFontColorLabel.setEnabled(enabled);
        this.myBackgroundColor.setEnabled(enabled);
        this.myBackgroundColorLabel.setEnabled(enabled);
        this.myLineSpacing.setEnabled(enabled);
        this.myLineSpacingLabel.setEnabled(enabled);
    }

    private String getString(int value) {
        if (value < 0) {
            return Integer.toString(-value);
        }
        return Integer.toString(value);
    }

    private void headerFont() {
        Font font = this.font(this.myHeaderFontValue);
        if (font != null) {
            this.myHeaderFontValue = font;
        }
    }

    private void footerFont() {
        Font font = this.font(this.myFooterFontValue);
        if (font != null) {
            this.myFooterFontValue = font;
        }
    }

    private void textFont() {
        Font font = this.font(this.myTextFontValue);
        if (font != null) {
            this.myTextFontValue = font;
        }
    }

    private Font font(Font font) {
        return (Font)new Editor(Font.class, this.i18n("LBL_Choose_Font"), font).getValue();
    }

    private void borderColor() {
        Color color = this.color(this.myBorderColorValue);
        if (color != null) {
            this.myBorderColorValue = color;
        }
    }

    private void headerColor() {
        Color color = this.color(this.myHeaderColorValue);
        if (color != null) {
            this.myHeaderColorValue = color;
        }
    }

    private void footerColor() {
        Color color = this.color(this.myFooterColorValue);
        if (color != null) {
            this.myFooterColorValue = color;
        }
    }

    private void textColor() {
        Color color = this.color(this.myTextColorValue);
        if (color != null) {
            this.myTextColorValue = color;
        }
    }

    private void backgroundColor() {
        Color color = this.color(this.myBackgroundColorValue);
        if (color != null) {
            this.myBackgroundColorValue = color;
        }
    }

    private Color color(Color color) {
        return (Color)new Editor(Color.class, this.i18n("LBL_Choose_Color"), color).getValue();
    }

    private void updateControl() {
        this.myBorder.setSelected(Config.getDefault().hasBorder());
        this.myBorderColor.setEnabled(Config.getDefault().hasBorder());
        this.myHeader.setSelected(Config.getDefault().hasHeader());
        this.myHeaderLeft.setText(Config.getDefault().getHeaderLeft());
        this.myHeaderLeft.setEnabled(Config.getDefault().hasHeader());
        this.myHeaderCenter.setText(Config.getDefault().getHeaderCenter());
        this.myHeaderCenter.setEnabled(Config.getDefault().hasHeader());
        this.myHeaderRight.setText(Config.getDefault().getHeaderRight());
        this.myHeaderRight.setEnabled(Config.getDefault().hasHeader());
        this.myHeaderColor.setEnabled(Config.getDefault().hasHeader());
        this.myHeaderFont.setEnabled(Config.getDefault().hasHeader());
        this.myFooter.setSelected(Config.getDefault().hasFooter());
        this.myFooterLeft.setText(Config.getDefault().getFooterLeft());
        this.myFooterLeft.setEnabled(Config.getDefault().hasFooter());
        this.myFooterCenter.setText(Config.getDefault().getFooterCenter());
        this.myFooterCenter.setEnabled(Config.getDefault().hasFooter());
        this.myFooterRight.setText(Config.getDefault().getFooterRight());
        this.myFooterRight.setEnabled(Config.getDefault().hasFooter());
        this.myFooterColor.setEnabled(Config.getDefault().hasFooter());
        this.myFooterFont.setEnabled(Config.getDefault().hasFooter());
        this.myLineNumbers.setSelected(Config.getDefault().isLineNumbers());
        this.myWrapLines.setSelected(Config.getDefault().isWrapLines());
        this.myUseFont.setSelected(Config.getDefault().isUseFont());
        this.myUseColor.setSelected(Config.getDefault().isUseColor());
        this.mySelection.setSelected(Config.getDefault().isSelection());
        this.myAsEditor.setSelected(Config.getDefault().isAsEditor());
        this.updateText();
    }

    @Override
    protected void opened() {
        this.myHeaderLeft.requestFocus();
    }

    @Override
    public double getCustomValue(int index) {
        return 0.0;
    }

    @Override
    public void valueChanged(double value, int index) {
    }

    private double getDouble(Object value) {
        if (!(value instanceof Double)) {
            return -1.0;
        }
        return (Double)value;
    }
}

