/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.ui.RSEUIPlugin;

public class RemoteFileEncodingManager {
    private static RemoteFileEncodingManager instance;
    private static final String ENCODINGS_DIR = "encodings";
    private static final String ENCODINGS_PROPERTIES_FILE = "encodings.properties";
    private boolean isLoaded;
    private HashMap hostMap;

    private RemoteFileEncodingManager() {
        this.init();
    }

    private void init() {
        this.isLoaded = false;
        this.hostMap = new HashMap();
    }

    public static final RemoteFileEncodingManager getInstance() {
        if (instance == null) {
            instance = new RemoteFileEncodingManager();
        }
        return instance;
    }

    public String getEncoding(String hostname, String remotePath) {
        if (!this.isLoaded) {
            this.load();
        }
        if (this.isLoaded) {
            Properties props = (Properties)this.hostMap.get(hostname);
            if (props == null) {
                return null;
            }
            String encoding = props.getProperty(remotePath);
            return encoding;
        }
        return null;
    }

    public void setEncoding(String hostname, String remotePath, String encoding) {
        if (!this.isLoaded) {
            this.load();
        }
        if (this.isLoaded) {
            Properties props = null;
            if (this.hostMap.containsKey(hostname)) {
                props = (Properties)this.hostMap.get(hostname);
            } else if (encoding != null) {
                props = new Properties();
            }
            if (props != null) {
                if (encoding == null) {
                    props.remove(remotePath);
                } else {
                    props.setProperty(remotePath, encoding);
                    this.hostMap.put(hostname, props);
                }
                this.save();
            }
        }
    }

    public void load() {
        if (!this.isLoaded) {
            IPath encodingsLocation = this.getEncodingLocation();
            File file = encodingsLocation.toFile();
            if (file.exists() && file.isDirectory()) {
                File[] hosts = file.listFiles();
                int i = 0;
                while (i < hosts.length) {
                    if (hosts[i].exists() && hosts[i].isDirectory()) {
                        Path encodingsFilePath = new Path(hosts[i].getAbsolutePath());
                        if (!encodingsFilePath.hasTrailingSeparator()) {
                            encodingsFilePath.addTrailingSeparator();
                        }
                        encodingsFilePath = encodingsFilePath.append(ENCODINGS_PROPERTIES_FILE);
                        File encodingsFile = (encodingsFilePath = encodingsFilePath.makeAbsolute()).toFile();
                        if (encodingsFile.exists()) {
                            Properties props = new Properties();
                            FileInputStream inputStream = null;
                            try {
                                inputStream = new FileInputStream(encodingsFile);
                                props.load(inputStream);
                                this.hostMap.put(hosts[i].getName(), props);
                            }
                            catch (FileNotFoundException e) {
                                RSEUIPlugin.logError((String)("File " + encodingsFilePath.toOSString() + " could not be found"), (Throwable)e);
                            }
                            catch (IOException e) {
                                RSEUIPlugin.logError((String)("I/O problems reading file " + encodingsFilePath.toOSString()), (Throwable)e);
                            }
                        }
                    }
                    ++i;
                }
            }
            this.isLoaded = true;
        }
    }

    public void save() {
        Set hosts = this.hostMap.keySet();
        if (hosts != null && !hosts.isEmpty()) {
            IPath encodingsLocation = this.getEncodingLocation();
            File file = encodingsLocation.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            if (file.exists() && file.isDirectory()) {
                for (String hostname : hosts) {
                    Path hostDirPath = new Path(encodingsLocation.toOSString());
                    if (!hostDirPath.hasTrailingSeparator()) {
                        hostDirPath.addTrailingSeparator();
                    }
                    hostDirPath = hostDirPath.append(hostname);
                    hostDirPath.makeAbsolute();
                    File hostDir = hostDirPath.toFile();
                    Properties props = (Properties)this.hostMap.get(hostname);
                    if (props != null && !props.isEmpty()) {
                        if (!hostDir.exists()) {
                            hostDir.mkdirs();
                        }
                        if (!hostDir.exists() || !hostDir.isDirectory()) continue;
                        Path encodingsFilePath = new Path(hostDirPath.toOSString());
                        encodingsFilePath = encodingsFilePath.append(ENCODINGS_PROPERTIES_FILE);
                        File encodingsFile = (encodingsFilePath = encodingsFilePath.makeAbsolute()).toFile();
                        if (!encodingsFile.exists()) {
                            boolean created = false;
                            try {
                                created = encodingsFile.createNewFile();
                            }
                            catch (IOException e) {
                                RSEUIPlugin.logError((String)("I/O error when trying to create encodings file " + encodingsFilePath.toOSString()), (Throwable)e);
                                created = false;
                            }
                            if (!created) continue;
                        }
                        FileOutputStream outStream = null;
                        try {
                            outStream = new FileOutputStream(encodingsFile);
                            props.store(outStream, null);
                        }
                        catch (FileNotFoundException e) {
                            RSEUIPlugin.logError((String)("File " + encodingsFilePath + " could not be found"), (Throwable)e);
                        }
                        catch (IOException e) {
                            RSEUIPlugin.logError((String)("I/O problems writing to file " + encodingsFilePath), (Throwable)e);
                        }
                        continue;
                    }
                    if (!hostDir.exists()) continue;
                    hostDir.delete();
                }
            }
        }
    }

    private IPath getEncodingLocation() {
        IPath location = RSEUIPlugin.getDefault().getStateLocation();
        location = location.append(ENCODINGS_DIR);
        location = location.makeAbsolute();
        return location;
    }
}

