/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.wtp.DeploymentDescriptorManagement;
import org.eclipse.m2e.wtp.EarPluginConfiguration;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.earmodules.EarModule;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.filesystem.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class MavenDeploymentDescriptorManagement
implements DeploymentDescriptorManagement {
    private static final VersionRange VALID_EAR_PLUGIN_RANGE;
    private static final IOverwriteQuery OVERWRITE_ALL_QUERY;

    static {
        try {
            VALID_EAR_PLUGIN_RANGE = VersionRange.createFromVersionSpec((String)"[2.4.3,)");
        }
        catch (InvalidVersionSpecificationException ex) {
            throw new RuntimeException("Unable to create ear plugin version range from [2.4.3,)", ex);
        }
        OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                return "ALL";
            }
        };
    }

    @Override
    public void updateConfiguration(IProject project, MavenProject mavenProject, EarPluginConfiguration plugin, boolean useBuildDirectory, IProgressMonitor monitor) throws CoreException {
        IFolder targetFolder;
        File tempDirectory;
        IFile pomResource;
        MavenExecutionRequest request;
        MavenSession session;
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade mavenFacade = projectManager.getProject(project);
        IMaven maven = MavenPlugin.getMaven();
        MavenExecutionPlan executionPlan = maven.calculateExecutionPlan(session = maven.createSession(request = projectManager.createExecutionRequest(pomResource = project.getFile("pom.xml"), mavenFacade.getResolverConfiguration(), monitor), mavenProject), mavenProject, Collections.singletonList("ear:generate-application-xml"), true, monitor);
        MojoExecution genConfigMojo = this.getExecution(executionPlan, "maven-ear-plugin", "generate-application-xml");
        if (genConfigMojo == null) {
            return;
        }
        Xpp3Dom configuration = genConfigMojo.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
            genConfigMojo.setConfiguration(configuration);
        }
        try {
            tempDirectory = this.getTempDirectory();
        }
        catch (IOException ex) {
            Status status = new Status(4, "org.eclipse.m2e.wtp", ex.getLocalizedMessage(), (Throwable)ex);
            throw new CoreException((IStatus)status);
        }
        File generatedDescriptorLocation = new File(tempDirectory, "generatedDescriptorLocation");
        File workDirectory = new File(tempDirectory, "workDirectory");
        Xpp3Dom workDirectoryDom = configuration.getChild("workDirectory");
        if (workDirectoryDom == null) {
            workDirectoryDom = new Xpp3Dom("workDirectory");
            configuration.addChild(workDirectoryDom);
        }
        workDirectoryDom.setValue(workDirectory.getAbsolutePath());
        Xpp3Dom genDescriptorLocationDom = configuration.getChild("generatedDescriptorLocation");
        if (genDescriptorLocationDom == null) {
            genDescriptorLocationDom = new Xpp3Dom("generatedDescriptorLocation");
            configuration.addChild(genDescriptorLocationDom);
        }
        genDescriptorLocationDom.setValue(generatedDescriptorLocation.getAbsolutePath());
        if (!VALID_EAR_PLUGIN_RANGE.containsVersion((ArtifactVersion)new DefaultArtifactVersion(genConfigMojo.getVersion()))) {
            this.overrideModules(configuration, plugin.getAllEarModules());
        }
        maven.execute(session, genConfigMojo, monitor);
        if (session.getResult().hasExceptions()) {
            IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
            markerManager.addMarkers((IResource)mavenFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.wtp.filteringError", session.getResult());
        }
        File[] files = generatedDescriptorLocation.listFiles();
        IFolder earResourcesFolder = this.getEarResourcesDir(project, mavenProject, monitor);
        if (useBuildDirectory) {
            targetFolder = earResourcesFolder;
        } else {
            targetFolder = project.getFolder(plugin.getEarContentDirectory(project));
            if (earResourcesFolder.exists() && earResourcesFolder.isAccessible()) {
                earResourcesFolder.delete(true, monitor);
            }
        }
        IFolder metaInfFolder = targetFolder.getFolder("/META-INF/");
        if (files != null && files.length > 0) {
            try {
                ImportOperation op = new ImportOperation(metaInfFolder.getFullPath(), (Object)generatedDescriptorLocation, (IImportStructureProvider)new FileSystemStructureProvider(), OVERWRITE_ALL_QUERY, Arrays.asList(files));
                op.setCreateContainerStructure(false);
                op.setOverwriteResources(true);
                op.run(monitor);
            }
            catch (InvocationTargetException ex) {
                Status status = new Status(4, "org.eclipse.m2e.wtp", 4, ex.getMessage(), (Throwable)ex);
                throw new CoreException((IStatus)status);
            }
            catch (InterruptedException ex) {
                throw new OperationCanceledException(ex.getMessage());
            }
        }
        targetFolder.refreshLocal(2, monitor);
        MavenDeploymentDescriptorManagement.deleteDirectory(generatedDescriptorLocation);
    }

    private IFolder getEarResourcesDir(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        String appResourcesDir = String.valueOf(ProjectUtils.getM2eclipseWtpFolder(mavenProject, project).toPortableString()) + '/' + "ear-resources";
        IFolder appResourcesFolder = project.getFolder(appResourcesDir);
        if (!appResourcesFolder.exists()) {
            ProjectUtils.createFolder(appResourcesFolder, monitor);
        }
        if (!appResourcesFolder.isDerived()) {
            appResourcesFolder.setDerived(true, monitor);
        }
        return appResourcesFolder;
    }

    private void overrideModules(Xpp3Dom configuration, Set<EarModule> earModules) {
        Xpp3Dom modules = configuration.getChild("modules");
        if (modules == null) {
            modules = new Xpp3Dom("modules");
            configuration.addChild(modules);
        }
        while (modules.getChildCount() > 0) {
            modules.removeChild(0);
        }
        for (EarModule earModule : earModules) {
            modules.addChild(earModule.getAsDom());
        }
    }

    private File getTempDirectory() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tempDir, ".mavenDeploymentDescriptorManagement");
        if (dir.exists() && dir.isFile()) {
            if (!dir.delete()) {
                throw new IOException(NLS.bind((String)Messages.MavenDeploymentDescriptorManagement_Error_Deleting_Temp_Folder, (Object)dir.getAbsolutePath()));
            }
            if (!MavenDeploymentDescriptorManagement.deleteDirectory(dir)) {
                throw new IOException(NLS.bind((String)Messages.MavenDeploymentDescriptorManagement_Error_Deleting_Temp_Folder, (Object)dir.getAbsolutePath()));
            }
        }
        dir.mkdir();
        return dir;
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    MavenDeploymentDescriptorManagement.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    private MojoExecution getExecution(MavenExecutionPlan executionPlan, String artifactId, String goal) throws CoreException {
        for (MojoExecution execution : executionPlan.getMojoExecutions()) {
            if (!artifactId.equals(execution.getArtifactId()) || !goal.equals(execution.getGoal())) continue;
            return execution;
        }
        return null;
    }
}

