/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.web.project.facet.WebFragmentFacetInstallDataModelProvider;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFragmentProjectConfigurator
extends AbstractProjectConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(WebFragmentProjectConfigurator.class);

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = request.getMavenProjectFacade();
        IProject project = facade.getProject();
        if (!WTPProjectsUtil.isQualifiedAsWebFragment(facade)) {
            return;
        }
        IMavenMarkerManager mavenMarkerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        try {
            mavenMarkerManager.deleteMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.configuration");
            this.configureWebfragment(facade, monitor);
        }
        catch (CoreException cex) {
            mavenMarkerManager.addErrorMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.configuration", (Exception)((Object)cex));
        }
    }

    private void configureWebfragment(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        IProject project = facade.getProject();
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        ResourceCleaner fileCleaner = new ResourceCleaner(project);
        this.addFoldersToClean(fileCleaner, facade);
        WTPProjectsUtil.removeConflictingFacets(facetedProject, WTPProjectsUtil.WEB_FRAGMENT_3_0, actions);
        try {
            WTPProjectsUtil.installJavaFacet(actions, project, facetedProject);
            if (!WTPProjectsUtil.hasWebFragmentFacet(project)) {
                IDataModel cfg = DataModelFactory.createDataModel((IDataModelProvider)new WebFragmentFacetInstallDataModelProvider());
                cfg.setProperty("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR", (Object)false);
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, WTPProjectsUtil.WEB_FRAGMENT_3_0, (Object)cfg));
            }
            facetedProject.modify(actions, monitor);
            WTPProjectsUtil.removeTestFolderLinks(project, facade.getMavenProject(), monitor, "/");
        }
        finally {
            try {
                fileCleaner.cleanUp();
            }
            catch (CoreException cex) {
                LOG.error(Messages.Error_Cleaning_WTP_Files, (Throwable)cex);
            }
        }
    }

    protected void addFoldersToClean(ResourceCleaner fileCleaner, IMavenProjectFacade facade) {
        IPath p;
        IPath[] iPathArray = facade.getCompileSourceLocations();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(p.append("META-INF/MANIFEST.MF"));
                fileCleaner.addFiles(p.append("META-INF/web-fragment.xml"));
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getResourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(p.append("META-INF/MANIFEST.MF"));
                fileCleaner.addFiles(p.append("META-INF/web-fragment.xml"));
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getTestCompileSourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getTestResourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
    }
}

