/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;

public final class ReferenceResolver {
    private ReferenceResolver() {
    }

    public static void resolveReferences(List references, IProgressMonitor monitor) throws CoreException {
        int refcount = references.size();
        HashMap<String, ArrayList<IReference>> sigtoref = new HashMap<String, ArrayList<IReference>>(refcount);
        ArrayList<IReference> refs = null;
        IReference ref = null;
        String key = null;
        ArrayList<IReference> methodDecls = new ArrayList<IReference>(refcount);
        long start = System.currentTimeMillis();
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            ref = (IReference)iterator.next();
            if (ref.getReferenceKind() == 0x10000000) {
                methodDecls.add(ref);
                continue;
            }
            key = ReferenceResolver.createSignatureKey(ref);
            refs = (ArrayList<IReference>)sigtoref.get(key);
            if (refs == null) {
                refs = new ArrayList<IReference>(20);
                sigtoref.put(key, refs);
            }
            refs.add(ref);
        }
        if (monitor.isCanceled()) {
            return;
        }
        long end = System.currentTimeMillis();
        if (ApiPlugin.DEBUG_REFERENCE_RESOLVER) {
            System.out.println("Reference resolver: split into " + methodDecls.size() + " method overrides and " + sigtoref.size() + " unique references (" + (end - start) + "ms)");
        }
        start = System.currentTimeMillis();
        ReferenceResolver.resolveReferenceSets(sigtoref, monitor);
        end = System.currentTimeMillis();
        if (ApiPlugin.DEBUG_REFERENCE_RESOLVER) {
            System.out.println("Reference resolver: resolved unique references in " + (end - start) + "ms");
        }
        start = System.currentTimeMillis();
        iterator = methodDecls.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            reference.resolve();
        }
        end = System.currentTimeMillis();
        if (ApiPlugin.DEBUG_REFERENCE_RESOLVER) {
            System.out.println("Reference resolver: resolved method overrides in " + (end - start) + "ms");
        }
    }

    private static void resolveReferenceSets(Map map, IProgressMonitor monitor) throws CoreException {
        Iterator iterator = map.values().iterator();
        List refs = null;
        IReference ref = null;
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            refs = (List)iterator.next();
            ref = (IReference)refs.get(0);
            ((Reference)ref).resolve();
            IApiMember resolved = ref.getResolvedReference();
            if (resolved == null) continue;
            Iterator iterator2 = refs.iterator();
            while (iterator2.hasNext()) {
                Reference ref2 = (Reference)iterator2.next();
                ref2.setResolution(resolved);
            }
        }
    }

    private static String createSignatureKey(IReference reference) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(reference.getMember().getApiComponent().getSymbolicName());
        buffer.append("#");
        buffer.append(reference.getReferencedTypeName());
        switch (reference.getReferenceType()) {
            case 2: {
                buffer.append("#");
                buffer.append(reference.getReferencedMemberName());
                break;
            }
            case 3: {
                buffer.append("#");
                buffer.append(reference.getReferencedMemberName());
                buffer.append("#");
                buffer.append(reference.getReferencedSignature());
            }
        }
        return buffer.toString();
    }
}

