/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.scanner;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.pde.api.tools.internal.CompilationUnit;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;

public class TagScanner {
    private static TagScanner fSingleton = null;

    public static final TagScanner newScanner() {
        if (fSingleton == null) {
            fSingleton = new TagScanner();
        }
        return fSingleton;
    }

    private TagScanner() {
    }

    public void scan(ICompilationUnit unit, IApiDescription description, IApiTypeContainer container, IProgressMonitor monitor) throws CoreException {
        this.scan(new CompilationUnit(unit), description, container, unit.getJavaProject().getOptions(true), monitor);
    }

    public void scan(CompilationUnit source, IApiDescription description, IApiTypeContainer container, Map options, IProgressMonitor monitor) throws CoreException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ASTParser parser = ASTParser.newParser((int)4);
        InputStream inputStream = null;
        try {
            try {
                inputStream = source.getInputStream();
                parser.setSource(Util.getInputStreamAsCharArray(inputStream, -1, System.getProperty("file.encoding")));
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Compilation unit source not found: {0}", source.getName()), (Throwable)e));
            }
            catch (IOException e) {
                if (ApiPlugin.DEBUG_TAG_SCANNER) {
                    System.err.println(source.getName());
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Error reading compilation unit: {0}", source.getName()), (Throwable)e));
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        Util.updateMonitor((IProgressMonitor)localmonitor);
        Map loptions = options;
        if (loptions == null) {
            loptions = JavaCore.getOptions();
        }
        loptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(loptions);
        org.eclipse.jdt.core.dom.CompilationUnit cunit = (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST((IProgressMonitor)localmonitor.newChild(1));
        Visitor visitor = new Visitor(description, container);
        cunit.accept((ASTVisitor)visitor);
    }

    static class Visitor
    extends ASTVisitor {
        private IApiDescription fDescription = null;
        private IPackageDescriptor fPackage = Factory.packageDescriptor("");
        private IReferenceTypeDescriptor fType = null;
        private IApiTypeContainer fContainer = null;

        public Visitor(IApiDescription description, IApiTypeContainer container) {
            this.fDescription = description;
            this.fContainer = container;
        }

        private void enterType(SimpleName name) {
            this.fType = this.fType == null ? this.fPackage.getType(name.getFullyQualifiedName()) : this.fType.getType(name.getFullyQualifiedName());
        }

        private void exitType() {
            this.fType = this.fType.getEnclosingType();
        }

        public boolean visit(TypeDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            Javadoc doc = node.getJavadoc();
            if (doc != null) {
                List tags = doc.tags();
                int restrictions = 0;
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    if ("@noreference".equals(tagname)) {
                        restrictions |= 8;
                    }
                    if (node.isInterface()) {
                        if ("@noextend".equals(tagname)) {
                            restrictions |= 2;
                            continue;
                        }
                        if (!"@noimplement".equals(tagname)) continue;
                        restrictions |= 1;
                        continue;
                    }
                    int flags = node.getModifiers();
                    if ("@noextend".equals(tagname) && !Flags.isFinal((int)flags)) {
                        restrictions |= 2;
                        continue;
                    }
                    if (!"@noinstantiate".equals(tagname) || Flags.isAbstract((int)flags)) continue;
                    restrictions |= 4;
                }
                if (restrictions != 0) {
                    this.fDescription.setRestrictions(this.fType, restrictions);
                }
            }
            return true;
        }

        public void endVisit(TypeDeclaration node) {
            if (!this.isNotVisible(node.getModifiers())) {
                this.exitType();
            }
        }

        public void endVisit(AnnotationTypeDeclaration node) {
            if (!this.isNotVisible(node.getModifiers())) {
                this.exitType();
            }
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            Javadoc doc = node.getJavadoc();
            if (doc != null) {
                List tags = doc.tags();
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname) || !"@noreference".equals(tagname)) continue;
                    this.fDescription.setRestrictions(this.fType, 8);
                }
            }
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            Javadoc doc = node.getJavadoc();
            if (doc != null) {
                List tags = doc.tags();
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname) || !"@noreference".equals(tagname)) continue;
                    this.fDescription.setRestrictions(this.fType, 8);
                }
            }
            return true;
        }

        public void endVisit(EnumDeclaration node) {
            if (!this.isNotVisible(node.getModifiers())) {
                this.exitType();
            }
        }

        public boolean visit(PackageDeclaration node) {
            Name name = node.getName();
            this.fPackage = Factory.packageDescriptor(name.getFullyQualifiedName());
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            String signature;
            Javadoc doc;
            if (this.isNotVisible(node.getModifiers())) {
                ASTNode parent = node.getParent();
                if (parent instanceof TypeDeclaration) {
                    TypeDeclaration type = (TypeDeclaration)parent;
                    if (!type.isInterface()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if ((doc = node.getJavadoc()) != null && (signature = Signatures.getMethodSignatureFromNode(node)) != null) {
                IMethodDescriptor descriptor;
                block12: {
                    String methodname = node.getName().getFullyQualifiedName();
                    if (node.isConstructor()) {
                        methodname = "<init>";
                    }
                    descriptor = this.fType.getMethod(methodname, signature);
                    try {
                        descriptor = this.resolveMethod(descriptor);
                    }
                    catch (CoreException e) {
                        if (!ApiPlugin.DEBUG_TAG_SCANNER) break block12;
                        System.err.println(e.getLocalizedMessage());
                    }
                }
                List tags = doc.tags();
                int restrictions = 0;
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    if ("@noreference".equals(tagname)) {
                        restrictions |= 8;
                    }
                    if (!"@nooverride".equals(tagname) || Flags.isFinal((int)node.getModifiers()) || Flags.isStatic((int)node.getModifiers())) continue;
                    ASTNode parent = node.getParent();
                    if (parent instanceof TypeDeclaration) {
                        TypeDeclaration type = (TypeDeclaration)parent;
                        if (Flags.isFinal((int)type.getModifiers())) continue;
                        restrictions |= 0x10;
                        continue;
                    }
                    if (!(parent instanceof AnonymousClassDeclaration)) continue;
                    restrictions |= 0x10;
                }
                if (restrictions != 0) {
                    this.fDescription.setRestrictions(descriptor, restrictions);
                }
            }
            return true;
        }

        public boolean visit(FieldDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                return false;
            }
            Javadoc doc = node.getJavadoc();
            if (doc != null) {
                List fields = node.fragments();
                VariableDeclarationFragment fragment = null;
                List tags = doc.tags();
                int flags = node.getModifiers();
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname) || Flags.isFinal((int)flags) || !"@noreference".equals(tagname)) continue;
                    Iterator iter = fields.iterator();
                    while (iter.hasNext()) {
                        fragment = (VariableDeclarationFragment)iter.next();
                        this.fDescription.setRestrictions(this.fType.getField(fragment.getName().getFullyQualifiedName()), 8);
                    }
                }
            }
            return true;
        }

        private boolean isNotVisible(int flags) {
            return Flags.isPrivate((int)flags) || Flags.isPackageDefault((int)flags);
        }

        private IMethodDescriptor resolveMethod(IMethodDescriptor descriptor) throws CoreException {
            if (this.fContainer != null) {
                IApiType structure;
                IReferenceTypeDescriptor type = descriptor.getEnclosingType();
                IApiTypeRoot classFile = this.fContainer.findTypeRoot(type.getQualifiedName());
                if (classFile != null && (structure = classFile.getStructure()) != null) {
                    IApiMethod[] methods = structure.getMethods();
                    int i = 0;
                    while (i < methods.length) {
                        IApiMethod method = methods[i];
                        if (descriptor.getName().equals(method.getName())) {
                            String signature = method.getSignature();
                            String descriptorSignature = descriptor.getSignature().replace('/', '.');
                            if (Signatures.matchesSignatures(descriptorSignature, signature.replace('/', '.'))) {
                                return descriptor.getEnclosingType().getMethod(method.getName(), signature);
                            }
                            String genericSignature = method.getGenericSignature();
                            if (genericSignature != null && Signatures.matchesSignatures(descriptorSignature, genericSignature.replace('/', '.'))) {
                                return descriptor.getEnclosingType().getMethod(method.getName(), signature);
                            }
                        }
                        ++i;
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Unable to resolve method signature: {0}", descriptor.toString()), null));
            }
            return descriptor;
        }
    }
}

