/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.zip.CRC32;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SourceTypeBinding
extends ReferenceBinding {
    public ReferenceBinding superclass;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    public ReferenceBinding[] memberTypes = Binding.NO_MEMBER_TYPES;
    public Scope scope;
    public ClassScope classScope;
    char[] genericReferenceTypeSignature;
    public SourceTypeBinding nextType;
    private static final CRC32 checksumCalculator = new CRC32();

    public SourceTypeBinding(char[][] compoundName, PackageBinding fPackage, Scope scope) {
        this.compoundName = compoundName;
        this.fPackage = fPackage;
        this.fileName = scope.referenceCompilationUnit().getFileName();
        if (scope instanceof ClassScope) {
            this.classScope = (ClassScope)scope;
            if (this.classScope.referenceContext != null) {
                this.modifiers = this.classScope.referenceContext.modifiers;
                this.sourceName = this.classScope.referenceContext.name;
            } else {
                this.sourceName = this.classScope.inferredType.getName();
                this.modifiers = 1;
            }
        }
        this.scope = scope;
        this.fields = Binding.NO_FIELDS;
        this.methods = Binding.NO_METHODS;
        this.computeId();
    }

    protected SourceTypeBinding() {
    }

    void buildFieldsAndMethods() {
        this.buildFields();
        this.buildMethods();
    }

    public InferredType getInferredType() {
        ClassScope classScope = this.scope.classScope();
        return classScope.inferredType;
    }

    private void buildFields() {
        FieldBinding prototype = new FieldBinding(TypeConstants.PROTOTYPE, (TypeBinding)TypeBinding.UNKNOWN, this.modifiers | 0x2000000, (ReferenceBinding)this);
        InferredType inferredType = this.classScope.inferredType;
        int size = inferredType.numberAttributes;
        if (size == 0) {
            this.setFields(new FieldBinding[]{prototype});
            return;
        }
        FieldBinding[] fieldBindings = new FieldBinding[size + 1];
        HashtableOfObject knownFieldNames = new HashtableOfObject(size);
        boolean duplicate = false;
        int count = 0;
        int i = 0;
        while (i < size) {
            InferredAttribute field = inferredType.attributes[i];
            int modifiers = 0;
            if (field.isStatic) {
                modifiers |= 8;
            }
            InferredType fieldType = field.type;
            TypeBinding fieldTypeBinding = null;
            if (fieldType != null) {
                fieldTypeBinding = fieldType.resolveType(this.scope, field.node);
            }
            if (fieldTypeBinding == null) {
                fieldTypeBinding = TypeBinding.UNKNOWN;
            }
            FieldBinding fieldBinding = new FieldBinding(field, fieldTypeBinding, modifiers | 0x2000000, (ReferenceBinding)this);
            fieldBinding.id = count;
            if (knownFieldNames.containsKey(field.name)) {
                duplicate = true;
                FieldBinding previousBinding = (FieldBinding)knownFieldNames.get(field.name);
                if (previousBinding != null) {
                    int f = 0;
                    while (f < i) {
                        InferredAttribute previousField = inferredType.attributes[f];
                        if (previousField.binding == previousBinding) {
                            this.scope.problemReporter().duplicateFieldInType(this, previousField);
                            previousField.binding = null;
                            break;
                        }
                        ++f;
                    }
                }
                knownFieldNames.put(field.name, null);
                this.scope.problemReporter().duplicateFieldInType(this, field);
                field.binding = null;
            } else {
                knownFieldNames.put(field.name, fieldBinding);
                if (fieldBinding != null) {
                    fieldBindings[count++] = fieldBinding;
                }
            }
            ++i;
        }
        fieldBindings[count++] = prototype;
        if (duplicate) {
            FieldBinding[] newFieldBindings = new FieldBinding[fieldBindings.length];
            size = count;
            count = 0;
            int i2 = 0;
            while (i2 < size) {
                FieldBinding fieldBinding = fieldBindings[i2];
                if (knownFieldNames.get(fieldBinding.name) != null) {
                    fieldBinding.id = count;
                    newFieldBindings[count++] = fieldBinding;
                }
                ++i2;
            }
            fieldBindings = newFieldBindings;
        }
        if (count != fieldBindings.length) {
            FieldBinding[] fieldBindingArray = fieldBindings;
            fieldBindings = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, fieldBindings, 0, count);
        }
        this.setFields(fieldBindings);
    }

    private void buildMethods() {
        int size;
        InferredType inferredType = this.classScope.inferredType;
        int n = size = inferredType.methods != null ? inferredType.methods.size() : 0;
        if (size == 0) {
            this.setMethods(Binding.NO_METHODS);
            return;
        }
        int count = 0;
        MethodBinding[] methodBindings = new MethodBinding[size];
        int i = 0;
        while (i < size) {
            MethodBinding methodBinding;
            InferredMethod method = (InferredMethod)inferredType.methods.get(i);
            boolean doesNotHaveResolvedScope = method.getFunctionDeclaration() instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)((Object)method.getFunctionDeclaration())).scope == null;
            MethodDeclaration methDec = (MethodDeclaration)method.getFunctionDeclaration();
            MethodScope scope = new MethodScope(this.scope, methDec, false);
            method.methodBinding = methodBinding = scope.createMethod(method, this);
            methDec.binding = methodBinding;
            methDec.bindArguments();
            if (methodBinding != null) {
                methodBindings[count++] = methodBinding;
            }
            if (doesNotHaveResolvedScope) {
                this.scope.environment().defaultPackage.addBinding(methodBinding, methodBinding.selector, 8);
            }
            ++i;
        }
        if (count != methodBindings.length) {
            MethodBinding[] methodBindingArray = methodBindings;
            methodBindings = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, methodBindings, 0, count);
        }
        this.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        this.setMethods(methodBindings);
    }

    public int kind() {
        return 4;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        char[] uniqueKey = super.computeUniqueKey(isLeaf);
        if (uniqueKey.length == 2) {
            return uniqueKey;
        }
        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(this.fileName) || Util.isMetadataFileName(new String(this.fileName))) {
            return uniqueKey;
        }
        int end = CharOperation.lastIndexOf('.', this.fileName);
        if (end != -1) {
            char[] topLevelType;
            int start = CharOperation.lastIndexOf('/', this.fileName) + 1;
            char[] mainTypeName = CharOperation.subarray(this.fileName, start, end);
            start = CharOperation.lastIndexOf('/', uniqueKey) + 1;
            if (start == 0) {
                start = 1;
            }
            if ((end = CharOperation.indexOf('$', uniqueKey, start)) == -1) {
                end = CharOperation.indexOf('<', uniqueKey, start);
            }
            if (end == -1) {
                end = CharOperation.indexOf(';', uniqueKey, start);
            }
            if (!CharOperation.equals(topLevelType = CharOperation.subarray(uniqueKey, start, end), mainTypeName)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(uniqueKey, 0, start);
                buffer.append(mainTypeName);
                buffer.append('~');
                buffer.append(topLevelType);
                buffer.append(uniqueKey, end, uniqueKey.length - end);
                int length = buffer.length();
                uniqueKey = new char[length];
                buffer.getChars(0, length, uniqueKey, 0);
                return uniqueKey;
            }
        }
        return uniqueKey;
    }

    void faultInTypesForFieldsAndMethods() {
        ReferenceBinding enclosingType = this.enclosingType();
        if (enclosingType != null && enclosingType.isViewedAsDeprecated() && !this.isDeprecated()) {
            this.modifiers |= 0x200000;
        }
        this.fields();
        this.methods();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldBinding[] fields() {
        block24: {
            block23: {
                block22: {
                    fieldCache = new HashMap<char[], FieldBinding>();
                    if ((this.tagBits & 8192L) != 0L) break block23;
                    failed = 0;
                    resolvedFields = this.fields;
                    try {
                        if ((this.tagBits & 4096L) == 0L) {
                            length = this.fields.length;
                            if (length > 1) {
                                ReferenceBinding.sortFields(this.fields, 0, length);
                            }
                            this.tagBits |= 4096L;
                        }
                        i = 0;
                        length = this.fields.length;
                        while (i < length) {
                            if (this.resolveTypeFor(this.fields[i]) == null) {
                                if (resolvedFields == this.fields) {
                                    resolvedFields = new FieldBinding[length];
                                    System.arraycopy(this.fields, 0, resolvedFields, 0, length);
                                }
                                resolvedFields[i] = null;
                                ++failed;
                            }
                            fieldCache.put(this.fields[i].name, this.fields[i]);
                            ++i;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var7_8) {
                        var6_9 = null;
                        if (failed <= 0) throw var7_8;
                        newSize = resolvedFields.length - failed;
                        if (newSize == 0) {
                            this.fields = Binding.NO_FIELDS;
                            return Binding.NO_FIELDS;
                        }
                        newFields = new FieldBinding[newSize];
                        i = 0;
                        j = 0;
                        length = resolvedFields.length;
                    }
                    while (true) {
                        if (i >= length) {
                            this.fields = newFields;
                            throw var7_8;
                        }
                        if (resolvedFields[i] != null) {
                            newFields[j++] = resolvedFields[i];
                        }
                        ++i;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var6_10 = null;
                        if (failed <= 0) break block22;
                    }
                    newSize = resolvedFields.length - failed;
                    if (newSize == 0) {
                        this.fields = Binding.NO_FIELDS;
                        return Binding.NO_FIELDS;
                    }
                    newFields = new FieldBinding[newSize];
                    i = 0;
                    j = 0;
                    length = resolvedFields.length;
                    while (true) {
                        if (i >= length) {
                            this.fields = newFields;
                            break;
                        }
                        if (resolvedFields[i] != null) {
                            newFields[j++] = resolvedFields[i];
                        }
                        ++i;
                    }
                }
                this.tagBits |= 8192L;
                break block24;
            }
            i = 0;
            while (i < this.fields.length) {
                if (this.fields[i] != null) {
                    fieldCache.put(this.fields[i].name, this.fields[i]);
                }
                ++i;
            }
        }
        if (this.nextType == null) {
            return this.fields;
        }
        moreFields = this.nextType.fields();
        i = 0;
        while (true) {
            if (i >= moreFields.length) {
                return fieldCache.values().toArray(new FieldBinding[0]);
            }
            if (fieldCache.get(moreFields[i].name) == null) {
                fieldCache.put(moreFields[i].name, moreFields[i]);
            }
            ++i;
        }
    }

    public MethodBinding[] getDefaultAbstractMethods() {
        int count = 0;
        int i = this.methods.length;
        while (--i >= 0) {
            if (!this.methods[i].isDefaultAbstract()) continue;
            ++count;
        }
        if (count == 0) {
            return Binding.NO_METHODS;
        }
        MethodBinding[] result = new MethodBinding[count];
        count = 0;
        int i2 = this.methods.length;
        while (--i2 >= 0) {
            if (!this.methods[i2].isDefaultAbstract()) continue;
            result[count++] = this.methods[i2];
        }
        return result;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        MethodBinding exactConstructor = this.getExactConstructor0(argumentTypes);
        if (exactConstructor == null && this.nextType != null) {
            exactConstructor = this.nextType.getExactConstructor(argumentTypes);
        }
        return exactConstructor;
    }

    private MethodBinding getExactConstructor0(TypeBinding[] argumentTypes) {
        int cfr_ignored_0 = argumentTypes.length;
        if ((this.tagBits & 0x8000L) != 0L) {
            int end;
            int imethod;
            long range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
            if (range >= 0L && (imethod = (int)range) <= (end = (int)(range >> 32))) {
                MethodBinding method = this.methods[imethod];
                return method;
            }
        } else {
            int end;
            int imethod;
            long range;
            if ((this.tagBits & 0x4000L) == 0L) {
                int length = this.methods.length;
                if (length > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, length);
                }
                this.tagBits |= 0x4000L;
            }
            if ((range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods)) >= 0L && (imethod = (int)range) <= (end = (int)(range >> 32))) {
                MethodBinding method = this.methods[imethod];
                if (this.resolveTypesFor(method) == null || method.returnType == null) {
                    this.methods();
                    return this.getExactConstructor(argumentTypes);
                }
                return method;
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        MethodBinding exactMethod = this.getExactMethod0(selector, argumentTypes, refScope);
        if (exactMethod == null && this.nextType != null) {
            exactMethod = this.nextType.getExactMethod(selector, argumentTypes, refScope);
        }
        return exactMethod;
    }

    private MethodBinding getExactMethod0(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        long range;
        boolean foundNothing = true;
        if ((this.tagBits & 0x8000L) != 0L) {
            int end;
            int imethod;
            range = ReferenceBinding.binarySearch(selector, this.methods);
            if (range >= 0L && (imethod = (int)range) <= (end = (int)(range >> 32))) {
                MethodBinding method = this.methods[imethod];
                foundNothing = false;
                return method;
            }
        } else {
            if ((this.tagBits & 0x4000L) == 0L) {
                int length = this.methods.length;
                if (length > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, length);
                }
                this.tagBits |= 0x4000L;
            }
            if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
                int start = (int)range;
                int end = (int)(range >> 32);
                int imethod = start;
                while (imethod <= end) {
                    MethodBinding method = this.methods[imethod];
                    if (this.resolveTypesFor(method) == null || method.returnType == null) {
                        this.methods();
                        return this.getExactMethod(selector, argumentTypes, refScope);
                    }
                    ++imethod;
                }
                boolean isSource15 = this.scope != null && this.scope.compilerOptions().sourceLevel >= 0x310000L;
                int i = start;
                while (i <= end) {
                    MethodBinding method1 = this.methods[i];
                    int j = end;
                    while (j > i) {
                        boolean paramsMatch;
                        MethodBinding method2 = this.methods[j];
                        boolean bl = paramsMatch = isSource15 ? method1.areParametersEqual(method2) : method1.areParametersEqual(method2);
                        if (paramsMatch) {
                            this.methods();
                            return this.getExactMethod(selector, argumentTypes, refScope);
                        }
                        --j;
                    }
                    ++i;
                }
                return this.methods[start];
            }
        }
        if (foundNothing && this.superclass != null && this.superclass != this) {
            MethodBinding exactMethod;
            if (refScope != null) {
                refScope.recordTypeReference(this.superclass);
            }
            if ((exactMethod = this.superclass.getExactMethod(selector, argumentTypes, refScope)) != null && exactMethod.isValidBinding()) {
                return exactMethod;
            }
        }
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        FieldBinding field = this.getField0(fieldName, needResolve);
        if (field == null && this.nextType != null) {
            field = this.nextType.getField(fieldName, needResolve);
        }
        return field;
    }

    public FieldBinding getFieldInHierarchy(char[] fieldName, boolean needResolve) {
        SourceTypeBinding currentType = this;
        while (currentType != null) {
            FieldBinding field = currentType.getField(fieldName, needResolve);
            if (field != null) {
                return field;
            }
            currentType = (SourceTypeBinding)currentType.superclass();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FieldBinding getField0(char[] fieldName, boolean needResolve) {
        int length3;
        int i2;
        FieldBinding[] newFields2;
        Throwable throwable2;
        FieldBinding field;
        block13: {
            FieldBinding fieldBinding;
            if ((this.tagBits & 0x2000L) != 0L) {
                return ReferenceBinding.binarySearch(fieldName, this.fields);
            }
            if ((this.tagBits & 0x1000L) == 0L) {
                int length2 = this.fields.length;
                if (length2 > 1) {
                    ReferenceBinding.sortFields(this.fields, 0, length2);
                }
                this.tagBits |= 0x1000L;
            }
            if ((field = ReferenceBinding.binarySearch(fieldName, this.fields)) == null) return null;
            FieldBinding result = null;
            try {
                fieldBinding = result = this.resolveTypeFor(field);
                Object var5_7 = null;
                if (result != null) return fieldBinding;
            }
            catch (Throwable throwable2) {
                Object var5_8 = null;
                if (result != null) throw throwable2;
                int newSize = this.fields.length - 1;
                if (newSize == 0) {
                    this.fields = Binding.NO_FIELDS;
                    throw throwable2;
                }
                newFields2 = new FieldBinding[newSize];
                int index = 0;
                i2 = 0;
                length3 = this.fields.length;
                break block13;
            }
            int newSize = this.fields.length - 1;
            if (newSize == 0) {
                this.fields = Binding.NO_FIELDS;
                return fieldBinding;
            }
            FieldBinding[] newFields2 = new FieldBinding[newSize];
            int index = 0;
            int i2 = 0;
            int length3 = this.fields.length;
            while (true) {
                if (i2 >= length3) {
                    this.fields = newFields2;
                    return fieldBinding;
                }
                FieldBinding f = this.fields[i2];
                if (f != field) {
                    newFields2[index++] = f;
                }
                ++i2;
            }
        }
        while (true) {
            if (i2 >= length3) {
                this.fields = newFields2;
                throw throwable2;
            }
            FieldBinding f = this.fields[i2];
            if (f != field) {
                newFields2[index++] = f;
            }
            ++i2;
        }
    }

    public MethodBinding[] getMethods(char[] selector) {
        MethodBinding[] meths = this.getMethods0(selector);
        if (this.nextType == null) {
            return meths;
        }
        MethodBinding[] moreMethods = this.nextType.getMethods(selector);
        MethodBinding[] combinedMethods = new MethodBinding[meths.length + moreMethods.length];
        System.arraycopy(meths, 0, combinedMethods, 0, meths.length);
        System.arraycopy(moreMethods, 0, combinedMethods, meths.length, moreMethods.length);
        return combinedMethods;
    }

    private MethodBinding[] getMethods0(char[] selector) {
        MethodBinding method;
        int end;
        int start;
        long range;
        if ((this.tagBits & 0x8000L) != 0L) {
            long range2 = ReferenceBinding.binarySearch(selector, this.methods);
            if (range2 >= 0L) {
                int start2 = (int)range2;
                int end2 = (int)(range2 >> 32);
                int length = end2 - start2 + 1;
                MethodBinding[] result = new MethodBinding[length];
                System.arraycopy(this.methods, start2, result, 0, length);
                return result;
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
            start = (int)range;
            end = (int)(range >> 32);
            int i = start;
            while (i <= end) {
                method = this.methods[i];
                if (this.resolveTypesFor(method) == null || method.returnType == null) {
                    this.methods();
                    return this.getMethods(selector);
                }
                ++i;
            }
        } else {
            return Binding.NO_METHODS;
        }
        int length = end - start + 1;
        MethodBinding[] result = new MethodBinding[length];
        System.arraycopy(this.methods, start, result, 0, length);
        boolean isSource15 = this.scope != null && this.scope.compilerOptions().sourceLevel >= 0x310000L;
        int i = 0;
        length = result.length - 1;
        while (i < length) {
            method = result[i];
            int j = length;
            while (j > i) {
                boolean paramsMatch;
                boolean bl = paramsMatch = isSource15 ? method.areParametersEqual(result[j]) : method.areParametersEqual(result[j]);
                if (paramsMatch) {
                    this.methods();
                    return this.getMethods(selector);
                }
                --j;
            }
            ++i;
        }
        return result;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        return false;
    }

    public ReferenceBinding[] memberTypes() {
        if (this.nextType == null) {
            return this.memberTypes;
        }
        ReferenceBinding[] moreTypes = this.nextType.memberTypes();
        ReferenceBinding[] combinedTypes = new ReferenceBinding[this.memberTypes.length + moreTypes.length];
        System.arraycopy(this.memberTypes, 0, combinedTypes, 0, this.memberTypes.length);
        System.arraycopy(moreTypes, 0, combinedTypes, this.memberTypes.length, moreTypes.length);
        return combinedTypes;
    }

    public FieldBinding getUpdatedFieldBinding(FieldBinding targetField, ReferenceBinding newDeclaringClass) {
        Hashtable<ReferenceBinding, FieldBinding> fieldMap = new Hashtable<ReferenceBinding, FieldBinding>(5);
        FieldBinding updatedField = new FieldBinding(targetField, newDeclaringClass);
        fieldMap.put(newDeclaringClass, updatedField);
        return updatedField;
    }

    public MethodBinding getUpdatedMethodBinding(MethodBinding targetMethod, ReferenceBinding newDeclaringClass) {
        MethodBinding updatedMethod = new MethodBinding(targetMethod, newDeclaringClass);
        updatedMethod.createFunctionTypeBinding(this.scope);
        return updatedMethod;
    }

    public boolean hasMemberTypes() {
        boolean hasMembers;
        boolean bl = hasMembers = this.memberTypes != null && this.memberTypes.length > 0;
        if (!hasMembers && this.nextType != null) {
            hasMembers = this.nextType.hasMemberTypes();
        }
        return hasMembers;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MethodBinding[] methods() {
        block36: {
            block35: {
                block34: {
                    if ((this.tagBits & 32768L) != 0L) break block36;
                    if ((this.tagBits & 16384L) == 0L) {
                        length = this.methods.length;
                        if (length > 1) {
                            ReferenceBinding.sortMethods(this.methods, 0, length);
                        }
                        this.tagBits |= 16384L;
                    }
                    failed = 0;
                    resolvedMethods = this.methods;
                    try {
                        i = 0;
                        length = this.methods.length;
                        while (true) {
                            block37: {
                                if (i < length) break block37;
                            }
                            if (this.resolveTypesFor(this.methods[i]) == null) {
                                if (resolvedMethods == this.methods) {
                                    resolvedMethods = new MethodBinding[length];
                                    System.arraycopy(this.methods, 0, resolvedMethods, 0, length);
                                }
                                resolvedMethods[i] = null;
                                ++failed;
                            }
                            ++i;
                        }
                        complyTo15 = this.scope != null && this.scope.compilerOptions().sourceLevel >= 0x310000L;
                        i = 0;
                        length = this.methods.length;
                        while (i < length) {
                            block38: {
                                method = resolvedMethods[i];
                                if (method == null) break block38;
                                selector = method.selector;
                                methodDecl = null;
                                j = i + 1;
                                while (j < length) {
                                    block39: {
                                        block41: {
                                            block40: {
                                                method2 = resolvedMethods[j];
                                                if (method2 == null) break block39;
                                                if (!CharOperation.equals(selector, method2.selector)) break;
                                                if (!complyTo15 || method.returnType == null || method2.returnType == null) break block40;
                                                params1 = method.parameters;
                                                pLength = params1.length;
                                                params2 = method2.parameters;
                                                if (pLength != params2.length) break block39;
                                                subMethod = method2;
                                                equalParams = method.areParametersEqual(subMethod);
                                                if (equalParams || method.returnType == subMethod.returnType && (equalParams || method.areParametersEqual(method2)) || pLength <= 0) break block41;
                                                index = pLength;
                                                while (--index >= 0 && params1[index] == params2[index]) {
                                                }
                                                if (index >= 0 && index < pLength) {
                                                    index = pLength;
                                                    while (--index >= 0 && params1[index] == params2[index]) {
                                                    }
                                                }
                                                if (index < 0) break block41;
                                                break block39;
                                            }
                                            if (!method.areParametersEqual(method2)) break block39;
                                        }
                                        if (methodDecl == null && (methodDecl = method.sourceMethod()) != null && methodDecl.binding != null) {
                                            this.scope.problemReporter().duplicateMethodInType(this, methodDecl);
                                            methodDecl.binding = null;
                                            if (resolvedMethods == this.methods) {
                                                resolvedMethods = new MethodBinding[length];
                                                System.arraycopy(this.methods, 0, resolvedMethods, 0, length);
                                            }
                                            resolvedMethods[i] = null;
                                            ++failed;
                                        }
                                        if ((method2Decl = method2.sourceMethod()) != null && method2Decl.binding != null) {
                                            this.scope.problemReporter().duplicateMethodInType(this, method2Decl);
                                            method2Decl.binding = null;
                                            if (resolvedMethods == this.methods) {
                                                resolvedMethods = new MethodBinding[length];
                                                System.arraycopy(this.methods, 0, resolvedMethods, 0, length);
                                            }
                                            resolvedMethods[j] = null;
                                            ++failed;
                                        }
                                    }
                                    ++j;
                                }
                                if (method.returnType == null && methodDecl == null) {
                                    methodDecl = method.sourceMethod();
                                    if (methodDecl != null) {
                                        methodDecl.binding = null;
                                    }
                                    if (resolvedMethods == this.methods) {
                                        resolvedMethods = new MethodBinding[length];
                                        System.arraycopy(this.methods, 0, resolvedMethods, 0, length);
                                    }
                                    resolvedMethods[i] = null;
                                    ++failed;
                                }
                            }
                            ++i;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var18_18) {
                        var17_19 = null;
                        if (failed <= 0) break block34;
                        newSize = resolvedMethods.length - failed;
                        if (newSize == 0) {
                            this.methods = Binding.NO_METHODS;
                            break block34;
                        }
                        newMethods = new MethodBinding[newSize];
                        i = 0;
                        j = 0;
                        length = resolvedMethods.length;
                    }
                    while (true) {
                        if (i >= length) {
                            this.methods = newMethods;
                            break;
                        }
                        if (resolvedMethods[i] != null) {
                            newMethods[j++] = resolvedMethods[i];
                        }
                        ++i;
                    }
                }
                this.tagBits |= 32768L;
                throw var18_18;
lbl-1000:
                // 1 sources

                {
                    var17_20 = null;
                    if (failed <= 0) break block35;
                }
                newSize = resolvedMethods.length - failed;
                if (newSize == 0) {
                    this.methods = Binding.NO_METHODS;
                } else {
                    newMethods = new MethodBinding[newSize];
                    i = 0;
                    j = 0;
                    length = resolvedMethods.length;
                    while (true) {
                        if (i >= length) {
                            this.methods = newMethods;
                            break;
                        }
                        if (resolvedMethods[i] != null) {
                            newMethods[j++] = resolvedMethods[i];
                        }
                        ++i;
                    }
                }
            }
            this.tagBits |= 32768L;
        }
        if (this.nextType != null) {
            moreMethods = this.nextType.methods();
            combinedMethods = new MethodBinding[this.methods.length + moreMethods.length];
            System.arraycopy(this.methods, 0, combinedMethods, 0, this.methods.length);
            System.arraycopy(moreMethods, 0, combinedMethods, this.methods.length, moreMethods.length);
            return combinedMethods;
        }
        return this.methods;
    }

    private FieldBinding resolveTypeFor(FieldBinding field) {
        if ((field.modifiers & 0x2000000) == 0) {
            return field;
        }
        if (this.isViewedAsDeprecated() && !field.isDeprecated()) {
            field.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            field.modifiers |= 0x40000;
        }
        return field;
    }

    public MethodBinding resolveTypesFor(MethodBinding method) {
        return this.resolveTypesFor(method, null);
    }

    public MethodBinding resolveTypesFor(MethodBinding method, AbstractMethodDeclaration methodDecl) {
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        if (this.isViewedAsDeprecated() && !method.isDeprecated()) {
            method.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            method.modifiers |= 0x40000;
        }
        if (methodDecl == null) {
            methodDecl = method.sourceMethod();
        }
        if (methodDecl == null) {
            return null;
        }
        boolean foundArgProblem = false;
        Argument[] arguments = methodDecl.arguments;
        if (arguments != null) {
            int size = arguments.length;
            method.parameters = Binding.NO_PARAMETERS;
            TypeBinding[] newParameters = new TypeBinding[size];
            int i = 0;
            while (i < size) {
                Argument arg = arguments[i];
                TypeBinding parameterType = TypeBinding.UNKNOWN;
                if (arg.type != null) {
                    parameterType = arg.type.resolveType(methodDecl.scope, true);
                } else if (arg.inferredType != null) {
                    parameterType = arg.inferredType.resolveType(methodDecl.scope, arg);
                }
                if (parameterType == null) {
                    parameterType = TypeBinding.ANY;
                }
                newParameters[i] = parameterType;
                if (arg.binding == null) {
                    arg.binding = new LocalVariableBinding(arg, parameterType, arg.modifiers, true);
                }
                ++i;
            }
            if (!foundArgProblem) {
                method.parameters = newParameters;
            }
        }
        boolean foundReturnTypeProblem = false;
        if (!method.isConstructor()) {
            TypeReference returnType;
            TypeReference typeReference = returnType = methodDecl instanceof MethodDeclaration ? ((MethodDeclaration)methodDecl).returnType : null;
            if (returnType == null && !(methodDecl instanceof MethodDeclaration)) {
                methodDecl.scope.problemReporter().missingReturnType(methodDecl);
                method.returnType = null;
                foundReturnTypeProblem = true;
            } else {
                TypeBinding methodType;
                TypeBinding typeBinding = methodType = returnType != null ? returnType.resolveType(methodDecl.scope, true) : null;
                if (methodType == null) {
                    TypeBinding typeBinding2 = methodType = methodDecl.inferredType != null ? methodDecl.inferredType.resolveType(methodDecl.scope, methodDecl) : TypeBinding.UNKNOWN;
                }
                if (methodType == null) {
                    foundReturnTypeProblem = true;
                } else {
                    method.returnType = methodType;
                    methodType.leafComponentType();
                }
            }
        }
        if (foundArgProblem) {
            methodDecl.binding = null;
            method.parameters = Binding.NO_PARAMETERS;
            return null;
        }
        if (foundReturnTypeProblem) {
            return method;
        }
        method.modifiers &= 0xFDFFFFFF;
        return method;
    }

    public void setFields(FieldBinding[] fields) {
        this.fields = fields;
    }

    public void setMethods(MethodBinding[] methods) {
        this.methods = methods;
    }

    public int sourceEnd() {
        if (this.classScope.referenceContext != null) {
            return this.classScope.referenceContext.sourceEnd;
        }
        return this.classScope.inferredType.sourceEnd;
    }

    public int sourceStart() {
        if (this.classScope.referenceContext != null) {
            return this.classScope.referenceContext.sourceStart;
        }
        return this.classScope.inferredType.sourceStart;
    }

    public ReferenceBinding superclass() {
        if (this.nextType == null) {
            if (this == this.superclass) {
                return null;
            }
            return this.superclass;
        }
        if (this.superclass != null && this.superclass.id != 1) {
            if (this == this.superclass) {
                return null;
            }
            return this.superclass;
        }
        return this.nextType.superclass();
    }

    public String toString() {
        int length;
        int i;
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("(id=");
        if (this.id == Integer.MAX_VALUE) {
            buffer.append("NoId");
        } else {
            buffer.append(this.id);
        }
        buffer.append(")\n");
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        buffer.append("\n\textends ");
        buffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.enclosingType() != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType().debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append('\n').append(this.fields[i] != null ? this.fields[i].toString() : "NULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                buffer.append("\n/*   methods   */");
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    buffer.append('\n').append(this.methods[i] != null ? this.methods[i].toString() : "NULL METHOD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append('\n').append(this.memberTypes[i] != null ? this.memberTypes[i].toString() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n");
        return buffer.toString();
    }

    void verifyMethods(MethodVerifier verifier) {
    }

    public AbstractMethodDeclaration sourceMethod(MethodBinding binding) {
        if (this.classScope == null) {
            return null;
        }
        InferredType inferredType = this.classScope.inferredType;
        InferredMethod inferredMethod = inferredType.findMethod(binding.selector, null);
        if (inferredMethod != null) {
            return (AbstractMethodDeclaration)((Object)inferredMethod.getFunctionDeclaration());
        }
        return null;
    }

    public void addMethod(MethodBinding binding) {
        int length = this.methods.length;
        this.methods = new MethodBinding[length + 1];
        System.arraycopy(this.methods, 0, this.methods, 0, length);
        this.methods[length] = binding;
    }

    public void cleanup() {
        this.scope = null;
        this.classScope = null;
    }

    public boolean contains(ReferenceBinding binding) {
        if (binding == this) {
            return true;
        }
        if (this.nextType != null) {
            return this.nextType.contains(binding);
        }
        return false;
    }

    public void addNextType(SourceTypeBinding type) {
        SourceTypeBinding binding = this;
        boolean isDuplicate = this.checkIfDuplicateType(binding, type);
        while (!isDuplicate && binding.nextType != null) {
            binding = binding.nextType;
            if (binding == null || !this.checkIfDuplicateType(binding, type)) continue;
            isDuplicate = true;
        }
        if (!isDuplicate) {
            binding.nextType = type;
        }
    }

    public boolean checkIfDuplicateType(SourceTypeBinding binding1, SourceTypeBinding binding2) {
        InferredType type2 = binding2.classScope.inferredType;
        if (binding1.classScope == null) {
            if (binding1.superclass == null && type2.superClass != null) {
                return false;
            }
            if (binding1.superclass != null && type2.superClass == null) {
                return false;
            }
            if (binding1.superclass != null && type2.superClass != null && !CharOperation.equals(binding1.superclass.sourceName, type2.superClass.getName())) {
                return false;
            }
            if (binding1.fields.length != type2.attributes.length) {
                return false;
            }
            if (binding1.methods == null && type2.methods != null) {
                return false;
            }
            if (binding1.methods != null && type2.methods == null) {
                return false;
            }
            if (binding1.methods != null && type2.methods != null && binding1.methods.length != type2.methods.size()) {
                return false;
            }
        } else {
            InferredType type1 = binding1.classScope.inferredType;
            if (type1.superClass == null && type2.superClass != null) {
                return false;
            }
            if (type1.superClass != null && type2.superClass == null) {
                return false;
            }
            if (type1.superClass != null && type2.superClass != null && !CharOperation.equals(type1.superClass.getName(), type2.superClass.getName())) {
                return false;
            }
            if (type1.attributes.length != type2.attributes.length) {
                return false;
            }
            if (type1.methods == null && type2.methods != null) {
                return false;
            }
            if (type1.methods != null && type2.methods == null) {
                return false;
            }
            if (type1.methods != null && type2.methods != null && type1.methods.size() != type2.methods.size()) {
                return false;
            }
            StringBuffer checkSumString1 = new StringBuffer();
            StringBuffer checkSumString2 = new StringBuffer();
            int i = 0;
            while (i < type1.attributes.length) {
                checkSumString1.append(type1.attributes[i] == null ? "" : new String(type1.attributes[i].name));
                checkSumString2.append(type2.attributes[i] == null ? "" : new String(type2.attributes[i].name));
                ++i;
            }
            checksumCalculator.reset();
            checksumCalculator.update(checkSumString1.toString().getBytes());
            long checkSum1 = checksumCalculator.getValue();
            checksumCalculator.reset();
            checksumCalculator.update(checkSumString2.toString().getBytes());
            long checkSum2 = checksumCalculator.getValue();
            if (checkSum1 != checkSum2) {
                return false;
            }
            checkSumString1 = new StringBuffer();
            checkSumString2 = new StringBuffer();
            if (type1.methods != null && type2.methods != null) {
                int i2 = 0;
                while (i2 < type1.methods.size()) {
                    checkSumString1.append(new String(((InferredMethod)type1.methods.get((int)i2)).name));
                    checkSumString2.append(new String(((InferredMethod)type2.methods.get((int)i2)).name));
                    ++i2;
                }
            }
            checksumCalculator.reset();
            checksumCalculator.update(checkSumString1.toString().getBytes());
            checkSum1 = checksumCalculator.getValue();
            checksumCalculator.reset();
            checksumCalculator.update(checkSumString2.toString().getBytes());
            checkSum2 = checksumCalculator.getValue();
            if (checkSum1 != checkSum2) {
                return false;
            }
        }
        return true;
    }

    public TypeBinding reconcileAnonymous(TypeBinding other) {
        int i;
        if (!(other instanceof SourceTypeBinding)) {
            return null;
        }
        SourceTypeBinding otherBinding = (SourceTypeBinding)other;
        if (!otherBinding.isAnonymousType()) {
            return null;
        }
        if (otherBinding.methods != null) {
            i = 0;
            while (i < otherBinding.methods.length) {
                MethodBinding methodBinding = otherBinding.methods[i];
                MethodBinding exactMethod = this.getExactMethod(methodBinding.selector, methodBinding.parameters, null);
                if (exactMethod == null) {
                    return null;
                }
                ++i;
            }
        }
        if (otherBinding.fields != null) {
            i = 0;
            while (i < otherBinding.fields.length) {
                FieldBinding fieldBinding = otherBinding.fields[i];
                FieldBinding myField = this.getFieldInHierarchy(fieldBinding.name, true);
                if (myField == null) {
                    return null;
                }
                ++i;
            }
        }
        return this;
    }
}

