/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.DbGenerator;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaDbGenerator;
import org.eclipse.jpt.jpa.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.jpa.db.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaSequenceGenerator<A extends SequenceGeneratorAnnotation>
extends AbstractJavaDbGenerator<A>
implements JavaSequenceGenerator {
    protected String specifiedSequenceName;
    protected String defaultSequenceName;

    protected AbstractJavaSequenceGenerator(JavaGeneratorContainer parent, A generatorAnnotation) {
        super(parent, generatorAnnotation);
        this.specifiedSequenceName = generatorAnnotation.getSequenceName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedSequenceName_(((SequenceGeneratorAnnotation)this.generatorAnnotation).getSequenceName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultSequenceName(this.buildDefaultSequenceName());
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 1;
    }

    @Override
    public String getSequenceName() {
        return this.specifiedSequenceName != null ? this.specifiedSequenceName : this.defaultSequenceName;
    }

    @Override
    public String getSpecifiedSequenceName() {
        return this.specifiedSequenceName;
    }

    @Override
    public void setSpecifiedSequenceName(String name) {
        ((SequenceGeneratorAnnotation)this.generatorAnnotation).setSequenceName(name);
        this.setSpecifiedSequenceName_(name);
    }

    protected void setSpecifiedSequenceName_(String name) {
        String old = this.specifiedSequenceName;
        this.specifiedSequenceName = name;
        this.firePropertyChanged("specifiedSequenceName", old, name);
    }

    @Override
    public String getDefaultSequenceName() {
        return this.defaultSequenceName;
    }

    protected void setDefaultSequenceName(String name) {
        String old = this.defaultSequenceName;
        this.defaultSequenceName = name;
        this.firePropertyChanged("defaultSequenceName", old, name);
    }

    protected String buildDefaultSequenceName() {
        return null;
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.sequenceNameTouches(pos)) {
            return this.getJavaCandidateSequences();
        }
        return null;
    }

    protected boolean sequenceNameTouches(int pos) {
        return ((SequenceGeneratorAnnotation)this.generatorAnnotation).sequenceNameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateSequences() {
        return new TransformationIterable(this.getCandidateSequences(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateSequences() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedSequenceIdentifiers() : EmptyIterable.instance();
    }

    public Class<SequenceGenerator> getType() {
        return SequenceGenerator.class;
    }

    @Override
    protected boolean isEquivalentTo(DbGenerator generator) {
        return super.isEquivalentTo(generator) && this.isEquivalentTo((SequenceGenerator)generator);
    }

    protected boolean isEquivalentTo(SequenceGenerator generator) {
        return ObjectTools.equals((Object)this.specifiedSequenceName, (Object)generator.getSpecifiedSequenceName());
    }

    @Override
    public void convertTo(EntityMappings entityMappings) {
        entityMappings.addSequenceGenerator().convertFrom(this);
    }

    @Override
    public void delete() {
        ((JavaGeneratorContainer)this.parent).removeSequenceGenerator();
    }
}

