/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.SpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTable<P extends JpaContextModel, PA extends Table.ParentAdapter<P>, A extends BaseTableAnnotation>
extends AbstractJavaContextModel<P>
implements JavaSpecifiedTable,
SpecifiedUniqueConstraint.Parent {
    protected final PA parentAdapter;
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final AbstractJpaContextModel.ContextListContainer<JavaSpecifiedUniqueConstraint, UniqueConstraintAnnotation> uniqueConstraintContainer;

    protected AbstractJavaTable(PA parentAdapter) {
        this(parentAdapter, null);
    }

    protected AbstractJavaTable(PA parentAdapter, A tableAnnotation) {
        super(parentAdapter.getTableParent());
        this.parentAdapter = parentAdapter;
        this.setTableAnnotation(tableAnnotation);
        this.specifiedName = this.buildSpecifiedName();
        this.specifiedSchema = this.buildSpecifiedSchema();
        this.specifiedCatalog = this.buildSpecifiedCatalog();
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setSpecifiedSchema_(this.buildSpecifiedSchema());
        this.setSpecifiedCatalog_(this.buildSpecifiedCatalog());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getUniqueConstraints());
    }

    public abstract A getTableAnnotation();

    protected void setTableAnnotation(A tableAnnotation) {
        if (tableAnnotation != null) {
            throw new IllegalArgumentException("this method must be overridden if the table annotation is not null: " + tableAnnotation);
        }
    }

    protected void removeTableAnnotationIfUnset() {
        if (this.getTableAnnotation().isUnset()) {
            this.removeTableAnnotation();
        }
    }

    protected abstract void removeTableAnnotation();

    @Override
    public boolean isSpecifiedInResource() {
        return this.getTableAnnotation().isSpecified();
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (this.valuesAreDifferent(this.specifiedName, name)) {
            this.getTableAnnotation().setName(name);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedName_(name);
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getTableAnnotation().getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        if (this.valuesAreDifferent(this.specifiedSchema, schema)) {
            this.getTableAnnotation().setSchema(schema);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedSchema_(schema);
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        return this.getTableAnnotation().getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        if (this.valuesAreDifferent(this.specifiedCatalog, catalog)) {
            this.getTableAnnotation().setCatalog(catalog);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedCatalog_(catalog);
        }
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        return this.getTableAnnotation().getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    @Override
    public ListIterable<JavaSpecifiedUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer;
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.size();
    }

    @Override
    public JavaSpecifiedUniqueConstraint getUniqueConstraint(int index) {
        return (JavaSpecifiedUniqueConstraint)this.uniqueConstraintContainer.get(index);
    }

    @Override
    public JavaSpecifiedUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.getUniqueConstraintsSize());
    }

    @Override
    public JavaSpecifiedUniqueConstraint addUniqueConstraint(int index) {
        UniqueConstraintAnnotation annotation = this.getTableAnnotation().addUniqueConstraint(index);
        return (JavaSpecifiedUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.getTableAnnotation().removeUniqueConstraint(index);
        this.uniqueConstraintContainer.remove(index);
    }

    @Override
    public void removeUniqueConstraint(SpecifiedUniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraintContainer.indexOf((JavaSpecifiedUniqueConstraint)uniqueConstraint));
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.getTableAnnotation().moveUniqueConstraint(targetIndex, sourceIndex);
        this.uniqueConstraintContainer.move(targetIndex, sourceIndex);
    }

    protected void syncUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected JavaSpecifiedUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation constraintAnnotation) {
        return this.getJpaFactory().buildJavaUniqueConstraint(this, constraintAnnotation);
    }

    protected ListIterable<UniqueConstraintAnnotation> getUniqueConstraintAnnotations() {
        return this.getTableAnnotation().getUniqueConstraints();
    }

    protected AbstractJpaContextModel.ContextListContainer<JavaSpecifiedUniqueConstraint, UniqueConstraintAnnotation> buildUniqueConstraintContainer() {
        return this.buildSpecifiedContextListContainer("uniqueConstraints", new UniqueConstraintContainerAdapter());
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean schemaIsResolved() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean catalogIsResolved() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public Iterable<String> getCandidateUniqueConstraintColumnNames() {
        org.eclipse.jpt.jpa.db.Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (JavaSpecifiedUniqueConstraint constraint : this.getUniqueConstraints()) {
            result = constraint.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos)) {
            return this.getJavaCandidateNames();
        }
        if (this.schemaTouches(pos)) {
            return this.getJavaCandidateSchemata();
        }
        if (this.catalogTouches(pos)) {
            return this.getJavaCandidateCatalogs();
        }
        return null;
    }

    protected boolean nameTouches(int pos) {
        return this.getTableAnnotation().nameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateNames() {
        return new TransformationIterable(this.getCandidateNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateNames() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected boolean schemaTouches(int pos) {
        return this.getTableAnnotation().schemaTouches(pos);
    }

    protected Iterable<String> getJavaCandidateSchemata() {
        return new TransformationIterable(this.getCandidateSchemata(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateSchemata() {
        return this.getDbSchemaContainer().getSortedSchemaIdentifiers();
    }

    protected boolean catalogTouches(int pos) {
        return this.getTableAnnotation().catalogTouches(pos);
    }

    protected Iterable<String> getJavaCandidateCatalogs() {
        return new TransformationIterable(this.getCandidateCatalogs(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildTableValidator().validate(messages, reporter);
    }

    protected JpaValidator buildTableValidator() {
        return this.parentAdapter.buildTableValidator(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getTableAnnotation().getTextRange();
        return textRange != null ? textRange : ((JpaContextModel)this.parent).getValidationTextRange();
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.getValidationTextRange(this.getTableAnnotation().getNameValidationTextRange());
    }

    @Override
    public TextRange getSchemaValidationTextRange() {
        return this.getValidationTextRange(this.getTableAnnotation().getSchemaValidationTextRange());
    }

    @Override
    public TextRange getCatalogValidationTextRange() {
        return this.getValidationTextRange(this.getTableAnnotation().getCatalogValidationTextRange());
    }

    protected void initializeFrom(Table oldTable) {
        this.setSpecifiedName(oldTable.getSpecifiedName());
        this.setSpecifiedCatalog(oldTable.getSpecifiedCatalog());
        this.setSpecifiedSchema(oldTable.getSpecifiedSchema());
        for (UniqueConstraint constraint : oldTable.getUniqueConstraints()) {
            this.addUniqueConstraint().initializeFrom(constraint);
        }
    }

    protected void initializeFromVirtual(Table virtualTable) {
        this.setSpecifiedName(virtualTable.getName());
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedName((String[])new String[]{this.getCatalog(), this.getSchema(), this.getName()});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UniqueConstraintContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JavaSpecifiedUniqueConstraint, UniqueConstraintAnnotation> {
        @Override
        public JavaSpecifiedUniqueConstraint buildContextElement(UniqueConstraintAnnotation resourceElement) {
            return AbstractJavaTable.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        public ListIterable<UniqueConstraintAnnotation> getResourceElements() {
            return AbstractJavaTable.this.getUniqueConstraintAnnotations();
        }

        @Override
        public UniqueConstraintAnnotation extractResourceElement(JavaSpecifiedUniqueConstraint contextElement) {
            return contextElement.getUniqueConstraintAnnotation();
        }
    }
}

