/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.DbGenerator;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaDbGenerator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGenerator;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmDbGenerator<X extends XmlGenerator>
extends AbstractOrmGenerator<X>
implements DbGenerator {
    protected Integer specifiedInitialValue;
    protected int defaultInitialValue;
    protected Integer specifiedAllocationSize;
    protected int defaultAllocationSize;

    protected AbstractOrmDbGenerator(JpaContextModel parent, X xmlGenerator) {
        super(parent, xmlGenerator);
        this.specifiedInitialValue = xmlGenerator.getInitialValue();
        this.specifiedAllocationSize = xmlGenerator.getAllocationSize();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedInitialValue_(this.xmlGenerator.getInitialValue());
        this.setSpecifiedAllocationSize_(this.xmlGenerator.getAllocationSize());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultInitialValue(this.buildDefaultInitialValue());
        this.setDefaultAllocationSize(this.buildDefaultAllocationSize());
    }

    @Override
    public int getInitialValue() {
        return this.specifiedInitialValue != null ? this.specifiedInitialValue : this.defaultInitialValue;
    }

    @Override
    public Integer getSpecifiedInitialValue() {
        return this.specifiedInitialValue;
    }

    @Override
    public void setSpecifiedInitialValue(Integer specifiedInitialValue) {
        this.setSpecifiedInitialValue_(specifiedInitialValue);
        this.xmlGenerator.setInitialValue(specifiedInitialValue);
    }

    protected void setSpecifiedInitialValue_(Integer specifiedInitialValue) {
        Integer old = this.specifiedInitialValue;
        this.specifiedInitialValue = specifiedInitialValue;
        this.firePropertyChanged("specifiedInitialValue", old, specifiedInitialValue);
    }

    @Override
    public int getDefaultInitialValue() {
        return this.defaultInitialValue;
    }

    protected void setDefaultInitialValue(int defaultInitialValue) {
        int old = this.defaultInitialValue;
        this.defaultInitialValue = defaultInitialValue;
        this.firePropertyChanged("defaultInitialValue", old, defaultInitialValue);
    }

    protected abstract int buildDefaultInitialValue();

    @Override
    public int getAllocationSize() {
        return this.specifiedAllocationSize != null ? this.specifiedAllocationSize : this.defaultAllocationSize;
    }

    @Override
    public Integer getSpecifiedAllocationSize() {
        return this.specifiedAllocationSize;
    }

    @Override
    public void setSpecifiedAllocationSize(Integer specifiedAllocationSize) {
        this.setSpecifiedAllocationSize_(specifiedAllocationSize);
        this.xmlGenerator.setAllocationSize(specifiedAllocationSize);
    }

    protected void setSpecifiedAllocationSize_(Integer specifiedAllocationSize) {
        Integer old = this.specifiedAllocationSize;
        this.specifiedAllocationSize = specifiedAllocationSize;
        this.firePropertyChanged("specifiedAllocationSize", old, specifiedAllocationSize);
    }

    @Override
    public int getDefaultAllocationSize() {
        return this.defaultAllocationSize;
    }

    protected void setDefaultAllocationSize(int defaultAllocationSize) {
        int old = this.defaultAllocationSize;
        this.defaultAllocationSize = defaultAllocationSize;
        this.firePropertyChanged("defaultAllocationSize", old, defaultAllocationSize);
    }

    protected int buildDefaultAllocationSize() {
        return 50;
    }

    @Override
    protected boolean isEquivalentTo(Generator generator) {
        return super.isEquivalentTo(generator) && this.isEquivalentTo((DbGenerator)generator);
    }

    protected boolean isEquivalentTo(DbGenerator generator) {
        return ObjectTools.equals((Object)this.specifiedAllocationSize, (Object)generator.getSpecifiedAllocationSize()) && ObjectTools.equals((Object)this.specifiedInitialValue, (Object)generator.getSpecifiedInitialValue());
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.schemaTouches(pos)) {
            return this.getCandidateSchemata();
        }
        if (this.catalogTouches(pos)) {
            return this.getCandidateCatalogs();
        }
        return null;
    }

    protected boolean schemaTouches(int pos) {
        return this.xmlGenerator.schemaTouches(pos);
    }

    protected Iterable<String> getCandidateSchemata() {
        SchemaContainer schemaContainer = this.getDbSchemaContainer();
        return schemaContainer != null ? schemaContainer.getSortedSchemaIdentifiers() : EmptyIterable.instance();
    }

    protected boolean catalogTouches(int pos) {
        return this.xmlGenerator.catalogTouches(pos);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    protected abstract String getSchema();

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    protected abstract String getCatalog();

    public void convertFrom(JavaDbGenerator javaGenerator) {
        super.convertFrom(javaGenerator);
        this.setSpecifiedInitialValue(javaGenerator.getSpecifiedInitialValue());
        this.setSpecifiedAllocationSize(javaGenerator.getSpecifiedAllocationSize());
    }
}

