/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.correction.java.JavaResolutionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindClassResolutionsOperation
implements IRunnableWithProgress {
    String fClassName = null;
    IProject fProject = null;
    AbstractClassResolutionCollector fCollector = null;

    public FindClassResolutionsOperation(IProject project, String className, AbstractClassResolutionCollector collector) {
        this.fProject = project;
        this.fClassName = className;
        this.fCollector = collector;
    }

    public void run(IProgressMonitor monitor) {
        HashSet<IPackageFragment> packagesToExport;
        Collection<ExportPackageDescription> validPackages;
        int idx = this.fClassName.lastIndexOf(46);
        String packageName = idx != -1 ? this.fClassName.substring(0, idx) : null;
        String typeName = this.fClassName.substring(idx + 1);
        if (typeName.length() == 1 && typeName.charAt(0) == '*') {
            typeName = null;
        }
        if ((validPackages = this.getValidPackages(typeName, packageName, packagesToExport = new HashSet<IPackageFragment>(), monitor)) != null) {
            if (validPackages.isEmpty()) {
                for (IPackageFragment packageFragment : packagesToExport) {
                    this.fCollector.addExportPackageResolutionModification(packageFragment);
                }
                return;
            }
            Iterator<ExportPackageDescription> validPackagesIter = validPackages.iterator();
            Set<ExportPackageDescription> visiblePkgs = null;
            boolean allowMultipleFixes = packageName == null;
            while (validPackagesIter.hasNext() && (allowMultipleFixes || !this.fCollector.isDone())) {
                ExportPackageDescription currentPackage;
                if (visiblePkgs == null) {
                    visiblePkgs = this.getVisiblePackages();
                }
                if (visiblePkgs.contains(currentPackage = validPackagesIter.next())) continue;
                this.fCollector.addResolutionModification(this.fProject, currentPackage);
            }
            Set<String> bundleNames = this.getCurrentBundleNames();
            for (ExportPackageDescription currentPackage : validPackages) {
                BundleDescription desc = currentPackage.getExporter();
                if (desc == null || bundleNames.contains(desc.getName())) continue;
                this.fCollector.addRequireBundleModification(this.fProject, currentPackage, 16);
                bundleNames.add(desc.getName());
            }
        }
    }

    private Collection<ExportPackageDescription> getValidPackages(String typeName, String packageName, Set<IPackageFragment> packagesToExport, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        Collection<ExportPackageDescription> validPackages = null;
        ImportPackageSpecification[] importPkgs = null;
        IPluginModelBase model = PluginRegistry.findModel((IProject)this.fProject);
        if (model != null && model.getBundleDescription() != null) {
            importPkgs = model.getBundleDescription().getImportPackages();
        }
        subMonitor.worked(1);
        if (importPkgs != null) {
            if (packageName != null) {
                if (!this.isImportedPackage(packageName, importPkgs)) {
                    validPackages = FindClassResolutionsOperation.getValidPackages(packageName);
                }
                subMonitor.worked(1);
            } else {
                validPackages = this.findValidPackagesContainingSimpleType(typeName, importPkgs, packagesToExport, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        return validPackages;
    }

    private Collection<ExportPackageDescription> findValidPackagesContainingSimpleType(String aTypeName, ImportPackageSpecification[] importPkgs, Set<IPackageFragment> packagesToExport, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IPluginModelBase[] activeModels = PluginRegistry.getActiveModels();
        HashSet<IJavaProject> javaProjects = new HashSet<IJavaProject>(activeModels.length * 2);
        int i = 0;
        while (i < activeModels.length) {
            IJavaProject javaProject;
            IResource resource = activeModels[i].getUnderlyingResource();
            if (resource != null && resource.isAccessible() && (javaProject = JavaCore.create((IProject)resource.getProject())).exists()) {
                javaProjects.add(javaProject);
            }
            ++i;
        }
        final IJavaProject currentJavaProject = JavaCore.create((IProject)this.fProject);
        javaProjects.remove(currentJavaProject);
        try {
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProjects.toArray(new IJavaElement[javaProjects.size()]));
            final HashMap packages = new HashMap();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch aMatch) throws CoreException {
                    IPackageFragment packageFragment;
                    IType type;
                    Object element = aMatch.getElement();
                    if (element instanceof IType && Flags.isPublic((int)(type = (IType)element).getFlags()) && !currentJavaProject.equals(type.getJavaProject()) && (packageFragment = type.getPackageFragment()).exists()) {
                        packages.put(packageFragment.getElementName(), packageFragment);
                    }
                }
            };
            SearchPattern typePattern = SearchPattern.createPattern((String)aTypeName, (int)0, (int)0, (int)8);
            new SearchEngine().search(typePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, requestor, (IProgressMonitor)subMonitor.newChild(1));
            if (!packages.isEmpty()) {
                HashMap<String, ExportPackageDescription> exportDescriptions = new HashMap<String, ExportPackageDescription>(packages.size());
                ExportPackageDescription[] systemPackages = PDECore.getDefault().getModelManager().getState().getState().getSystemPackages();
                int i2 = 0;
                while (i2 < systemPackages.length) {
                    packages.remove(systemPackages[i2].getName());
                    ++i2;
                }
                i2 = 0;
                while (i2 < importPkgs.length) {
                    packages.remove(importPkgs[i2].getName());
                    ++i2;
                }
                ExportPackageDescription[] knownPackages = PDECore.getDefault().getModelManager().getState().getState().getExportedPackages();
                int i3 = 0;
                while (i3 < knownPackages.length) {
                    if (packages.containsKey(knownPackages[i3].getName())) {
                        exportDescriptions.put(knownPackages[i3].getName(), knownPackages[i3]);
                    }
                    ++i3;
                }
                if (exportDescriptions.isEmpty()) {
                    packagesToExport.addAll(packages.values());
                }
                return exportDescriptions.values();
            }
            return Collections.emptySet();
        }
        catch (CoreException coreException) {
            return Collections.emptySet();
        }
    }

    private boolean isImportedPackage(String packageName, ImportPackageSpecification[] importPkgs) {
        int i = 0;
        while (i < importPkgs.length) {
            if (importPkgs[i].getName().equals(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Collection<ExportPackageDescription> getValidPackages(String pkgName) {
        ExportPackageDescription[] knownPackages = PDECore.getDefault().getModelManager().getState().getState().getExportedPackages();
        HashMap<String, ExportPackageDescription> validPackages = new HashMap<String, ExportPackageDescription>();
        int i = 0;
        while (i < knownPackages.length) {
            if (knownPackages[i].getName().equals(pkgName)) {
                validPackages.put(knownPackages[i].getName(), knownPackages[i]);
            }
            ++i;
        }
        if (!validPackages.isEmpty()) {
            knownPackages = PDECore.getDefault().getModelManager().getState().getState().getSystemPackages();
            i = 0;
            while (i < knownPackages.length) {
                validPackages.remove(knownPackages[i].getName());
                ++i;
            }
        }
        return validPackages.values();
    }

    private Set<ExportPackageDescription> getVisiblePackages() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fProject);
        if (base != null) {
            BundleDescription desc = base.getBundleDescription();
            StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
            ExportPackageDescription[] visiblePkgs = helper.getVisiblePackages(desc);
            HashSet<ExportPackageDescription> set = new HashSet<ExportPackageDescription>();
            int i = 0;
            while (i < visiblePkgs.length) {
                set.add(visiblePkgs[i]);
                ++i;
            }
            return set;
        }
        return Collections.emptySet();
    }

    private Set<String> getCurrentBundleNames() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fProject);
        if (base != null) {
            HashSet<String> bundleNames = new HashSet<String>();
            BundleSpecification[] reqBundles = base.getBundleDescription().getRequiredBundles();
            int i = 0;
            while (i < reqBundles.length) {
                bundleNames.add(reqBundles[i].getName());
                ++i;
            }
            return bundleNames;
        }
        return Collections.emptySet();
    }

    public static abstract class AbstractClassResolutionCollector {
        public abstract void addResolutionModification(IProject var1, ExportPackageDescription var2);

        public Object addExportPackageResolutionModification(IPackageFragment aPackage) {
            IResource packageResource;
            if (aPackage.exists() && (packageResource = aPackage.getResource()) != null) {
                return JavaResolutionFactory.createExportPackageProposal(packageResource.getProject(), aPackage, 1, 100);
            }
            return null;
        }

        public Object addRequireBundleModification(IProject project, ExportPackageDescription desc, int relevance) {
            return JavaResolutionFactory.createRequireBundleProposal(project, desc, 1, relevance);
        }

        public Object addSearchRepositoriesModification(String packageName) {
            return JavaResolutionFactory.createSearchRepositoriesProposal(packageName);
        }

        public boolean isDone() {
            return false;
        }
    }
}

