/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContext;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContextManager;
import org.eclipse.pde.internal.ui.editor.build.BuildOutlinePage;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.build.BuildUndoManager;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.PluginExportAction;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class BuildEditor
extends MultiSourceEditor {
    private PluginExportAction fExportAction;

    protected String getEditorID() {
        return "org.eclipse.pde.ui.buildEditor";
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
        manager.monitorFile(file);
    }

    protected InputContextManager createInputContextManager() {
        BuildInputContextManager manager = new BuildInputContextManager(this);
        manager.setUndoManager(new BuildUndoManager(this));
        return manager;
    }

    public void monitoredFileAdded(IFile file) {
        if (this.fInputContextManager == null) {
            return;
        }
        String name = file.getName();
        if (name.equalsIgnoreCase("build.properties") && !this.fInputContextManager.hasContext("build-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.fInputContextManager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, false));
        }
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    protected void createSystemFileContexts(InputContextManager manager, FileStoreEditorInput input) {
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
    }

    protected void addEditorPages() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.addPage((IFormPage)new BuildPage(this));
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("build-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            return "build";
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new BuildSourcePage(editor, title, name);
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new BuildOutlinePage(this);
    }

    protected IPropertySheetPage getPropertySheet(PDEFormPage page) {
        return null;
    }

    public String getTitle() {
        return super.getTitle();
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((IBuildModel)model).isValid() : false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.getClipboard().getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            int i = 0;
            block2: while (true) {
                if (i >= types.length) {
                    return false;
                }
                int j = 0;
                while (true) {
                    if (j >= transfers.length) {
                        ++i;
                        continue block2;
                    }
                    if (transfers[j].isSupportedType(types[i])) {
                        return true;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (SWTError sWTError) {}
        return false;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return null;
        }
        return super.getAdapter(key);
    }

    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof IBuildObject) {
            context = this.fInputContextManager.findContext("build-context");
        }
        return context;
    }

    public void contributeToToolbar(IToolBarManager manager) {
        manager.add((IAction)this.getExportAction());
    }

    private PluginExportAction getExportAction() {
        if (this.fExportAction == null) {
            this.fExportAction = new PluginExportAction(this);
            this.fExportAction.setToolTipText(PDEUIMessages.PluginEditor_exportTooltip);
            this.fExportAction.setImageDescriptor(PDEPluginImages.DESC_EXPORT_PLUGIN_TOOL);
        }
        return this.fExportAction;
    }
}

