/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.ui.PDEPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JARFileFilter
extends ViewerFilter {
    private static final String jarExt = "jar";
    private HashSet<?> fPaths;

    public JARFileFilter() {
        this.fPaths = new HashSet();
    }

    public JARFileFilter(HashSet<?> names) {
        this.fPaths = names;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            return this.isFileValid(((IFile)element).getProjectRelativePath());
        }
        if (!(element instanceof IContainer)) return false;
        try {
            if (!((IContainer)element).isAccessible()) {
                return false;
            }
            IResource[] resources = ((IContainer)element).members();
            int i = 0;
            while (true) {
                if (i >= resources.length) {
                    return false;
                }
                if (this.select(viewer, parent, resources[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return false;
    }

    public boolean isFileValid(IPath path) {
        String ext = path.getFileExtension();
        if (this.isPathValid(path) && ext != null && ext.length() != 0) {
            return ext.equals(jarExt);
        }
        return false;
    }

    public boolean isPathValid(IPath path) {
        return !this.fPaths.contains(path);
    }
}

