/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEDetailsSections;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.category.CategoryDetailsSection;
import org.eclipse.pde.internal.ui.editor.category.CategorySection;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class IUsPage
extends PDEFormPage {
    public static final String PAGE_ID = "ius";
    private CategorySection fCategorySection;
    private SiteFeaturesBlock fBlock = new SiteFeaturesBlock();

    public IUsPage(PDEFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.CategoryPage_header);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(PDEUIMessages.CategoryPage_header);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_CATEGORY_OBJ));
        this.fBlock.createContent(managedForm);
        this.fCategorySection.fireSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.category_editor");
    }

    private IDetailsPage createCategoryDetails() {
        return new PDEDetailsSections(){

            protected PDESection[] createSections(PDEFormPage page, Composite parent) {
                return new PDESection[]{new CategoryDetailsSection(this.getPage(), parent)};
            }

            public String getContextId() {
                return "category-context";
            }
        };
    }

    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.category_editor";
    }

    public class SiteFeaturesBlock
    extends PDEMasterDetailsBlock {
        public SiteFeaturesBlock() {
            super(IUsPage.this);
        }

        protected PDESection createMasterSection(IManagedForm managedForm, Composite parent) {
            IUsPage.this.fCategorySection = new CategorySection(this.getPage(), parent);
            return IUsPage.this.fCategorySection;
        }

        protected void registerPages(DetailsPart detailsPart) {
            detailsPart.setPageProvider(new IDetailsPageProvider(){

                public Object getPageKey(Object object) {
                    if (object instanceof SiteFeatureAdapter) {
                        return SiteFeatureAdapter.class;
                    }
                    if (object instanceof SiteBundleAdapter) {
                        return SiteBundleAdapter.class;
                    }
                    if (object instanceof ISiteCategoryDefinition) {
                        return ISiteCategoryDefinition.class;
                    }
                    return object.getClass();
                }

                public IDetailsPage getPage(Object key) {
                    if (key.equals(ISiteCategoryDefinition.class)) {
                        return IUsPage.this.createCategoryDetails();
                    }
                    return null;
                }
            });
        }
    }
}

