/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.text.IControlHoverContentProvider;
import org.eclipse.pde.internal.ui.editor.text.PDETextHover;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.keys.IBindingService;

public abstract class ExtensionAttributeRow
implements IControlHoverContentProvider {
    protected IContextPart part;
    protected Object att;
    protected IPluginElement input;
    protected boolean blockNotification;
    protected boolean dirty;
    protected IInformationControl fIC;

    public ExtensionAttributeRow(IContextPart part, ISchemaAttribute att) {
        this.part = part;
        this.att = att;
    }

    public ExtensionAttributeRow(IContextPart part, IPluginAttribute att) {
        this.part = part;
        this.att = att;
    }

    public ISchemaAttribute getAttribute() {
        return this.att instanceof ISchemaAttribute ? (ISchemaAttribute)this.att : null;
    }

    public String getName() {
        if (this.att instanceof ISchemaAttribute) {
            return ((ISchemaAttribute)this.att).getName();
        }
        return ((IPluginAttribute)this.att).getName();
    }

    protected int getUse() {
        if (this.att instanceof ISchemaAttribute) {
            return ((ISchemaAttribute)this.att).getUse();
        }
        return 0;
    }

    protected String getDescription() {
        if (this.att instanceof ISchemaAttribute) {
            return ((ISchemaAttribute)this.att).getDescription();
        }
        return "";
    }

    protected String getValue() {
        IPluginAttribute patt;
        String value = "";
        if (this.input != null && (patt = this.input.getAttribute(this.getName())) != null) {
            value = patt.getValue();
        }
        return value;
    }

    protected String getPropertyLabel() {
        String label = this.getName();
        label = this.getUse() == 1 ? String.valueOf(label) + "*:" : String.valueOf(label) + ":";
        return label;
    }

    protected void createLabel(Composite parent, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, this.getPropertyLabel(), 0);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        PDETextHover.addHoverListenerToControl(this.fIC, (Control)label, this);
    }

    protected void createTextHover(Control control) {
        this.fIC = PDETextHover.getInformationControlCreator().createInformationControl(control.getShell());
        this.fIC.setSizeConstraints(300, 600);
    }

    public String getHoverContent(Control c) {
        if (c instanceof Label || c instanceof Hyperlink) {
            String filterBinding = ((IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)).getBestActiveBindingFormattedFor(ActionFactory.FIND.getCommandId());
            String findKeybinding = this.getValue().length() > 0 ? "<br><br>Press " + filterBinding + " within text to filter for this attribute." : "";
            String description = this.getDescription().trim();
            if (description.length() > 0) {
                String first = String.valueOf(description.charAt(0));
                return String.valueOf(this.getDescription().replaceFirst(first, first.toUpperCase())) + findKeybinding;
            }
            return description;
        }
        if (c instanceof Text) {
            String text = ((Text)c).getText();
            ISchemaAttribute sAtt = this.getAttribute();
            String translated = null;
            if (this.input != null && sAtt != null && sAtt.isTranslatable() && text.startsWith("%")) {
                translated = this.input.getResourceString(text);
            }
            if (!text.equals(translated)) {
                return translated;
            }
        }
        return null;
    }

    public void createContents(Composite parent, FormToolkit toolkit, int span) {
        this.createTextHover((Control)parent);
    }

    protected abstract void update();

    public abstract void commit();

    public abstract void setFocus();

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        this.dirty = true;
        this.part.fireSaveNeeded();
    }

    public void dispose() {
        if (this.fIC != null) {
            this.fIC.dispose();
        }
    }

    public void setInput(IPluginElement input) {
        this.input = input;
        this.update();
    }

    protected IProject getProject() {
        return this.part.getPage().getPDEEditor().getCommonProject();
    }
}

