/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.views.imagebrowser.IImageTarget;
import org.eclipse.pde.internal.ui.views.imagebrowser.ImageElement;
import org.eclipse.pde.internal.ui.views.imagebrowser.repositories.AbstractRepository;

public class WorkspaceRepository
extends AbstractRepository {
    private List<IProject> fProjects = null;

    public WorkspaceRepository(IImageTarget target) {
        super(target);
    }

    protected boolean populateCache(final IProgressMonitor monitor) {
        if (this.fProjects == null) {
            this.initialize(monitor);
        }
        if (!this.fProjects.isEmpty()) {
            IProject project = this.fProjects.remove(0);
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            if (manifest.exists()) {
                try {
                    final String pluginName = this.getPluginName(manifest.getContents());
                    project.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            switch (proxy.getType()) {
                                case 2: 
                                case 4: {
                                    return true;
                                }
                                case 1: {
                                    if (!WorkspaceRepository.this.isImageName(proxy.getName())) break;
                                    try {
                                        IFile resource = (IFile)proxy.requestResource();
                                        WorkspaceRepository.this.addImageElement(new ImageElement(WorkspaceRepository.this.createImageData(resource), pluginName, resource.getProjectRelativePath().toPortableString()));
                                    }
                                    catch (Exception exception) {}
                                    if (!monitor.isCanceled()) break;
                                    throw new OperationCanceledException();
                                }
                            }
                            return false;
                        }
                    }, 2, 10);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
                catch (IOException e) {
                    PDEPlugin.log(e);
                }
            }
            return true;
        }
        return false;
    }

    private void initialize(IProgressMonitor monitor) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.fProjects = projects != null ? new ArrayList<IProject>(Arrays.asList(projects)) : Collections.emptyList();
    }

    public String toString() {
        return "Workspace";
    }
}

