/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.ModelFileAdapter;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.refactoring.PDERefactoringAction;
import org.eclipse.pde.internal.ui.refactoring.RefactoringActionFactory;
import org.eclipse.pde.internal.ui.util.SourcePluginFilter;
import org.eclipse.pde.internal.ui.views.dependencies.OpenPluginDependenciesAction;
import org.eclipse.pde.internal.ui.views.dependencies.OpenPluginReferencesAction;
import org.eclipse.pde.internal.ui.views.plugins.CopyToClipboardAction;
import org.eclipse.pde.internal.ui.views.plugins.ImportActionGroup;
import org.eclipse.pde.internal.ui.views.plugins.JavaSearchActionGroup;
import org.eclipse.pde.internal.ui.views.plugins.PluginsContentProvider;
import org.eclipse.pde.internal.ui.views.plugins.PluginsDragAdapter;
import org.eclipse.pde.internal.ui.views.plugins.PluginsLabelProvider;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class PluginsView
extends ViewPart
implements IPluginModelListener {
    private static final String DEFAULT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static final String HIDE_WRKSPC = "hideWorkspace";
    private static final String HIDE_EXENABLED = "hideEnabledExternal";
    private static final String SHOW_EXDISABLED = "showDisabledExternal";
    private TreeViewer fTreeViewer;
    private DrillDownAdapter fDrillDownAdapter;
    private IPropertyChangeListener fPropertyListener;
    private Action fOpenAction;
    private Action fHideExtDisabledFilterAction;
    private Action fHideExtEnabledFilterAction;
    private Action fHideWorkspaceFilterAction;
    private Action fOpenManifestAction;
    private Action fOpenSchemaAction;
    private Action fOpenSystemEditorAction;
    private Action fOpenClassFileAction;
    private Action fOpenTextEditorAction;
    private Action fSelectDependentAction;
    private Action fSelectInJavaSearchAction;
    private Action fSelectAllAction;
    private PDERefactoringAction fRefactorAction;
    private CollapseAllAction fCollapseAllAction;
    private DisabledFilter fHideExtEnabledFilter = new DisabledFilter(true);
    private DisabledFilter fHideExtDisabledFilter = new DisabledFilter(false);
    private WorkspaceFilter fHideWorkspaceFilter = new WorkspaceFilter();
    private SourcePluginFilter fSourcePluginFilter = new SourcePluginFilter();
    private JavaFilter fJavaFilter = new JavaFilter();
    private CopyToClipboardAction fCopyAction;
    private Clipboard fClipboard;
    private Object fRoot = null;

    public PluginsView() {
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("Preferences.MainPage.showObjects")) {
                    PluginsView.this.fTreeViewer.refresh();
                }
            }
        };
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getSearchablePluginsManager().removePluginModelListener((IPluginModelListener)this);
        PDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent, 268436226);
        this.fDrillDownAdapter = new DrillDownAdapter(this.fTreeViewer);
        this.fTreeViewer.setContentProvider((IContentProvider)new PluginsContentProvider(this));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new PluginsLabelProvider());
        this.fTreeViewer.setComparator((ViewerComparator)new ListUtil.PluginComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PendingUpdateAdapter) {
                    return -1;
                }
                if (e2 instanceof PendingUpdateAdapter) {
                    return 1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.initDragAndDrop();
        this.makeActions();
        this.initFilters();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.contributeToActionBars(actionBars);
        this.registerGlobalActions(actionBars);
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                PluginsView.this.handleSelectionChanged(e.getSelection());
            }
        });
        PDECore.getDefault().getSearchablePluginsManager().addPluginModelListener((IPluginModelListener)this);
        this.fRoot = this.getDeferredTreeRoot();
        this.fTreeViewer.setInput(this.fRoot);
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fTreeViewer.getControl(), "org.eclipse.pde.doc.user.plugins_view");
    }

    private void contributeToActionBars(IActionBars actionBars) {
        this.contributeToLocalToolBar(actionBars.getToolBarManager());
        this.contributeToDropDownMenu(actionBars.getMenuManager());
    }

    private void contributeToDropDownMenu(IMenuManager manager) {
        manager.add((IAction)this.fHideWorkspaceFilterAction);
        manager.add((IAction)this.fHideExtEnabledFilterAction);
        manager.add((IAction)this.fHideExtDisabledFilterAction);
    }

    private void contributeToLocalToolBar(IToolBarManager manager) {
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCollapseAllAction);
    }

    private void registerGlobalActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)new Action(){

            public void run() {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)PluginsView.this.fTreeViewer.getSelection();
                if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof IPluginModelBase) {
                    PluginsView.this.fRefactorAction.setSelection(element);
                    PluginsView.this.fRefactorAction.run();
                    return;
                }
                Display.getDefault().beep();
            }
        });
    }

    private void makeActions() {
        this.fClipboard = new Clipboard(this.fTreeViewer.getTree().getDisplay());
        this.fOpenAction = new Action(){

            public void run() {
                PluginsView.this.handleDoubleClick();
            }
        };
        this.fOpenAction.setText(PDEUIMessages.PluginsView_open);
        this.fHideExtDisabledFilterAction = new Action(){

            public void run() {
                boolean checked = PluginsView.this.fHideExtDisabledFilterAction.isChecked();
                if (checked) {
                    PluginsView.this.fTreeViewer.removeFilter((ViewerFilter)PluginsView.this.fHideExtDisabledFilter);
                } else {
                    PluginsView.this.fTreeViewer.addFilter((ViewerFilter)PluginsView.this.fHideExtDisabledFilter);
                }
                PluginsView.this.getSettings().put(PluginsView.SHOW_EXDISABLED, checked);
                PluginsView.this.updateContentDescription();
            }
        };
        this.fHideExtDisabledFilterAction.setText(PDEUIMessages.PluginsView_showDisabled);
        this.fHideExtEnabledFilterAction = new Action(){

            public void run() {
                boolean checked = PluginsView.this.fHideExtEnabledFilterAction.isChecked();
                if (checked) {
                    PluginsView.this.fTreeViewer.removeFilter((ViewerFilter)PluginsView.this.fHideExtEnabledFilter);
                } else {
                    PluginsView.this.fTreeViewer.addFilter((ViewerFilter)PluginsView.this.fHideExtEnabledFilter);
                }
                PluginsView.this.getSettings().put(PluginsView.HIDE_EXENABLED, !checked);
                PluginsView.this.updateContentDescription();
            }
        };
        this.fHideExtEnabledFilterAction.setText(PDEUIMessages.PluginsView_showEnabled);
        this.fHideWorkspaceFilterAction = new Action(){

            public void run() {
                boolean checked = PluginsView.this.fHideWorkspaceFilterAction.isChecked();
                if (checked) {
                    PluginsView.this.fTreeViewer.removeFilter((ViewerFilter)PluginsView.this.fHideWorkspaceFilter);
                } else {
                    PluginsView.this.fTreeViewer.addFilter((ViewerFilter)PluginsView.this.fHideWorkspaceFilter);
                }
                PluginsView.this.getSettings().put(PluginsView.HIDE_WRKSPC, !checked);
                PluginsView.this.updateContentDescription();
            }
        };
        this.fHideWorkspaceFilterAction.setText(PDEUIMessages.PluginsView_showWorkspace);
        this.fOpenTextEditorAction = new Action(){

            public void run() {
                PluginsView.this.handleOpenTextEditor(PluginsView.this.getSelectedFile(), null);
            }
        };
        this.fOpenTextEditorAction.setText(PDEUIMessages.PluginsView_textEditor);
        this.fOpenTextEditorAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.fOpenSystemEditorAction = new Action(){

            public void run() {
                PluginsView.this.handleOpenSystemEditor(PluginsView.this.getSelectedFile());
            }
        };
        this.fOpenSystemEditorAction.setText(PDEUIMessages.PluginsView_systemEditor);
        this.fOpenManifestAction = new Action(){

            public void run() {
                PluginsView.this.handleOpenManifestEditor(PluginsView.this.getSelectedFile());
            }
        };
        this.fOpenManifestAction.setText(PDEUIMessages.PluginsView_manifestEditor);
        this.fOpenSchemaAction = new Action(){

            public void run() {
                PluginsView.this.handleOpenSchemaEditor(PluginsView.this.getSelectedFile());
            }
        };
        this.fOpenSchemaAction.setText(PDEUIMessages.PluginsView_schemaEditor);
        this.fCopyAction = new CopyToClipboardAction(this.fClipboard);
        this.fCopyAction.setText(PDEUIMessages.PluginsView_copy);
        this.fSelectDependentAction = new Action(){

            public void run() {
                PluginsView.this.handleSelectDependencies();
            }
        };
        this.fSelectDependentAction.setText(PDEUIMessages.PluginsView_dependentPlugins);
        this.fSelectInJavaSearchAction = new Action(){

            public void run() {
                PluginsView.this.handleSelectInJavaSearch();
            }
        };
        this.fSelectInJavaSearchAction.setText(PDEUIMessages.PluginsView_pluginsInJavaSearch);
        this.fSelectAllAction = new Action(){

            public void run() {
                super.run();
                PluginsView.this.fTreeViewer.getTree().selectAll();
            }
        };
        this.fSelectAllAction.setText(PDEUIMessages.PluginsView_SelectAllAction_label);
        this.fCollapseAllAction = new CollapseAllAction();
        this.fOpenClassFileAction = new OpenAction((IWorkbenchSite)this.getViewSite());
        this.fRefactorAction = RefactoringActionFactory.createRefactorPluginIdAction();
    }

    private FileAdapter getSelectedFile() {
        Object obj = this.getSelectedObject();
        if (obj instanceof FileAdapter) {
            return (FileAdapter)obj;
        }
        return null;
    }

    private IPluginModelBase getEnclosingModel() {
        FileAdapter parent;
        FileAdapter file;
        Object obj = this.getSelectedObject();
        if (obj == null) {
            return null;
        }
        if (obj instanceof IPluginModelBase) {
            return (IPluginModelBase)obj;
        }
        if (obj instanceof FileAdapter && (file = (FileAdapter)obj).isManifest() && (parent = file.getParent()) instanceof ModelFileAdapter) {
            return ((ModelFileAdapter)parent).getModel();
        }
        return null;
    }

    private Object getSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        boolean allowRefactoring = false;
        if (selection.size() == 1) {
            IPluginModelBase entry;
            Object sobj = selection.getFirstElement();
            boolean addSeparator = false;
            if (sobj instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)sobj;
                File file = new File(model.getInstallLocation());
                if (file.isFile() || model.getUnderlyingResource() != null) {
                    manager.add((IAction)this.fOpenAction);
                }
                if (model.getUnderlyingResource() != null) {
                    allowRefactoring = true;
                }
            }
            if (sobj instanceof FileAdapter && !((FileAdapter)sobj).isDirectory()) {
                manager.add((IAction)this.fOpenAction);
                MenuManager openWithMenu = new MenuManager(PDEUIMessages.PluginsView_openWith);
                this.fillOpenWithMenu((IMenuManager)openWithMenu, sobj);
                manager.add((IContributionItem)openWithMenu);
                addSeparator = true;
            }
            if (PluginsView.isOpenableStorage(sobj)) {
                manager.add((IAction)this.fOpenAction);
                addSeparator = true;
            }
            if (sobj instanceof IClassFile) {
                manager.add((IAction)this.fOpenClassFileAction);
                addSeparator = true;
            }
            if ((entry = this.getEnclosingModel()) != null) {
                Action action = new OpenPluginDependenciesAction(entry);
                action.setText(PDEUIMessages.PluginsView_openDependencies);
                action.setImageDescriptor(PDEPluginImages.DESC_CALLEES);
                manager.add((IAction)action);
                manager.add((IContributionItem)new Separator());
                action = new OpenPluginReferencesAction(entry);
                action.setText(PDEUIMessages.SearchAction_references);
                action.setImageDescriptor(PDEPluginImages.DESC_CALLERS);
                manager.add((IAction)action);
                addSeparator = true;
            }
            if (addSeparator) {
                manager.add((IContributionItem)new Separator());
            }
        }
        if (selection.size() > 0) {
            ActionGroup actionGroup;
            if (this.isShowInApplicable()) {
                String keyBinding;
                String showInLabel = PDEUIMessages.PluginsView_showIn;
                IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
                if (bindingService != null && (keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
                    showInLabel = String.valueOf(showInLabel) + '\t' + keyBinding;
                }
                MenuManager showInMenu = new MenuManager(showInLabel);
                showInMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getViewSite().getWorkbenchWindow()));
                manager.add((IContributionItem)showInMenu);
                manager.add((IContributionItem)new Separator());
            }
            if (ImportActionGroup.canImport(selection)) {
                actionGroup = new ImportActionGroup();
                actionGroup.setContext(new ActionContext((ISelection)selection));
                actionGroup.fillContextMenu(manager);
                manager.add((IContributionItem)new Separator());
            }
            actionGroup = new JavaSearchActionGroup();
            actionGroup.setContext(new ActionContext((ISelection)selection));
            actionGroup.fillContextMenu(manager);
        }
        this.fCopyAction.setSelection(selection);
        manager.add((IAction)this.fCopyAction);
        MenuManager selectionMenu = new MenuManager(PDEUIMessages.PluginsView_select);
        manager.add((IContributionItem)selectionMenu);
        if (selection.size() > 0) {
            selectionMenu.add((IAction)this.fSelectDependentAction);
        }
        selectionMenu.add((IAction)this.fSelectInJavaSearchAction);
        selectionMenu.add((IAction)this.fSelectAllAction);
        manager.add((IContributionItem)new Separator());
        if (allowRefactoring) {
            this.fRefactorAction.setSelection(selection.getFirstElement());
            manager.add((IAction)this.fRefactorAction);
            manager.add((IContributionItem)new Separator());
        }
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public boolean isShowInApplicable() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        for (Object obj : selection) {
            if (!(obj instanceof IPluginModelBase)) {
                return false;
            }
            if (((IPluginModelBase)obj).getUnderlyingResource() != null) continue;
            return false;
        }
        return true;
    }

    private void fillOpenWithMenu(IMenuManager manager, Object obj) {
        FileAdapter adapter = (FileAdapter)obj;
        String editorId = adapter.getEditorId();
        String fileName = adapter.getFile().getName();
        String lcFileName = fileName.toLowerCase(Locale.ENGLISH);
        ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName);
        if (lcFileName.equals("plugin.xml") || lcFileName.equals("fragment.xml") || lcFileName.equals(ICoreConstants.MANIFEST_FILENAME_LOWER_CASE)) {
            this.fOpenManifestAction.setImageDescriptor(desc);
            manager.add((IAction)this.fOpenManifestAction);
            manager.add((IContributionItem)new Separator());
            this.fOpenManifestAction.setChecked(editorId != null && editorId.equals("org.eclipse.pde.ui.manifestEditor"));
        }
        if (lcFileName.endsWith(".mxsd") || lcFileName.endsWith(".exsd")) {
            this.fOpenSchemaAction.setImageDescriptor(desc);
            manager.add((IAction)this.fOpenSchemaAction);
            manager.add((IContributionItem)new Separator());
            this.fOpenSchemaAction.setChecked(editorId != null && editorId.equals("org.eclipse.pde.ui.schemaEditor"));
        }
        manager.add((IAction)this.fOpenTextEditorAction);
        this.fOpenTextEditorAction.setChecked(editorId == null || editorId.equals(DEFAULT_EDITOR_ID));
        this.fOpenSystemEditorAction.setImageDescriptor(desc);
        this.fOpenSystemEditorAction.setChecked(editorId != null && editorId.equals("@system"));
        manager.add((IAction)this.fOpenSystemEditorAction);
    }

    protected void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        this.fTreeViewer.addDragSupport(ops, transfers, (DragSourceListener)new PluginsDragAdapter((ISelectionProvider)this.fTreeViewer));
    }

    private IDialogSettings getSettings() {
        IDialogSettings master = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection("pluginsView");
        if (section == null) {
            section = master.addNewSection("pluginsView");
        }
        return section;
    }

    private void initFilters() {
        boolean hideDisabledExternal;
        IDialogSettings settings = this.getSettings();
        this.fTreeViewer.addFilter((ViewerFilter)this.fJavaFilter);
        boolean hideWorkspace = settings.getBoolean(HIDE_WRKSPC);
        boolean hideEnabledExternal = settings.getBoolean(HIDE_EXENABLED);
        boolean bl = hideDisabledExternal = !settings.getBoolean(SHOW_EXDISABLED);
        if (hideWorkspace) {
            this.fTreeViewer.addFilter((ViewerFilter)this.fHideWorkspaceFilter);
        }
        if (hideEnabledExternal) {
            this.fTreeViewer.addFilter((ViewerFilter)this.fHideExtEnabledFilter);
        }
        if (hideDisabledExternal) {
            this.fTreeViewer.addFilter((ViewerFilter)this.fHideExtDisabledFilter);
        }
        this.fHideWorkspaceFilterAction.setChecked(!hideWorkspace);
        this.fHideExtEnabledFilterAction.setChecked(!hideEnabledExternal);
        this.fHideExtDisabledFilterAction.setChecked(!hideDisabledExternal);
        this.fTreeViewer.addFilter((ViewerFilter)this.fSourcePluginFilter);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PluginsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fTreeViewer);
    }

    private void handleDoubleClick() {
        Object obj = this.getSelectedObject();
        if (obj instanceof IPluginModelBase) {
            boolean expanded = false;
            if (((IPluginModelBase)obj).getUnderlyingResource() == null) {
                expanded = this.fTreeViewer.getExpandedState(obj);
                this.fTreeViewer.setExpandedState(obj, !expanded);
            }
            if (this.fTreeViewer.getExpandedState(obj) == expanded) {
                ManifestEditor.openPluginEditor((IPluginModelBase)obj);
            }
        } else if (obj instanceof FileAdapter) {
            FileAdapter adapter = (FileAdapter)obj;
            if (adapter.isDirectory()) {
                this.fTreeViewer.setExpandedState((Object)adapter, !this.fTreeViewer.getExpandedState((Object)adapter));
                return;
            }
            String editorId = adapter.getEditorId();
            if (editorId != null && editorId.equals("@system")) {
                this.handleOpenSystemEditor(adapter);
            } else {
                this.handleOpenTextEditor(adapter, editorId);
            }
        } else if (obj instanceof IClassFile) {
            this.fOpenClassFileAction.run();
        } else if (PluginsView.isOpenableStorage(obj)) {
            this.handleOpenStorage((IStorage)obj);
        }
    }

    private static boolean isOpenableStorage(Object storage) {
        if (storage instanceof IJarEntryResource) {
            return ((IJarEntryResource)storage).isFile();
        }
        return storage instanceof IStorage;
    }

    private void handleOpenStorage(IStorage obj) {
        IWorkbenchPage page = PDEPlugin.getActivePage();
        JarEntryEditorInput input = new JarEntryEditorInput(obj);
        try {
            page.openEditor((IEditorInput)input, DEFAULT_EDITOR_ID);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleSelectDependencies() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        IPluginModelBase[] models = new IPluginModelBase[selection.size()];
        System.arraycopy(selection.toArray(), 0, models, 0, selection.size());
        Set set = DependencyManager.getSelfandDependencies((IPluginModelBase[])models, (String[])new String[]{"org.eclipse.ui.workbench.compatibility"});
        Object[] symbolicNames = set.toArray();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>(set.size());
        int i = 0;
        while (i < symbolicNames.length) {
            IPluginModelBase model = PluginRegistry.findModel((String)symbolicNames[i].toString());
            if (model != null) {
                result.add(model);
            }
            ++i;
        }
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(result.toArray()));
    }

    private void handleSelectInJavaSearch() {
        PluginsContentProvider provider = (PluginsContentProvider)this.fTreeViewer.getContentProvider();
        Object[] elements = provider.getElements(this.fTreeViewer.getInput());
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IPluginModelBase) {
                String id = ((IPluginModelBase)element).getPluginBase().getId();
                if (PDECore.getDefault().getSearchablePluginsManager().isInJavaSearch(id)) {
                    result.add(element);
                }
            }
            ++i;
        }
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(result.toArray()));
    }

    private void handleOpenTextEditor(FileAdapter adapter, String editorId) {
        if (adapter == null) {
            return;
        }
        IWorkbenchPage page = PDEPlugin.getActivePage();
        if (editorId == null) {
            if (adapter.isManifest()) {
                editorId = "org.eclipse.pde.ui.manifestEditor";
            } else if (adapter.isSchema()) {
                editorId = "org.eclipse.pde.ui.schemaEditor";
            }
        }
        try {
            if (editorId == null || editorId.equals("@system")) {
                editorId = DEFAULT_EDITOR_ID;
            }
            IFileStore store = EFS.getStore((URI)adapter.getFile().toURI());
            FileStoreEditorInput in = new FileStoreEditorInput(store);
            page.openEditor((IEditorInput)in, editorId);
            adapter.setEditorId(editorId);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleOpenManifestEditor(FileAdapter adapter) {
        this.handleOpenTextEditor(adapter, "org.eclipse.pde.ui.manifestEditor");
    }

    private void handleOpenSchemaEditor(FileAdapter adapter) {
        this.handleOpenTextEditor(adapter, "org.eclipse.pde.ui.schemaEditor");
    }

    private void handleOpenSystemEditor(FileAdapter adapter) {
        if (adapter == null) {
            return;
        }
        File localFile = null;
        try {
            localFile = this.getLocalCopy(adapter.getFile());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
            return;
        }
        final File file = localFile;
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.fTreeViewer.getTree().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                String path = file.getAbsolutePath();
                result[0] = Program.launch((String)path);
            }
        });
        if (!result[0]) {
            PDEPlugin.logException(new PartInitException(NLS.bind((String)PDEUIMessages.PluginsView_unableToOpen, (Object)file.getName())));
        } else {
            adapter.setEditorId("@system");
        }
    }

    private File getLocalCopy(File file) throws IOException {
        String prefix;
        String fileName = file.getName();
        String suffix = null;
        int dotLoc = fileName.indexOf(46);
        if (dotLoc != -1) {
            prefix = fileName.substring(0, dotLoc);
            suffix = fileName.substring(dotLoc);
        } else {
            prefix = fileName;
        }
        File tmpFile = File.createTempFile(prefix, suffix);
        tmpFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpFile);
        FileInputStream fis = new FileInputStream(file);
        byte[] cbuffer = new byte[1024];
        int read = 0;
        while (read != -1) {
            read = fis.read(cbuffer);
            if (read == -1) continue;
            fos.write(cbuffer, 0, read);
        }
        fos.flush();
        fos.close();
        fis.close();
        tmpFile.setReadOnly();
        return tmpFile;
    }

    private void handleSelectionChanged(ISelection selection) {
        String text = "";
        Object obj = this.getSelectedObject();
        if (obj instanceof IPluginModelBase) {
            text = ((IPluginModelBase)obj).getInstallLocation();
        }
        if (obj instanceof FileAdapter) {
            text = ((FileAdapter)obj).getFile().getAbsolutePath();
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(text);
    }

    private void hookDoubleClickAction() {
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PluginsView.this.handleDoubleClick();
            }
        });
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    void updateTitle(Object newInput) {
        IConfigurationElement config = this.getConfigurationElement();
        if (config == null) {
            return;
        }
        if (newInput == null || newInput.equals(PDECore.getDefault().getModelManager())) {
            this.updateContentDescription();
            this.setTitleToolTip(this.getTitle());
        } else {
            this.setTitleToolTip(this.getInputPath(newInput));
        }
    }

    private String getInputPath(Object input) {
        if (input instanceof FileAdapter) {
            return "file: " + ((FileAdapter)input).getFile().getAbsolutePath();
        }
        if (input instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)input;
            return "plugin: " + model.getInstallLocation();
        }
        return "";
    }

    protected void updateContentDescription() {
        String total = null;
        String visible = null;
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        if (manager.isInitialized()) {
            total = Integer.toString(PluginRegistry.getAllModels().length);
            visible = Integer.toString(this.fTreeViewer.getTree().getItemCount());
        } else {
            total = PDEUIMessages.PluginsView_TotalPlugins_unknown;
            visible = "0";
        }
        this.setContentDescription(NLS.bind((String)PDEUIMessages.PluginsView_description, (Object)visible, (Object)total));
    }

    public void modelsChanged(final PluginModelDelta delta) {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

            public void run() {
                int kind = delta.getKind();
                if (PluginsView.this.fTreeViewer.getTree().isDisposed()) {
                    return;
                }
                if ((kind & 4) != 0 || (kind & 2) != 0) {
                    PluginsView.this.fTreeViewer.refresh();
                } else if ((kind & 1) != 0) {
                    ModelEntry[] added = delta.getAddedEntries();
                    int i = 0;
                    while (i < added.length) {
                        IPluginModelBase[] models = PluginsView.this.getModels(added[i]);
                        int j = 0;
                        while (j < models.length) {
                            if (PluginsView.this.isVisible(models[j])) {
                                PluginsView.this.fTreeViewer.add(PluginsView.this.fRoot, (Object)models[j]);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                PluginsView.this.updateContentDescription();
            }
        });
    }

    private IPluginModelBase[] getModels(ModelEntry entry) {
        return entry.hasWorkspaceModels() ? entry.getWorkspaceModels() : entry.getExternalModels();
    }

    private boolean isVisible(IPluginModelBase entry) {
        ViewerFilter[] filters = this.fTreeViewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            if (!filters[i].select((Viewer)this.fTreeViewer, this.fRoot, (Object)entry)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (this.isShowInApplicable()) {
            if (adapter == IShowInSource.class && this.isShowInApplicable()) {
                return this.getShowInSource();
            }
            if (adapter == IShowInTargetList.class) {
                return this.getShowInTargetList();
            }
        }
        return super.getAdapter(adapter);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                StructuredSelection resources;
                ArrayList<IResource> resourceList = new ArrayList<IResource>();
                IStructuredSelection selection = (IStructuredSelection)PluginsView.this.fTreeViewer.getSelection();
                if (selection.isEmpty()) {
                    resources = null;
                } else {
                    for (Object obj : selection) {
                        if (!(obj instanceof IPluginModelBase)) continue;
                        resourceList.add(((IPluginModelBase)obj).getUnderlyingResource());
                    }
                    resources = new StructuredSelection(resourceList);
                }
                return new ShowInContext(PluginsView.this.fTreeViewer.getInput(), resources);
            }
        };
    }

    protected IShowInTargetList getShowInTargetList() {
        return new IShowInTargetList(){

            public String[] getShowInTargetIds() {
                return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.navigator.ProjectExplorer"};
            }
        };
    }

    private IDeferredWorkbenchAdapter getDeferredTreeRoot() {
        return new IDeferredWorkbenchAdapter(){

            public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
                Object[] bases = this.getChildren(object);
                collector.add(bases, monitor);
                monitor.done();
            }

            public ISchedulingRule getRule(Object object) {
                return null;
            }

            public boolean isContainer() {
                return true;
            }

            public Object[] getChildren(Object o) {
                return PDECore.getDefault().getModelManager().getAllModels();
            }

            public ImageDescriptor getImageDescriptor(Object object) {
                return null;
            }

            public String getLabel(Object o) {
                return PDEUIMessages.PluginsView_deferredLabel0;
            }

            public Object getParent(Object o) {
                return null;
            }
        };
    }

    class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setText(PDEUIMessages.PluginsView_CollapseAllAction_label);
            this.setDescription(PDEUIMessages.PluginsView_CollapseAllAction_description);
            this.setToolTipText(PDEUIMessages.PluginsView_CollapseAllAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);
        }

        public void run() {
            PluginsView.this.fTreeViewer.collapseAll();
        }
    }

    class DisabledFilter
    extends ViewerFilter {
        boolean fEnabled;

        DisabledFilter(boolean enabled) {
            this.fEnabled = enabled;
        }

        public boolean select(Viewer v, Object parent, Object element) {
            if (element instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)element;
                return model.getUnderlyingResource() != null || model.isEnabled() != this.fEnabled;
            }
            return true;
        }
    }

    class JavaFilter
    extends ViewerFilter {
        JavaFilter() {
        }

        public boolean select(Viewer v, Object parent, Object element) {
            if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                try {
                    return packageFragment.hasChildren();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            return true;
        }
    }

    class WorkspaceFilter
    extends ViewerFilter {
        WorkspaceFilter() {
        }

        public boolean select(Viewer v, Object parent, Object element) {
            if (element instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)element;
                return model.getUnderlyingResource() == null;
            }
            return true;
        }
    }
}

